/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAReader;
import de.businesslogics.format.dta.DTAWriter;
import de.businesslogics.format.dta.DTAZVMessage;
import java.io.IOException;

public class DTAZVCapitalMessage
extends DTAZVMessage {
    public static char SERVICE_TYPE = (char)50;
    public static char CAPITAL_INCOME_TYPE = (char)52;
    protected static byte[] W_HEADER = "0256W".getBytes();
    protected static byte[] W_RESERVE = "                                                                           ".getBytes();
    private String country;
    private String description;
    private String investmentCountry;
    private char voucherType;
    private int serviceCode;
    private long amount;

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setInvestmentCountry(String investmentCountry) {
        this.investmentCountry = investmentCountry;
    }

    public String getInvestmentCountry() {
        return this.investmentCountry;
    }

    public void setServiceCode(int serviceCode) {
        this.serviceCode = serviceCode;
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public void setVoucherType(char voucherType) {
        this.voucherType = voucherType;
    }

    public char getVoucherType() {
        return this.voucherType;
    }

    public static DTAZVCapitalMessage readFrom(DTAReader r) throws IOException {
        DTAZVCapitalMessage c = new DTAZVCapitalMessage();
        c.voucherType = r.readChar();
        c.serviceCode = r.readInt(3);
        r.skip(7);
        c.country = r.readString(3);
        r.skip(7);
        c.investmentCountry = r.readString(3);
        c.amount = r.readLong(12);
        c.description = r.readString(140);
        r.skip(W_RESERVE.length);
        return c;
    }

    @Override
    public void writeTo(DTAWriter w) throws IOException {
        w.write(W_HEADER);
        w.write(this.voucherType);
        w.write(this.serviceCode, 3);
        w.write(DTAZVCapitalMessage.getCountry(this.country), 7);
        w.write(this.country, 3);
        w.write(DTAZVCapitalMessage.getCountry(this.investmentCountry), 7);
        w.write(this.investmentCountry, 3);
        w.write(this.amount, 12);
        w.write(this.description, 140);
        w.write(W_RESERVE);
    }
}

