/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DTAWriter {
    protected SimpleDateFormat YYMMDD = new SimpleDateFormat("yyMMdd");
    protected SimpleDateFormat YYMM = new SimpleDateFormat("yyMM");
    protected SimpleDateFormat DDMMYY = new SimpleDateFormat("ddMMyy");
    protected SimpleDateFormat DDMMYYYY = new SimpleDateFormat("ddMMyyyy");
    private OutputStream out;

    public DTAWriter(OutputStream out) {
        this.out = out;
    }

    public void write(long l, int size) throws IOException {
        String s = String.valueOf(l);
        if (s.length() > size) {
            this.out.write(s.getBytes(), 0, size);
        } else {
            for (int i = s.length(); i < size; ++i) {
                this.out.write(48);
            }
            this.out.write(s.getBytes());
        }
    }

    public void write(int v, int size) throws IOException {
        String s = String.valueOf(v);
        if (s.length() > size) {
            this.out.write(s.getBytes(), 0, size);
        } else {
            for (int i = s.length(); i < size; ++i) {
                this.out.write(48);
            }
            this.out.write(s.getBytes());
        }
    }

    public void write(byte v, int size) throws IOException {
        String s = String.valueOf(v);
        if (s.length() > size) {
            this.out.write(s.getBytes(), 0, size);
        } else {
            for (int i = s.length(); i < size; ++i) {
                this.out.write(48);
            }
            this.out.write(s.getBytes());
        }
    }

    public void write(String s, int size) throws IOException {
        if (s == null) {
            for (int i = 0; i < size; ++i) {
                this.out.write(32);
            }
        } else {
            byte[] b = s.toUpperCase().getBytes();
            if (b.length > size) {
                this.out.write(b, 0, size);
            } else {
                this.out.write(b);
                for (int i = b.length; i < size; ++i) {
                    this.out.write(32);
                }
            }
        }
    }

    public void writeBlanks(int countBlanks) throws IOException {
        for (int i = 0; i < countBlanks; ++i) {
            this.out.write(32);
        }
    }

    public void write(boolean b) throws IOException {
        if (b) {
            this.out.write(74);
        } else {
            this.out.write(78);
        }
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(char c) throws IOException {
        this.out.write(c);
    }

    public void write(BigDecimal d, int intPart, int fractionPart) throws IOException {
        int i;
        if (d == null) {
            this.write(0, intPart + fractionPart);
            return;
        }
        String s = d.toString();
        int pos = s.indexOf(46);
        byte[] b = null;
        b = pos != -1 ? s.substring(0, pos).getBytes() : s.getBytes();
        for (i = b.length; i < intPart; ++i) {
            this.out.write(48);
        }
        this.out.write(b);
        if (pos != -1) {
            b = s.substring(pos + 1).getBytes();
            this.out.write(b);
            for (i = b.length; i < fractionPart; ++i) {
                this.out.write(48);
            }
        } else {
            for (i = 0; i < fractionPart; ++i) {
                this.out.write(48);
            }
        }
    }

    public void writeDDMMYY(Date date) throws IOException {
        this.writeDate(this.DDMMYY, date);
    }

    public void writeDDMMYYYY(Date date) throws IOException {
        this.writeDate(this.DDMMYYYY, date);
    }

    public void writeYYMM(Date date) throws IOException {
        this.writeDate(this.YYMM, date);
    }

    public void writeYYMMDD(Date date) throws IOException {
        this.writeDate(this.YYMMDD, date);
    }

    private void writeDate(SimpleDateFormat df, Date date) throws IOException {
        if (date == null) {
            this.out.write(df.format(new Date()).getBytes());
        } else {
            this.out.write(df.format(date).getBytes());
        }
    }

    public void close() throws IOException {
        this.out.close();
    }
}

