/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.nio.charset.DTAUS;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTAUtil {
    public static String BLZ_CHECK_OFF = "de.businesslogics.format.dta.DTAUtil.blzCheckOff";
    public static String KTO_CHECK_OFF = "de.businesslogics.format.dta.DTAUtil.ktoCheckOff";
    private static final Logger LOGGER = Logger.getLogger(DTAUtil.class.getName());
    private static final Charset DTAUS_CHARSET = new DTAUS();
    private static char[] DTAUS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '.', ',', '&', '-', '/', '+', '*', '$', '%', '\u00c4', '\u00d6', '\u00dc', '\u00df'};

    public static void setNumericalField(byte[] dest, int offset, int length, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Value must not be negative");
        }
        byte[] v = Long.toString(value).getBytes();
        if (v.length > length) {
            throw new IllegalArgumentException("value to large. Allowed " + length + " have " + v.length);
        }
        while (v.length < length) {
            dest[offset++] = 48;
            --length;
        }
        System.arraycopy(v, 0, dest, offset, length);
    }

    public static long getNumericalField(byte[] src, int offset, int length) {
        return Long.parseLong(new String(src, offset, length));
    }

    public static void setBankcode(byte[] dest, int offset, int bankcode) {
        if (!(Boolean.getBoolean(BLZ_CHECK_OFF) || bankcode >= 10000000 && bankcode < 90000000 || bankcode == 0)) {
            throw new IllegalArgumentException("Illegal bankcode " + bankcode);
        }
        DTAUtil.setNumericalField(dest, offset, 8, bankcode);
    }

    public static void setAccount(byte[] dest, int offset, long account) {
        if (!Boolean.getBoolean(KTO_CHECK_OFF) && account <= 0L) {
            throw new IllegalArgumentException("Illegal account " + account);
        }
        DTAUtil.setNumericalField(dest, offset, 10, account);
    }

    public static void setString(byte[] dest, int offset, int length, String value) {
        CharsetEncoder encoder = DTAUS_CHARSET.newEncoder();
        ByteBuffer bb = ByteBuffer.wrap(dest, offset, length);
        CharBuffer cb = CharBuffer.wrap(value);
        CoderResult result = encoder.encode(cb, bb, true);
        if (result.isOverflow()) {
            throw new IllegalArgumentException("String longer than " + length + " characters: " + value);
        }
        if (result.isUnmappable()) {
            throw new IllegalArgumentException("\"" + value + "\" contains unmappable characters");
        }
        while (bb.hasRemaining()) {
            bb.put((byte)32);
        }
    }

    public static String getString(byte[] src, int offset, int length) {
        CharsetDecoder decoder = DTAUS_CHARSET.newDecoder();
        ByteBuffer bb = ByteBuffer.wrap(src, offset, length);
        try {
            CharBuffer cb = decoder.decode(bb);
            int p = cb.position();
            int l = cb.limit();
            while (--l >= p && cb.get(l) == ' ') {
                cb.limit(l);
            }
            return cb.toString();
        }
        catch (CharacterCodingException cce) {
            LOGGER.log(Level.WARNING, "cannot decode the string", cce);
            return "";
        }
    }

    public static void setDDMMYY(byte[] dest, int offset, Date d) {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        DTAUtil.setString(dest, offset, 6, df.format(d));
    }

    public static void setDDMMYYYY(byte[] dest, int offset, Date d) {
        if (d == null) {
            DTAUtil.setString(dest, offset, 8, "        ");
        } else {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyyyy");
            DTAUtil.setString(dest, offset, 8, df.format(d));
        }
    }

    public static String validDTAUS(String s, int maxLength) {
        if (s == null) {
            s = "";
        }
        s = s.toUpperCase();
        for (int i = 0; i < s.length(); ++i) {
            if (Arrays.binarySearch(DTAUS, s.charAt(i)) >= 0) continue;
            s = s.replace(s.charAt(i), ' ');
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    static {
        Arrays.sort(DTAUS);
    }
}

