/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DTAUSWriter
extends FilterOutputStream {
    private static final boolean NEW_LINE = Boolean.getBoolean("de.businesslogics.format.dta.DTAUSWriter.NEW_LINE");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected DTAUSLogicalFile logicalFile = null;
    protected long sumAccount;
    protected long sumAmount;
    protected long sumBankcode;
    protected int numberOfPayments;

    public DTAUSWriter(OutputStream os) {
        super(os);
    }

    public void startLogicalFile(DTAUSLogicalFile logicalFile) throws IOException {
        if (this.logicalFile != null) {
            throw new IllegalStateException("Logical file already open");
        }
        this.logicalFile = logicalFile;
        this.logicalFile.writeBlock(logicalFile.a_block, this.out);
        if (NEW_LINE) {
            this.out.write(LINE_SEPARATOR.getBytes());
        }
        this.numberOfPayments = 0;
        this.sumAmount = this.sumBankcode = (long)0;
        this.sumAccount = this.sumBankcode;
    }

    public void write(DTAUSItem item) throws IOException {
        if (this.logicalFile == null) {
            throw new IllegalStateException("Not in a logical file");
        }
        if (NEW_LINE) {
            System.out.println("size: " + item.cblock.length);
            for (int i = 0; i < item.cblock.length; i += 128) {
                this.out.write(item.cblock, i, 128);
                this.out.write(LINE_SEPARATOR.getBytes());
            }
        } else {
            this.logicalFile.writeBlock(item.cblock, this.out);
        }
        ++this.numberOfPayments;
        this.sumAccount += item.getRecipientAccount();
        this.sumBankcode += (long)item.getRecipientBankcode();
        this.sumAmount += item.getAmount();
    }

    public DTAUSLogicalFile closeLogicalFile() throws IOException {
        this.logicalFile.setNumberOfPayments(this.numberOfPayments);
        this.logicalFile.setSumAccount(this.sumAccount);
        this.logicalFile.setSumBankcode(this.sumBankcode);
        this.logicalFile.setSumAmount(this.sumAmount);
        this.logicalFile.writeBlock(this.logicalFile.e_block, this.out);
        if (NEW_LINE) {
            this.out.write(LINE_SEPARATOR.getBytes());
        }
        DTAUSLogicalFile toReturn = this.logicalFile;
        this.logicalFile = null;
        return toReturn;
    }

    @Override
    public void close() throws IOException {
        if (this.logicalFile != null) {
            this.closeLogicalFile();
        }
        super.close();
    }

    public int getNumberOfPayments() {
        return this.numberOfPayments;
    }
}

