/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.InvalidNumberOfPaymentsException;
import de.businesslogics.format.dta.InvalidSumAccountException;
import de.businesslogics.format.dta.InvalidSumAmountException;
import de.businesslogics.format.dta.InvalidSumBankcodeException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class DTAUSLogicalFile
implements Serializable {
    protected static int LENGTH_BLOCK_A = 128;
    protected static int LENGTH_BLOCK_E = 128;
    protected static final byte[] A_HEADER = "0128A".getBytes();
    protected static final byte[] E_HEADER = "0128E     ".getBytes();
    byte[] a_block;
    byte[] e_block;
    private static final long serialVersionUID = 1L;

    DTAUSLogicalFile() {
    }

    DTAUSLogicalFile(byte[] a_block) {
        this.a_block = new byte[128];
        System.arraycopy(a_block, 0, this.a_block, 0, 128);
        this.e_block = new byte[128];
        System.arraycopy(E_HEADER, 0, this.e_block, 0, 10);
        Arrays.fill(this.e_block, 17, 30, (byte)48);
        Arrays.fill(this.e_block, 77, 128, (byte)32);
    }

    public DTAUSLogicalFile(boolean isCredit, int blz, long accountNumber, String customerName, Date executionDate) {
        this(false, isCredit, blz, accountNumber, customerName, executionDate);
    }

    public DTAUSLogicalFile(boolean isBankFile, boolean isCredit, int blz, long accountNumber, String customerName, Date executionDate) {
        this(isBankFile, isCredit, blz, accountNumber, customerName, executionDate, null);
    }

    public DTAUSLogicalFile(boolean isBankFile, boolean isCredit, int blz, long accountNumber, String customerName, Date executionDate, Date creationDate) {
        this.a_block = new byte[128];
        System.arraycopy(A_HEADER, 0, this.a_block, 0, 5);
        this.a_block[5] = (byte)(isCredit ? 71 : 76);
        if (isBankFile) {
            this.a_block[6] = 66;
            Arrays.fill(this.a_block, 7, 15, (byte)48);
            DTAUtil.setBankcode(this.a_block, 15, blz);
        } else {
            this.a_block[6] = 75;
            DTAUtil.setBankcode(this.a_block, 7, blz);
            Arrays.fill(this.a_block, 15, 23, (byte)48);
        }
        DTAUtil.setString(this.a_block, 23, 27, customerName);
        if (creationDate == null) {
            DTAUtil.setDDMMYY(this.a_block, 50, new Date());
        } else {
            DTAUtil.setDDMMYY(this.a_block, 50, creationDate);
        }
        Arrays.fill(this.a_block, 56, 60, (byte)32);
        DTAUtil.setAccount(this.a_block, 60, accountNumber);
        Arrays.fill(this.a_block, 70, 80, (byte)48);
        Arrays.fill(this.a_block, 80, 95, (byte)32);
        DTAUtil.setDDMMYYYY(this.a_block, 95, executionDate);
        Arrays.fill(this.a_block, 103, 127, (byte)32);
        this.a_block[127] = 49;
        this.e_block = new byte[128];
        System.arraycopy(E_HEADER, 0, this.e_block, 0, 10);
        Arrays.fill(this.e_block, 17, 30, (byte)48);
        Arrays.fill(this.e_block, 77, 128, (byte)32);
    }

    public String getCreationDate() {
        return new String(this.a_block, 50, 6);
    }

    public Date getCreation() throws ParseException {
        SimpleDateFormat simple = new SimpleDateFormat("ddMMyy");
        return simple.parse(this.getCreationDate());
    }

    public String getFieldA8() {
        return DTAUtil.getString(this.a_block, 56, 4);
    }

    public String getFieldA5() {
        return DTAUtil.getString(this.a_block, 15, 8);
    }

    public String getFieldA4() {
        return DTAUtil.getString(this.a_block, 7, 8);
    }

    public String getFileType() {
        return DTAUtil.getString(this.a_block, 5, 2);
    }

    public void setFileType(String s) {
        DTAUtil.setString(this.a_block, 5, 2, s);
    }

    public boolean isDebit() {
        if (this.a_block[5] == 76 && this.a_block[6] == 75) {
            return true;
        }
        if (this.a_block[5] == 76 && this.a_block[6] == 66) {
            return false;
        }
        if (this.a_block[5] == 71 && this.a_block[6] == 75) {
            return false;
        }
        if (this.a_block[5] == 71 && this.a_block[6] == 66) {
            return true;
        }
        return true;
    }

    public boolean isCredit() {
        return this.a_block[5] == 71;
    }

    public boolean isBankFile() {
        return this.a_block[6] == 66;
    }

    public long getReference() {
        try {
            return DTAUtil.getNumericalField(this.a_block, 70, 10);
        }
        catch (NumberFormatException nf) {
            return 0L;
        }
    }

    public void setReference(long l) {
        DTAUtil.setNumericalField(this.a_block, 70, 10, l);
    }

    public void setFileNumber(int fileNumber) {
        DTAUtil.setNumericalField(this.a_block, 56, 4, fileNumber);
    }

    public int getFileNumber() {
        try {
            return (int)DTAUtil.getNumericalField(this.a_block, 56, 4);
        }
        catch (NumberFormatException nf) {
            return 0;
        }
    }

    public String getExecutionDate() {
        return new String(this.a_block, 95, 8);
    }

    public Date getExecution() throws ParseException {
        boolean hasNotNull = false;
        for (int i = 95; i < 103; ++i) {
            if (this.a_block[i] == 0) continue;
            hasNotNull = true;
            break;
        }
        if (!hasNotNull) {
            return null;
        }
        String s = this.getExecutionDate();
        if (s.equals("@@@@@@@@")) {
            return null;
        }
        if (s.equals("        ")) {
            return null;
        }
        if (s.equals("00000000")) {
            return null;
        }
        if (s.equals("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000")) {
            return null;
        }
        SimpleDateFormat simple = new SimpleDateFormat("ddMMyyyy");
        return simple.parse(s);
    }

    public void setExecution(Date executionDate) {
        Date cd;
        try {
            cd = this.getCreation();
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        if (executionDate.compareTo(cd) < 0) {
            throw new IllegalArgumentException("Execution date before creation date");
        }
        Calendar c = Calendar.getInstance();
        c.add(5, 16);
        if (c.getTime().compareTo(executionDate) <= 0) {
            throw new IllegalArgumentException("Execution too far in the future");
        }
        DTAUtil.setDDMMYYYY(this.a_block, 95, executionDate);
    }

    public int getNumberOfPayments() throws InvalidNumberOfPaymentsException {
        try {
            return (int)DTAUtil.getNumericalField(this.e_block, 10, 7);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidNumberOfPaymentsException(new String(this.e_block, 10, 7));
        }
    }

    void setNumberOfPayments(int i) {
        DTAUtil.setNumericalField(this.e_block, 10, 7, i);
    }

    public long getOrigAccount() {
        return DTAUtil.getNumericalField(this.a_block, 60, 10);
    }

    public void setOrigAccount(long account) {
        DTAUtil.setAccount(this.a_block, 60, account);
    }

    public void setA4(long l) {
        DTAUtil.setNumericalField(this.a_block, 7, 8, l);
    }

    public int getOrigBankcode() {
        if (this.isBankFile()) {
            return (int)DTAUtil.getNumericalField(this.a_block, 15, 8);
        }
        return (int)DTAUtil.getNumericalField(this.a_block, 7, 8);
    }

    public int getOrigBankcodeFromDTIFile() {
        return (int)DTAUtil.getNumericalField(this.a_block, 15, 8);
    }

    public void setOrigBankcode(int bankcode) {
        if (this.isBankFile()) {
            DTAUtil.setBankcode(this.a_block, 15, bankcode);
        } else {
            DTAUtil.setBankcode(this.a_block, 7, bankcode);
        }
    }

    public String getOriginator() {
        return DTAUtil.getString(this.a_block, 23, 27);
    }

    public long getSumAccount() throws InvalidSumAccountException {
        try {
            return DTAUtil.getNumericalField(this.e_block, 30, 17);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidSumAccountException(new String(this.e_block, 30, 17));
        }
    }

    void setSumAccount(long l) {
        DTAUtil.setNumericalField(this.e_block, 30, 17, l);
    }

    public long getSumAmount() throws InvalidSumAmountException {
        try {
            return DTAUtil.getNumericalField(this.e_block, 64, 13);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidSumAmountException(new String(this.e_block, 64, 13));
        }
    }

    void setSumAmount(long l) {
        DTAUtil.setNumericalField(this.e_block, 64, 13, l);
    }

    public long getSumBankcode() throws InvalidSumBankcodeException {
        try {
            return DTAUtil.getNumericalField(this.e_block, 47, 17);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidSumBankcodeException(new String(this.e_block, 47, 17));
        }
    }

    void setSumBankcode(long l) {
        DTAUtil.setNumericalField(this.e_block, 47, 17, l);
    }

    void setEBlock(byte[] e_block) {
        this.e_block = new byte[128];
        System.arraycopy(e_block, 0, this.e_block, 0, 128);
    }

    public void copyA3(byte[] dest, int offset) {
        System.arraycopy(this.a_block, 5, dest, offset, 2);
    }

    public void copyA4(byte[] dest, int offset) {
        System.arraycopy(this.a_block, 7, dest, offset, 8);
    }

    public void copyA6(byte[] dest, int offset) {
        System.arraycopy(this.a_block, 23, dest, offset, 27);
    }

    public void copyA9(byte[] dest, int offset) {
        System.arraycopy(this.a_block, 60, dest, offset, 10);
    }

    public void copyA10(byte[] dest, int offset) {
        System.arraycopy(this.a_block, 70, dest, offset, 10);
    }

    public void copyA11b(byte[] dest, int offset) {
        System.arraycopy(this.a_block, 95, dest, offset, 8);
    }

    public byte[] getABlock() {
        return this.a_block;
    }

    public byte[] getEBlock() {
        return this.e_block;
    }

    public void copyE4(byte[] dest, int offset) {
        System.arraycopy(this.e_block, 10, dest, offset, 7);
    }

    public void copyE6(byte[] dest, int offset) {
        System.arraycopy(this.e_block, 30, dest, offset, 17);
    }

    public void copyE7(byte[] dest, int offset) {
        System.arraycopy(this.e_block, 47, dest, offset, 17);
    }

    public void copyE8(byte[] dest, int offset) {
        System.arraycopy(this.e_block, 64, dest, offset, 13);
    }

    protected void writeBlock(byte[] block, OutputStream out) throws IOException {
        out.write(block);
    }
}

