/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.FieldC7;
import java.io.Serializable;
import java.util.Arrays;

public class DTAUSItem
implements Serializable {
    private static String RECIPIENT_CHECK_OFF = "de.businesslogics.format.dta.DTAUSItem.recipientCheckOff";
    private static String CUSTOMER_CHECK_OFF = "de.businesslogics.format.dta.DTAUSItem.customerCheckOff";
    public static boolean FILL_EMPTY_EXTENSIONS_WITH_BLANKS = false;
    protected static int LENGTH_CONSTANT_PART_BLOCK_C = 187;
    protected static int LENGTH_EXTENSION_PART_BLOCK_C = 29;
    private static final long serialVersionUID = 1L;
    static final int[] EXTENSION_POSITION = new int[]{187, 216, 256, 285, 314, 343, 384, 413, 442, 471, 512, 541, 570, 599, 640, 768};
    static final int[] BLOCK_SIZE = new int[]{256, 256, 256, 384, 384, 384, 384, 512, 512, 512, 512, 640, 640, 640, 640, 768};
    byte[] cblock;

    protected DTAUSItem() {
    }

    DTAUSItem(byte[] cblock, int len) {
        this.cblock = new byte[len];
        System.arraycopy(cblock, 0, this.cblock, 0, len);
    }

    public DTAUSItem(DTAUSLogicalFile file, String[] customer, int recipientBankcode, long recipientAccount, String[] recipientName, FieldC7 textKey, long amount, String[] purpose) {
        if (amount <= 0L) {
            throw new IllegalArgumentException("Illegal amount: " + amount);
        }
        if (!file.isBankFile() && textKey.isCredit() != file.isCredit()) {
            throw new IllegalArgumentException("Text key does not fit into logical file");
        }
        this.fillCommonValues(customer, recipientBankcode, recipientAccount, recipientName, textKey, amount, purpose);
        if (recipientName == null) {
            System.arraycopy(file.a_block, 23, this.cblock, 128, 27);
            Arrays.fill(this.cblock, 93, 120, (byte)32);
        } else {
            DTAUtil.setString(this.cblock, 93, 27, recipientName[0]);
        }
        if (customer == null) {
            System.arraycopy(file.a_block, 23, this.cblock, 128, 27);
        } else {
            DTAUtil.setString(this.cblock, 128, 27, customer[0]);
        }
        System.arraycopy(file.a_block, 7, this.cblock, 61, 8);
        System.arraycopy(file.a_block, 60, this.cblock, 69, 10);
    }

    protected void fillCommonValues(String[] customer, int recipientBankcode, long recipientAccount, String[] recipientName, FieldC7 textKey, long amount, String[] purpose) {
        int p;
        int fillChar;
        int i;
        boolean empty;
        int extensions = purpose.length - 1;
        if (recipientName != null) {
            extensions += recipientName.length - 1;
        }
        if (customer != null) {
            extensions += customer.length - 1;
        }
        this.cblock = new byte[this.getBlockSize(extensions)];
        DTAUtil.setNumericalField(this.cblock, 0, 4, 187 + extensions * 29);
        this.cblock[4] = 67;
        Arrays.fill(this.cblock, 5, 13, (byte)48);
        DTAUtil.setBankcode(this.cblock, 13, recipientBankcode);
        DTAUtil.setAccount(this.cblock, 21, recipientAccount);
        Arrays.fill(this.cblock, 31, 44, (byte)48);
        System.arraycopy(textKey.internalValue, 0, this.cblock, 44, 5);
        this.cblock[49] = 32;
        Arrays.fill(this.cblock, 50, 61, (byte)48);
        DTAUtil.setNumericalField(this.cblock, 79, 11, amount);
        Arrays.fill(this.cblock, 90, 93, (byte)32);
        if (!Boolean.getBoolean(RECIPIENT_CHECK_OFF)) {
            empty = true;
            for (i = 93; empty && i < 120; empty &= this.cblock[i] == 32, ++i) {
            }
            if (empty) {
                throw new IllegalArgumentException("Recipient name must not be empty");
            }
        }
        Arrays.fill(this.cblock, 120, 128, (byte)32);
        if (!Boolean.getBoolean(CUSTOMER_CHECK_OFF)) {
            empty = true;
            for (i = 128; empty && i < 155; empty &= this.cblock[i] == 32, ++i) {
            }
            if (empty) {
                throw new IllegalArgumentException("Customer name must not be empty");
            }
        }
        DTAUtil.setString(this.cblock, 155, 27, purpose[0]);
        this.cblock[182] = 49;
        Arrays.fill(this.cblock, 183, 185, (byte)32);
        DTAUtil.setNumericalField(this.cblock, 185, 2, extensions);
        extensions = 0;
        if (recipientName != null) {
            extensions = this.setExtensions(extensions, 1, recipientName, 2);
        }
        extensions = this.setExtensions(extensions, 2, purpose, 14);
        if (customer != null) {
            extensions = this.setExtensions(extensions, 3, customer, 2);
        }
        int n = fillChar = FILL_EMPTY_EXTENSIONS_WITH_BLANKS ? 32 : 48;
        while ((p = EXTENSION_POSITION[extensions++]) < this.cblock.length) {
            Arrays.fill(this.cblock, p, p += 2, (byte)fillChar);
            Arrays.fill(this.cblock, p, p += 27, (byte)32);
            Arrays.fill(this.cblock, p, EXTENSION_POSITION[extensions], (byte)32);
        }
    }

    protected int getBlockSize(int countExtensions) {
        return BLOCK_SIZE[countExtensions];
    }

    public long getAmount() {
        return Long.parseLong(new String(this.cblock, 79, 11));
    }

    public long getRecipientAccount() {
        return Long.parseLong(new String(this.cblock, 21, 10));
    }

    public int getRecipientBankcode() {
        return Integer.parseInt(new String(this.cblock, 13, 8));
    }

    public int getCounterPartyBankCode(boolean isPaymentFile) {
        if (isPaymentFile) {
            return Integer.parseInt(new String(this.cblock, 13, 8));
        }
        return Integer.parseInt(new String(this.cblock, 61, 8));
    }

    public long getCounterPartyAccountNumber(boolean isPaymentFile) {
        if (isPaymentFile) {
            return Long.parseLong(new String(this.cblock, 21, 10));
        }
        return Long.parseLong(new String(this.cblock, 69, 10));
    }

    public String[] getRecipient() {
        int e = this.countExtensions();
        int p = 1;
        int i = e;
        while (--i >= 0) {
            if (this.cblock[EXTENSION_POSITION[i] + 1] != 49) continue;
            ++p;
        }
        String[] toReturn = new String[p];
        p = 1;
        toReturn[0] = DTAUtil.getString(this.cblock, 93, 27).trim();
        for (int i2 = 0; i2 < e; ++i2) {
            if (this.cblock[EXTENSION_POSITION[i2] + 1] != 49) continue;
            toReturn[p++] = DTAUtil.getString(this.cblock, EXTENSION_POSITION[i2] + 2, 27);
        }
        return toReturn;
    }

    public long getOriginatorAccount() {
        return Long.parseLong(new String(this.cblock, 69, 10));
    }

    public long getOriginatorAccount(DTAUSLogicalFile file) {
        long l = this.getOriginatorAccount();
        if (l == 0L) {
            return file.getOrigAccount();
        }
        return l;
    }

    public void setOriginatorAccount(long origAccountNumber) {
        DTAUtil.setAccount(this.cblock, 69, origAccountNumber);
    }

    public int getOriginatorBankcode() {
        return Integer.parseInt(new String(this.cblock, 61, 8));
    }

    public int getOriginatorBankcode(DTAUSLogicalFile file) {
        int i = this.getOriginatorBankcode();
        if (i == 0) {
            return file.getOrigBankcode();
        }
        return i;
    }

    public void setOriginatorBankcode(int origBankCode) {
        DTAUtil.setBankcode(this.cblock, 61, origBankCode);
    }

    public int getFirstParticipatingBank() {
        return Integer.parseInt(new String(this.cblock, 5, 8));
    }

    public void setFirstParticipatingBank(int bankCode) {
        DTAUtil.setBankcode(this.cblock, 5, bankCode);
    }

    public String[] getCustomer() {
        int e = this.countExtensions();
        int p = 1;
        int i = e;
        while (--i >= 0) {
            if (this.cblock[EXTENSION_POSITION[i] + 1] != 51) continue;
            ++p;
        }
        String[] toReturn = new String[p];
        p = 1;
        toReturn[0] = DTAUtil.getString(this.cblock, 128, 27).trim();
        for (int i2 = 0; i2 < e; ++i2) {
            if (this.cblock[EXTENSION_POSITION[i2] + 1] != 51) continue;
            toReturn[p++] = DTAUtil.getString(this.cblock, EXTENSION_POSITION[i2] + 2, 27);
        }
        return toReturn;
    }

    public int getConversionType() {
        return Integer.parseInt(new String(this.cblock, 31, 1));
    }

    public void setConversionType(int val) {
        DTAUtil.setNumericalField(this.cblock, 31, 1, val);
    }

    public long getInternalCustomerId() {
        return Long.parseLong(new String(this.cblock, 32, 11));
    }

    public void setInternalCustomerId(long val) {
        DTAUtil.setNumericalField(this.cblock, 32, 11, val);
    }

    public long getC6a() {
        return DTAUtil.getNumericalField(this.cblock, 31, 12);
    }

    public long getC6() {
        return DTAUtil.getNumericalField(this.cblock, 31, 13);
    }

    public void setC6(long val) {
        DTAUtil.setNumericalField(this.cblock, 31, 13, val);
    }

    public String getTextKey() {
        return DTAUtil.getString(this.cblock, 44, 5);
    }

    public short countExtensions() {
        return (short)DTAUtil.getNumericalField(this.cblock, 185, 2);
    }

    public String[] getPurpose() {
        int e = this.countExtensions();
        int p = 1;
        int i = e;
        while (--i >= 0) {
            if (this.cblock[EXTENSION_POSITION[i] + 1] != 50) continue;
            ++p;
        }
        String[] purpose = new String[p];
        p = 1;
        purpose[0] = DTAUtil.getString(this.cblock, 155, 27);
        for (int i2 = 0; i2 < e; ++i2) {
            if (this.cblock[EXTENSION_POSITION[i2] + 1] != 50) continue;
            purpose[p++] = DTAUtil.getString(this.cblock, EXTENSION_POSITION[i2] + 2, 27);
        }
        return purpose;
    }

    protected int setExtensions(int count, int tag, String[] values, int maxOccurence) {
        if (values.length > maxOccurence) {
            throw new IllegalArgumentException("Too many extensions of type " + tag + " allowed are " + maxOccurence + " found " + values.length);
        }
        for (int i = 1; i < values.length; ++i) {
            int p = EXTENSION_POSITION[count++];
            DTAUtil.setNumericalField(this.cblock, p, 2, tag);
            DTAUtil.setString(this.cblock, p += 2, 27, values[i]);
            Arrays.fill(this.cblock, p += 27, EXTENSION_POSITION[count], (byte)32);
        }
        return count;
    }

    public void setC14B(String in) {
        DTAUtil.setString(this.cblock, 120, 8, in);
    }

    public byte[] getCBlock() {
        return this.cblock;
    }
}

