/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.InvalidAccountNumberException;
import de.businesslogics.format.dta.InvalidAmountException;
import de.businesslogics.format.dta.InvalidBankcodeException;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.InvalidHeaderException;
import de.businesslogics.format.dta.InvalidNumberOfPaymentsException;
import de.businesslogics.format.dta.InvalidSumAccountException;
import de.businesslogics.format.dta.InvalidSumAmountException;
import de.businesslogics.format.dta.InvalidSumBankcodeException;
import de.businesslogics.format.dta.MandatoryDebitMissmatchException;
import de.businesslogics.format.dta.RecordMissingException;

public class DTAUSExtractor
extends DTAExtractor {
    private static final char BLOCK_A = 'A';
    private static final char BLOCK_C = 'C';
    private static final char BLOCK_E = 'E';
    private static final String ALL_HEADER = new String(new char[]{'A', 'C', 'E'});
    private DTAUSLogicalFile logicalFile;
    private boolean processingDone = false;
    private int numberOfPayments = 0;
    private long sumAccount = 0L;
    private long sumAmount = 0L;
    private long sumBankcode = 0L;
    private Boolean mandatoryIsDebit = null;

    public DTAUSExtractor() {
        super(new MyNullFormatListener());
    }

    public DTAUSExtractor(DTAUSListener listener) {
        super(listener);
    }

    public Boolean getMandatoryIsDebit() {
        return this.mandatoryIsDebit;
    }

    public void setMandatoryIsDebit(Boolean mandatoryIsDebit) {
        this.mandatoryIsDebit = mandatoryIsDebit;
    }

    @Override
    protected void doBlock() throws InvalidFileException {
        switch (this.block[4]) {
            case 65: {
                this.doBlockA();
                break;
            }
            case 67: {
                this.doBlockC();
                break;
            }
            case 69: {
                this.doBlockE();
            }
        }
    }

    @Override
    protected int doNewBlock() throws InvalidFileException {
        if (this.block[4] == 65) {
            if (this.logicalFile == null) {
                return 128;
            }
            throw new InvalidHeaderException((char)this.block[4], "CE");
        }
        if (this.logicalFile == null) {
            throw new InvalidHeaderException((char)this.block[4], "A");
        }
        switch (this.block[4]) {
            case 67: {
                String header = new String(this.block, 0, 4);
                try {
                    int length = Integer.valueOf(header);
                    return DTAUSExtractor.getCBlockLength(length);
                }
                catch (NumberFormatException numberFormat) {
                    throw new InvalidHeaderException(header);
                }
            }
            case 69: {
                if (this.numberOfPayments == 0) {
                    throw new InvalidHeaderException((char)this.block[4], "C");
                }
                return 128;
            }
        }
        throw new InvalidHeaderException((char)this.block[4], ALL_HEADER);
    }

    public static int getCBlockLength(int length) {
        switch (length) {
            case 187: 
            case 216: 
            case 245: {
                return 256;
            }
            case 274: 
            case 303: 
            case 332: 
            case 361: {
                return 384;
            }
            case 390: 
            case 419: 
            case 448: 
            case 477: {
                return 512;
            }
            case 506: 
            case 535: 
            case 564: 
            case 593: {
                return 640;
            }
            case 622: {
                return 768;
            }
        }
        if (length % 128 == 0) {
            return length;
        }
        return (length / 128 + 1) * 128;
    }

    private void doBlockA() throws InvalidFileException {
        this.processingDone = true;
        this.logicalFile = new DTAUSLogicalFile(this.block);
        if (this.mandatoryIsDebit != null && this.logicalFile.isDebit() != this.mandatoryIsDebit.booleanValue()) {
            throw new MandatoryDebitMissmatchException(this.mandatoryIsDebit);
        }
        ((DTAUSListener)this.formatListener).startLogicalFile(this.logicalFile);
    }

    private void doBlockC() throws InvalidFileException {
        DTAUSItem item = new DTAUSItem(this.block, this.endPos);
        ++this.numberOfPayments;
        try {
            this.sumAmount += item.getAmount();
        }
        catch (NumberFormatException numberFormat) {
            this.handleWarning(new InvalidAmountException(numberFormat.getMessage()));
        }
        try {
            this.sumAccount += item.getRecipientAccount();
        }
        catch (NumberFormatException numberFormat) {
            this.handleWarning(new InvalidAccountNumberException(numberFormat.getMessage()));
        }
        try {
            this.sumBankcode += (long)item.getRecipientBankcode();
        }
        catch (NumberFormatException numberFormat) {
            this.handleWarning(new InvalidBankcodeException(numberFormat.getMessage()));
        }
        ((DTAUSListener)this.formatListener).handleItem(item);
    }

    private void doBlockE() throws InvalidFileException {
        this.logicalFile.setEBlock(this.block);
        if (this.numberOfPayments != this.logicalFile.getNumberOfPayments()) {
            this.handleWarning(new InvalidNumberOfPaymentsException(this.logicalFile.getNumberOfPayments(), this.numberOfPayments));
        }
        if (this.sumAmount != this.logicalFile.getSumAmount()) {
            this.handleWarning(new InvalidSumAmountException(this.logicalFile.getSumAmount(), this.sumAmount));
        }
        if (this.sumAccount != this.logicalFile.getSumAccount()) {
            this.handleWarning(new InvalidSumAccountException(this.logicalFile.getSumAccount(), this.sumAccount));
        }
        if (this.sumBankcode != this.logicalFile.getSumBankcode()) {
            this.handleWarning(new InvalidSumBankcodeException(this.logicalFile.getSumBankcode(), this.sumBankcode));
        }
        ((DTAUSListener)this.formatListener).endLogicalFile(this.logicalFile);
        this.numberOfPayments = 0;
        this.sumAccount = 0L;
        this.sumAmount = 0L;
        this.sumBankcode = 0L;
        this.logicalFile = null;
    }

    protected void addPayment() {
        ++this.numberOfPayments;
    }

    protected void addAmount(long amount) {
        this.sumAmount += amount;
    }

    @Override
    protected void finish() throws InvalidFileException {
        if (!this.processingDone || this.bytesRemaining) {
            throw new RecordMissingException('A');
        }
        if (this.logicalFile != null) {
            throw new RecordMissingException('E');
        }
    }

    private static class MyNullFormatListener
    extends DTAExtractor.NullFormatListener
    implements DTAUSListener {
        private MyNullFormatListener() {
        }

        @Override
        public void startLogicalFile(DTAUSLogicalFile logicalFile) {
        }

        @Override
        public void endLogicalFile(DTAUSLogicalFile logicalFile) {
        }

        @Override
        public void handleItem(DTAUSItem i) {
        }
    }

    public static interface DTAUSListener
    extends DTAExtractor.FormatListener {
        public void startLogicalFile(DTAUSLogicalFile var1);

        public void endLogicalFile(DTAUSLogicalFile var1);

        public void handleItem(DTAUSItem var1);
    }
}

