/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DTAReader {
    protected SimpleDateFormat YYMMDD = new SimpleDateFormat("yyMMdd");
    protected SimpleDateFormat YYMM = new SimpleDateFormat("yyMM");
    protected SimpleDateFormat DDMMYY = new SimpleDateFormat("ddMMyy");
    protected SimpleDateFormat DDMMYYYY = new SimpleDateFormat("ddMMyyyy");
    private InputStream in;

    public DTAReader(InputStream in) {
        this.in = in;
    }

    public BigDecimal readBigDecimal(int intPart, int fractionPart) throws IOException {
        String s1 = this.readStringInterall(intPart);
        String s2 = this.readStringInterall(fractionPart);
        return new BigDecimal(s1 + "." + s2);
    }

    public boolean readBoolean() throws IOException {
        int c = this.in.read();
        return c == 74;
    }

    public byte readByte(int size) throws IOException {
        try {
            return Byte.parseByte(this.readStringInterall(size));
        }
        catch (NumberFormatException nf) {
            return 0;
        }
    }

    public char readChar() throws IOException {
        return (char)this.in.read();
    }

    public Date readDDMMYYDate() throws IOException {
        return this.readDate(this.DDMMYY, 6, "000000");
    }

    public Date readDDMMYYYYDate() throws IOException {
        return this.readDate(this.DDMMYYYY, 8, "00000000");
    }

    public void readFully(byte[] buffer) throws IOException {
        Streams.readFully(this.in, buffer);
    }

    public int readInt(int size) throws IOException {
        try {
            return Integer.parseInt(this.readStringInterall(size));
        }
        catch (NumberFormatException nf) {
            return 0;
        }
    }

    public long readLong(int size) throws IOException {
        try {
            return Long.parseLong(this.readStringInterall(size));
        }
        catch (NumberFormatException nf) {
            return 0L;
        }
    }

    public String readString(int size) throws IOException {
        return this.readStringInterall(size).trim();
    }

    public Date readYYMMDDDate() throws IOException {
        return this.readDate(this.YYMMDD, 6, "000000");
    }

    public Date readYYMMDate() throws IOException {
        return this.readDate(this.YYMM, 4, "0000");
    }

    public void skip(int size) throws IOException {
        byte[] tmp = new byte[size];
        Streams.readFully(this.in, tmp);
    }

    private Date readDate(SimpleDateFormat df, int size, String nullDate) throws IOException {
        String s = this.readStringInterall(size);
        if (s.equals(nullDate)) {
            return null;
        }
        try {
            return df.parse(s);
        }
        catch (ParseException p) {
            return null;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    private String readStringInterall(int size) throws IOException {
        byte[] buffer = new byte[size];
        Streams.readFully(this.in, buffer);
        return new String(buffer);
    }
}

