/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.InvalidFileException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class DTAExtractor
extends OutputStream {
    private static final int BLOCK_HEADER_LENGTH = 5;
    protected int pos = 0;
    protected byte[] block = new byte[768];
    private byte[] byteBuffer = new byte[1];
    protected int endPos;
    protected boolean bytesRemaining = false;
    protected FormatListener formatListener;

    protected DTAExtractor(FormatListener l) {
        this.formatListener = l;
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        catch (InvalidFileException ife) {
            this.handleWarning(ife);
        }
    }

    protected abstract void finish() throws InvalidFileException;

    @Override
    public void write(int b) throws IOException {
        this.byteBuffer[0] = (byte)b;
        this.write(this.byteBuffer, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws InvalidFileException {
        if (this.formatListener == null) {
            return;
        }
        while (len > 0) {
            try {
                int min;
                if (this.pos < 5) {
                    min = 5 - this.pos;
                    if (min > len) {
                        System.arraycopy(b, off, this.block, this.pos, len);
                        this.pos += len;
                        this.bytesRemaining = true;
                        return;
                    }
                    System.arraycopy(b, off, this.block, this.pos, min);
                    off += min;
                    this.pos += min;
                    len -= min;
                    this.bytesRemaining = false;
                    this.endPos = this.doNewBlock();
                    continue;
                }
                min = this.endPos - this.pos;
                if (min > len) {
                    System.arraycopy(b, off, this.block, this.pos, len);
                    this.pos += len;
                    return;
                }
                System.arraycopy(b, off, this.block, this.pos, min);
                off += min;
                this.pos += min;
                len -= min;
                this.doBlock();
                this.pos = 0;
            }
            catch (InvalidFileException ife) {
                FormatListener l = this.formatListener;
                this.formatListener = null;
                l.consumeError(ife);
                return;
            }
        }
    }

    protected void copyField(int startPos, byte[] dest) {
        System.arraycopy(this.block, startPos, dest, 0, dest.length);
    }

    protected abstract void doBlock() throws InvalidFileException;

    protected abstract int doNewBlock() throws InvalidFileException;

    protected void handleWarning(InvalidFileException ife) throws InvalidFileException {
        if (this.formatListener != null) {
            this.formatListener.handleWarning(ife);
        }
    }

    public static interface FormatListener {
        public void consumeError(InvalidFileException var1) throws InvalidFileException;

        public void handleWarning(InvalidFileException var1) throws InvalidFileException;
    }

    public static class NullFormatListener
    implements FormatListener {
        @Override
        public void consumeError(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }

        @Override
        public void handleWarning(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }
    }
}

