/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankEMZSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftPaymentItem;
import de.businesslogics.format.dta.DTAUSWriter;
import de.businesslogics.format.dta.DTAUtil;
import java.io.IOException;
import java.io.OutputStream;

public class BundesbankSwiftWriter
extends DTAUSWriter {
    public BundesbankSwiftWriter(OutputStream os) {
        super(os);
    }

    public void write(BundesbankSwiftItem item) throws IOException {
        if (this.logicalFile == null) {
            throw new IllegalStateException("Not in a logical file");
        }
        if (item instanceof BundesbankSwiftPaymentItem) {
            BundesbankSwiftPaymentItem i = (BundesbankSwiftPaymentItem)item;
            byte[] firstPart = i.getFirstPart();
            byte[] swiftMessagePart = i.getMessageBytes();
            int lengthAccountingPart = 0;
            byte[] accountingPart = i.getAccountingPart();
            if (accountingPart != null) {
                lengthAccountingPart = accountingPart.length;
            }
            int blockSize = firstPart.length + swiftMessagePart.length + lengthAccountingPart;
            DTAUtil.setNumericalField(firstPart, 0, 6, blockSize);
            this.logicalFile.writeBlock(firstPart, this.out);
            this.logicalFile.writeBlock(swiftMessagePart, this.out);
            if (lengthAccountingPart > 0) {
                this.logicalFile.writeBlock(accountingPart, this.out);
            }
            ++this.numberOfPayments;
            this.sumAmount += i.getAmountAsLong();
        } else if (item instanceof BundesbankEMZSwiftItem) {
            BundesbankEMZSwiftItem i = (BundesbankEMZSwiftItem)item;
            if (this.logicalFile == null) {
                throw new IllegalStateException("Not in a logical file");
            }
            this.logicalFile.writeBlock(i.getBlock(), this.out);
            ++this.numberOfPayments;
            this.sumAmount += i.getAmountAsLong();
        }
    }
}

