/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankSwiftItem;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field23E;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftTransferMessage;
import de.businesslogics.format.swift.mt103.MT103Message;
import de.businesslogics.format.swift.mt103.MT103MessageExtractor;
import de.businesslogics.format.swift.mt202.MT202MessageExtractor;
import de.businesslogics.util.Currency;
import de.businesslogics.util.SystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BundesbankSwiftPaymentItem
extends BundesbankSwiftItem {
    private static ThreadLocal<SimpleDateFormat> ddMMyy = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("ddMMyy");
        }
    };
    protected static ThreadLocal<SimpleDateFormat> YYMMDD = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyMMdd");
        }
    };
    protected static final Currency EUR = Currency.getInstance("EUR");
    protected static final int LENGTH_FIRST_PART = 83;
    protected static final int LENGTH_ACCOUNTING_PART = 207;
    private static final String CRLF = "\r\n";
    protected SwiftTransferMessage swiftMessage;
    private byte[] accountingPart;

    protected BundesbankSwiftPaymentItem(byte[] block, int blockLength, int lengthSwiftMessage) throws IOException {
        super(block, blockLength, 83, lengthSwiftMessage);
        try {
            String messageType = this.getMessageType();
            this.swiftMessage = "202".equals(messageType) ? new MT202MessageExtractor().getMessage(block, 83, lengthSwiftMessage) : new MT103MessageExtractor().getMessage(block, 83, lengthSwiftMessage);
        }
        catch (ParseException pe) {
            throw new IOException("Could not load MT103Message. ParseException " + String.valueOf(pe));
        }
        if (blockLength > 83 + lengthSwiftMessage) {
            this.accountingPart = new byte[207];
            System.arraycopy(block, 83 + lengthSwiftMessage, this.accountingPart, 0, 207);
        }
    }

    protected BundesbankSwiftPaymentItem() {
        super(83, 0);
    }

    public abstract long getAmountAsLong();

    public BigDecimal getAmount() {
        return BigDecimal.valueOf(this.getAmountAsLong(), 2);
    }

    public Currency getCurrency() {
        return Currency.getInstance(DTAUtil.getString(this.block, 64, 3));
    }

    public String getMessageType() {
        return DTAUtil.getString(this.block, 7, 3);
    }

    public String getCreditDebitFlag() {
        return DTAUtil.getString(this.block, 63, 1);
    }

    public int getCountAccountingParts() {
        return Integer.parseInt(new String(this.block, 82, 1));
    }

    public SwiftTransferMessage getMT103Message() {
        return this.swiftMessage;
    }

    protected static int getLengthSwiftMessage(int blockLength, boolean hasAccountingPart) {
        if (hasAccountingPart) {
            return blockLength - 83 - 207;
        }
        return blockLength - 83;
    }

    public void setSendersReference(String sendersReference) {
        this.swiftMessage.setSendersReference(new Field20(sendersReference));
    }

    public String getSendersReference() {
        return this.swiftMessage.getSendersReference().getReference();
    }

    public void setValueDate(Date valueDate) {
        this.swiftMessage.getSettlementAmount().setValueDate(valueDate);
    }

    public Date getValueDate() {
        return this.swiftMessage.getSettlementAmount().getValueDateAsDate();
    }

    public String[] getLocalParty() {
        return this.swiftMessage.getLocalParty();
    }

    public String getOriginator() {
        String[] sArr = this.swiftMessage.getLocalParty();
        if (sArr != null && sArr.length > 0) {
            return BundesbankSwiftPaymentItem.checkForNull(sArr[0]);
        }
        return "";
    }

    public String getLocalPartyAccountNumber() {
        return this.swiftMessage.getLocalPartyAccountNumber();
    }

    public String getLocalPartyBankCode() {
        return this.swiftMessage.getLocalPartyBankCode();
    }

    public String getRecipient() {
        String[] sArr = this.swiftMessage.getCounterParty();
        if (sArr != null && sArr.length > 0) {
            return BundesbankSwiftPaymentItem.checkForNull(sArr[0]);
        }
        return "";
    }

    private static String checkForNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public String[] getCounterParty() {
        return this.swiftMessage.getCounterParty();
    }

    public String getCounterBEI() {
        return this.swiftMessage.getCounterPartyBEI();
    }

    public String getCounterPartyAccountNumber() {
        return this.swiftMessage.getCounterPartyAccountNumber();
    }

    public String getCounterPartyBIC() {
        return this.swiftMessage.getCounterPartyBIC();
    }

    public String getCounterPartyBankCode() {
        String s2;
        String s = this.swiftMessage.getCounterPartyBIC();
        if (s != null) {
            return s;
        }
        if (this.swiftMessage instanceof MT103Message && (s2 = ((MT103Message)this.swiftMessage).getCounterPartyBankPartyIdentifier()) != null && s2.length() >= 2) {
            return s2.substring(2);
        }
        return null;
    }

    public String[] getCounterPartyBankAddress() {
        return this.swiftMessage.getCounterPartyBankAddress();
    }

    public String getCounterPartyCorrespondentBIC() {
        return this.swiftMessage.getCounterPartyCorrespondentBIC();
    }

    public String[] getCounterPartyCorrespondentAddress() {
        return this.swiftMessage.getCounterPartyCorrespondentAddress();
    }

    public String getIntermediaryInstitutionBIC() {
        return this.swiftMessage.getIntermediaryInstitutionBIC();
    }

    public String[] getIntermediaryInstitutionAddress() {
        return this.swiftMessage.getIntermediaryInstitutionAddress();
    }

    public String[] getPurpose() {
        return this.swiftMessage.getPurpose();
    }

    public BigDecimal getOriginalAmount() {
        if (this.swiftMessage.getOriginalAmount() != null) {
            return this.swiftMessage.getOriginalAmount().getAmount();
        }
        return null;
    }

    public Currency getOriginalCurrency() {
        if (this.swiftMessage.getOriginalAmount() != null) {
            return this.swiftMessage.getOriginalAmount().getCurrency();
        }
        return null;
    }

    public BigDecimal getSettlementAmount() {
        return this.swiftMessage.getSettlementAmount().getAmount();
    }

    public Currency getSettlementCurrency() {
        return this.swiftMessage.getSettlementAmount().getCurrency();
    }

    public String getFeeType() {
        if (this.swiftMessage.getDetailsOfCharges() != null) {
            return this.swiftMessage.getDetailsOfCharges().toString();
        }
        return null;
    }

    public String getInstructionCode() {
        Field23E[] instructionCodes;
        if (this.swiftMessage instanceof MT103Message && (instructionCodes = ((MT103Message)this.swiftMessage).getInstructionCodes()) != null && instructionCodes.length > 0) {
            return instructionCodes[0].getInstructionCode().toString();
        }
        return null;
    }

    public String[] getSenderToReceiverInformation() {
        if (this.swiftMessage.getSenderToReceiverInformation() != null) {
            return this.swiftMessage.getSenderToReceiverInformation().getInformation();
        }
        return null;
    }

    public byte[] getFirstPart() {
        byte[] toReturn = new byte[this.headerLength];
        System.arraycopy(this.block, 0, toReturn, 0, this.headerLength);
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMessageBytes() throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(bos);
            w.write(CRLF);
            this.swiftMessage.writeTo(w);
            w.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            SystemUtils.close(bos);
        }
    }

    public byte[] getAccountingPart() {
        return this.accountingPart;
    }

    public BigDecimal getExchangeRate() {
        if (this.accountingPart != null) {
            String exchangeRate = DTAUtil.getString(this.accountingPart, 0, 9);
            try {
                return new BigDecimal(exchangeRate.replace(',', '.'));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.swiftMessage.getExchangeRate() != null) {
            return this.swiftMessage.getExchangeRate().getRate();
        }
        return null;
    }

    public Date getExchangeRateDate() {
        if (this.accountingPart != null) {
            try {
                return ddMMyy.get().parse(DTAUtil.getString(this.accountingPart, 9, 6));
            }
            catch (java.text.ParseException e) {
                return null;
            }
        }
        return null;
    }

    public long getGrossAmount() {
        if (this.accountingPart != null) {
            try {
                return Long.parseLong(new String(this.accountingPart, 17, 15));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }
}

