/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankDomesticSwiftItem;
import de.businesslogics.format.dta.BundesbankDtaExtractor;
import de.businesslogics.format.dta.BundesbankEKISwiftItem;
import de.businesslogics.format.dta.BundesbankEMZSwiftItem;
import de.businesslogics.format.dta.BundesbankForeignSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftListener;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.SLF;
import java.io.IOException;

public class BundesbankSwiftExtractor
extends BundesbankDtaExtractor {
    public BundesbankSwiftExtractor(DTAUSExtractor.DTAUSListener listener, SLF slf) {
        super(listener, slf);
    }

    public BundesbankSwiftExtractor(DTAUSExtractor.DTAUSListener listener, SLF slf, String expectedFileType) {
        super(listener, slf, expectedFileType);
    }

    @Override
    protected void handleBlockH() throws IOException {
        if (this.listener instanceof BundesbankSwiftListener) {
            BundesbankSwiftListener swiftListener = (BundesbankSwiftListener)this.listener;
            DTAUtil.setNumericalField(this.dta_bytes, 0, 6, this.writePos);
            this.dta_bytes[6] = 72;
            this.copyCharacterField(7, 7, 3);
            this.copyNumericalField(10, 10, 8);
            this.copyNumericalField(18, 18, 8);
            this.copyNumericalField(26, 26, 15);
            this.copyCharacterField(41, 41, 16);
            this.copyNumericalField(57, 57, 6);
            this.copyCharacterField(63, 63, 1);
            this.copyCharacterField(64, 64, 3);
            this.copyNumericalField(67, 67, 1);
            this.copyNumericalField(68, 68, 1);
            this.copyNumericalField(69, 69, 1);
            this.copyNumericalField(70, 70, 12);
            this.copyNumericalField(82, 82, 1);
            String countAccountingParts = DTAUtil.getString(this.dta_bytes, 82, 1);
            boolean hasAccountingPart = "1".equals(countAccountingParts);
            int lengthSwiftMessage = BundesbankDomesticSwiftItem.getLengthSwiftMessage(this.writePos, hasAccountingPart);
            this.copyCharacterField(83, 83, lengthSwiftMessage);
            if (hasAccountingPart) {
                int offset = 83 + lengthSwiftMessage;
                this.copyCharacterField(offset, offset, 35);
                this.copyCharacterField(offset + 35, offset + 35, 102);
                this.copyCharacterField(offset + 137, offset + 137, 70);
            }
            swiftListener.handleSwiftItem(new BundesbankDomesticSwiftItem(this.dta_bytes, this.writePos, lengthSwiftMessage));
        }
    }

    @Override
    protected void handleBlockI() throws IOException {
        if (this.listener instanceof BundesbankSwiftListener) {
            BundesbankSwiftListener swiftListener = (BundesbankSwiftListener)this.listener;
            DTAUtil.setNumericalField(this.dta_bytes, 0, 6, this.writePos);
            this.dta_bytes[6] = 73;
            this.copyCharacterField(7, 7, 3);
            this.copyCharacterField(10, 10, 2);
            this.copyNumericalField(12, 12, 8);
            this.copyNumericalField(20, 20, 10);
            this.copyCharacterField(30, 30, 12);
            this.copyCharacterField(42, 42, 13);
            this.copyCharacterField(55, 55, 32);
            int lengthSwiftMessage = this.writePos - 87;
            this.copyCharacterField(87, 87, lengthSwiftMessage);
            swiftListener.handleSwiftItem(new BundesbankEKISwiftItem(this.dta_bytes, this.writePos, lengthSwiftMessage));
        }
    }

    @Override
    protected void handleBlockN() throws IOException {
        if (this.listener instanceof BundesbankSwiftListener) {
            BundesbankSwiftListener swiftListener = (BundesbankSwiftListener)this.listener;
            DTAUtil.setNumericalField(this.dta_bytes, 0, 6, this.writePos);
            this.dta_bytes[6] = 78;
            this.copyCharacterField(7, 7, 3);
            this.copyNumericalField(10, 10, 8);
            this.copyNumericalField(18, 18, 8);
            this.copyNumericalField(26, 26, 15);
            this.copyCharacterField(41, 41, 16);
            this.copyNumericalField(57, 57, 6);
            this.copyCharacterField(63, 63, 1);
            this.copyCharacterField(64, 64, 3);
            this.copyNumericalField(67, 67, 1);
            this.copyNumericalField(68, 68, 5);
            this.copyCharacterField(73, 73, 9);
            this.copyNumericalField(82, 82, 1);
            String countAccountingParts = DTAUtil.getString(this.dta_bytes, 82, 1);
            boolean hasAccountingPart = "1".equals(countAccountingParts);
            int lengthSwiftMessage = BundesbankForeignSwiftItem.getLengthSwiftMessage(this.writePos, hasAccountingPart);
            this.copyCharacterField(83, 83, lengthSwiftMessage);
            if (hasAccountingPart) {
                int offset = 83 + lengthSwiftMessage;
                this.copyCharacterField(offset, offset, 35);
                this.copyCharacterField(offset + 35, offset + 35, 102);
                this.copyCharacterField(offset + 137, offset + 137, 70);
            }
            swiftListener.handleSwiftItem(new BundesbankForeignSwiftItem(this.dta_bytes, this.writePos, lengthSwiftMessage));
        }
    }

    @Override
    public void handleUnknownBlock() throws IOException {
        if (this.listener instanceof BundesbankSwiftListener) {
            BundesbankSwiftListener swiftListener = (BundesbankSwiftListener)this.listener;
            DTAUtil.setNumericalField(this.dta_bytes, 0, this.slf.getLength(), this.writePos);
            int lengthSwiftMessage = this.writePos - this.slf.getLength();
            this.copyCharacterField(this.slf.getLength(), this.slf.getLength(), lengthSwiftMessage);
            swiftListener.handleSwiftItem(new BundesbankEMZSwiftItem(this.dta_bytes, this.writePos, lengthSwiftMessage));
        }
    }
}

