/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankEMZSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftListener;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.McvExtractor;
import java.io.IOException;
import java.io.OutputStream;

public class BundesbankPackedSwiftExtractor
extends McvExtractor {
    public BundesbankPackedSwiftExtractor(OutputStream os) {
        super(os);
    }

    public BundesbankPackedSwiftExtractor(DTAUSExtractor.DTAUSListener listener, String expectedFileType) {
        super(listener, expectedFileType);
    }

    public BundesbankPackedSwiftExtractor(DTAUSExtractor.DTAUSListener listener) {
        super(listener);
    }

    public BundesbankPackedSwiftExtractor(OutputStream out, DTAUSExtractor.DTAUSListener listener) {
        super(out, listener);
    }

    @Override
    protected int getMaxBlockLength() {
        return 32768;
    }

    @Override
    public void handleUnknownBlock() throws IOException {
        if (this.listener instanceof BundesbankSwiftListener) {
            BundesbankSwiftListener swiftListener = (BundesbankSwiftListener)this.listener;
            DTAUtil.setNumericalField(this.dta_bytes, 0, 4, this.writePos);
            int lengthSwiftMessage = this.writePos - 4;
            this.copyCharacterField(4, 4, lengthSwiftMessage);
            BundesbankEMZSwiftItem item = new BundesbankEMZSwiftItem(this.dta_bytes, this.writePos, lengthSwiftMessage);
            swiftListener.handleSwiftItem(item);
            if (this.dta instanceof DTAUSExtractor) {
                DTAUSExtractor extractor = (DTAUSExtractor)this.dta;
                extractor.addPayment();
                extractor.addAmount(item.getAmountAsLong());
            }
        }
    }
}

