/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.BundesbankSwiftPaymentItem;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field23B;
import de.businesslogics.format.swift.Field23E;
import de.businesslogics.format.swift.Field32A;
import de.businesslogics.format.swift.Field33B;
import de.businesslogics.format.swift.Field36;
import de.businesslogics.format.swift.Field50K;
import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.Field54A;
import de.businesslogics.format.swift.Field54D;
import de.businesslogics.format.swift.Field56A;
import de.businesslogics.format.swift.Field56D;
import de.businesslogics.format.swift.Field57A;
import de.businesslogics.format.swift.Field57C;
import de.businesslogics.format.swift.Field57D;
import de.businesslogics.format.swift.Field59;
import de.businesslogics.format.swift.Field70;
import de.businesslogics.format.swift.Field71A;
import de.businesslogics.format.swift.Field71F;
import de.businesslogics.format.swift.Field71G;
import de.businesslogics.format.swift.InstructionCode;
import de.businesslogics.format.swift.mt103.MT103Message;
import de.businesslogics.util.Currency;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;

public class BundesbankForeignSwiftItem
extends BundesbankSwiftPaymentItem {
    private static Pattern BIC_PATTERN = RegularExpressions.BIC.getPattern();
    private static final int COUNTER_VALUE_CODE_2 = 2;
    private static final int COUNTER_VALUE_CODE_6 = 6;
    private static final int[] COUNTER_VALUE_CODES = new int[]{2, 6};

    protected BundesbankForeignSwiftItem(byte[] nBlock, int lengthNBlock, int lengthSwiftMessage) throws IOException {
        super(nBlock, lengthNBlock, lengthSwiftMessage);
    }

    public BundesbankForeignSwiftItem(int blzOriginator, MT103Message message, int counterValueType) throws IOException {
        this.swiftMessage = message;
        this.buildBlock(blzOriginator, "103", null, counterValueType);
    }

    public BundesbankForeignSwiftItem(BundesbankDtaLogicalFile logicalFile, BigDecimal amount, Currency currency, int counterValueType, String messageType, String refNumber, String sendersReference, String bankOperationCode, String[] localParty, String localPartyAccountNumber, String localPartyBIC, String[] counterParty, String counterPartyAccountNumber, String counterPartyBankCode, String[] counterPartyBankAddress, String counterPartyCorrespondentBIC, String[] counterPartyCorrespondent, String intermediaryInstitutionBIC, String[] intermediaryInstitution, String[] purpose, String detailsOfCharges, String instructionCode) throws IOException {
        InstructionCode ic;
        Field33B originalAmount;
        Field32A settlementAmount;
        Field20 field20 = new Field20(sendersReference);
        Field23B field23B = new Field23B(bankOperationCode);
        Field36 exchangeRate = null;
        if (BundesbankForeignSwiftItem.isCounterValuePayment(counterValueType)) {
            settlementAmount = new Field32A(((SimpleDateFormat)YYMMDD.get()).format(new Date()), currency, BigDecimal.ZERO);
            originalAmount = new Field33B(EUR, amount);
            exchangeRate = new Field36(BigDecimal.ZERO);
        } else {
            settlementAmount = new Field32A(((SimpleDateFormat)YYMMDD.get()).format(new Date()), currency, amount);
            originalAmount = new Field33B(currency, amount);
        }
        Field50K field50K = new Field50K(localParty);
        field50K.setAccount(localPartyAccountNumber);
        Field59 field59 = new Field59(counterParty);
        if (counterPartyAccountNumber != null && counterPartyAccountNumber.length() > 0) {
            field59.setAccount(counterPartyAccountNumber);
        }
        Field71A field71A = Field71A.OUR;
        Field71F[] fields71F = null;
        Field71G field71G = null;
        if ("BEN".equals(detailsOfCharges)) {
            field71A = Field71A.BEN;
            fields71F = new Field71F[]{new Field71F(currency, BigDecimal.ZERO)};
        } else if ("SHA".equals(detailsOfCharges)) {
            field71A = Field71A.SHA;
        }
        this.swiftMessage = new MT103Message(field20, field23B, settlementAmount, field50K, field59, field71A);
        if (instructionCode != null && (ic = InstructionCode.getInstance(instructionCode)) != null && this.swiftMessage instanceof MT103Message) {
            ((MT103Message)this.swiftMessage).setInstructionCodes(new Field23E[]{new Field23E(ic)});
        }
        this.swiftMessage.setOriginalAmount(originalAmount);
        if (exchangeRate != null) {
            this.swiftMessage.setExchangeRate(exchangeRate);
        }
        if (localPartyBIC != null && (localPartyBIC.length() == 8 || localPartyBIC.length() == 11)) {
            this.swiftMessage.setAccountServicingInstitution(new Field52A(localPartyBIC));
        }
        if (counterPartyBankCode != null && counterPartyBankCode.length() > 0) {
            if (BIC_PATTERN.matcher(counterPartyBankCode).matches()) {
                this.swiftMessage.setAccountWithInstitution(new Field57A(counterPartyBankCode));
            } else {
                this.swiftMessage.setAccountWithInstitution(new Field57C("//" + counterPartyBankCode));
            }
        } else if (counterPartyBankAddress != null && counterPartyBankAddress.length > 0) {
            this.swiftMessage.setAccountWithInstitution(new Field57D(counterPartyBankAddress));
        }
        if (counterPartyCorrespondentBIC != null && (counterPartyCorrespondentBIC.length() == 8 || counterPartyCorrespondentBIC.length() == 11)) {
            this.swiftMessage.setReceiversCorrespondent(new Field54A(counterPartyCorrespondentBIC));
        } else if (counterPartyCorrespondent != null && counterPartyCorrespondent.length > 0) {
            this.swiftMessage.setReceiversCorrespondent(new Field54D(counterPartyCorrespondent));
        }
        if (intermediaryInstitutionBIC != null && (intermediaryInstitutionBIC.length() == 8 || intermediaryInstitutionBIC.length() == 11)) {
            this.swiftMessage.setIntermediary(new Field56A(intermediaryInstitutionBIC));
        } else if (intermediaryInstitution != null && intermediaryInstitution.length > 0) {
            this.swiftMessage.setIntermediary(new Field56D(intermediaryInstitution));
        }
        if (purpose != null && purpose.length > 0) {
            this.swiftMessage.setRemittanceInformation(new Field70(purpose));
        }
        if (fields71F != null) {
            this.swiftMessage.setSendersCharges(fields71F);
        } else if (field71G != null) {
            this.swiftMessage.setReceiversCharges(field71G);
        }
        this.buildBlock(logicalFile.getOrigBankcode(), messageType, refNumber, counterValueType);
    }

    private void buildBlock(int blzORiginator, String messageType, String refNumber, int counterValueType) throws IOException {
        int blockSize = 83 + this.getMessageBytes().length;
        DTAUtil.setNumericalField(this.block, 0, 6, blockSize);
        this.block[6] = 78;
        DTAUtil.setString(this.block, 7, 3, messageType);
        DTAUtil.setBankcode(this.block, 10, blzORiginator);
        DTAUtil.setBankcode(this.block, 18, 50400000);
        BigDecimal amount = BundesbankForeignSwiftItem.isCounterValuePayment(counterValueType) ? this.swiftMessage.getOriginalAmount().getAmount() : this.swiftMessage.getSettlementAmount().getAmount();
        DTAUtil.setNumericalField(this.block, 26, 15, amount.movePointRight(2).longValue());
        if (refNumber != null) {
            DTAUtil.setString(this.block, 41, 16, refNumber);
        } else {
            Arrays.fill(this.block, 41, 57, (byte)32);
        }
        Arrays.fill(this.block, 57, 63, (byte)48);
        this.block[63] = 67;
        DTAUtil.setString(this.block, 64, 3, this.swiftMessage.getSettlementAmount().getCurrency().getCurrencyCode());
        DTAUtil.setNumericalField(this.block, 67, 1, counterValueType);
        Arrays.fill(this.block, 68, 73, (byte)48);
        Arrays.fill(this.block, 73, 82, (byte)32);
        this.block[82] = 48;
    }

    @Override
    public long getAmountAsLong() {
        return Long.parseLong(new String(this.block, 26, 15));
    }

    public String getFieldN6() {
        return new String(this.block, 41, 16);
    }

    @Override
    public Currency getCurrency() {
        if (BundesbankForeignSwiftItem.isCounterValuePayment(this.getCounterPaymentCode())) {
            return EUR;
        }
        return super.getCurrency();
    }

    public Currency getCounterValueCurrency() {
        if (BundesbankForeignSwiftItem.isCounterValuePayment(this.getCounterPaymentCode())) {
            return super.getCurrency();
        }
        return null;
    }

    private static boolean isCounterValuePayment(int code) {
        for (int counterValueCode : COUNTER_VALUE_CODES) {
            if (counterValueCode != code) continue;
            return true;
        }
        return false;
    }

    public int getCounterPaymentCode() {
        return Integer.parseInt(new String(this.block, 67, 1));
    }
}

