/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankSwiftItem;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field23B;
import de.businesslogics.format.swift.Field32A;
import de.businesslogics.format.swift.Field33B;
import de.businesslogics.format.swift.Field36;
import de.businesslogics.format.swift.Field50K;
import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.Field57A;
import de.businesslogics.format.swift.Field59;
import de.businesslogics.format.swift.Field70;
import de.businesslogics.format.swift.Field71A;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.mt103.MT103Listener;
import de.businesslogics.format.swift.mt103.MT103Message;
import de.businesslogics.format.swift.mt103.MT103Parser;
import de.businesslogics.util.Currency;
import de.businesslogics.util.DateUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BundesbankEMZSwiftItem
extends BundesbankSwiftItem {
    private static final Currency EUR = Currency.getInstance("EUR");
    private static ThreadLocal<SimpleDateFormat> YYMMDD = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyMMdd");
        }
    };
    private MT103Message message;

    protected BundesbankEMZSwiftItem(byte[] block, int blockLength, int lengthSwiftMessage) throws IOException {
        super(block, blockLength, 4, lengthSwiftMessage);
        this.initMessage();
    }

    public BundesbankEMZSwiftItem(MT103Message msg) throws IOException {
        super(null, 0, 4, 0);
        this.message = msg;
        this.buildBlock();
    }

    public void buildBlock() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter(bout);
        this.message.writeTo(w, true);
        w.close();
        int size = bout.size();
        this.block = new byte[size + 4];
        this.headerLength = 4;
        this.swiftLength = size;
        System.arraycopy(bout.toByteArray(), 0, this.block, 4, size);
        DTAUtil.setNumericalField(this.block, 0, 4, size + 4);
    }

    public BundesbankEMZSwiftItem(BigDecimal amount, Currency currency, String sendersReference, String[] localParty, String localPartyAccountNumber, String localPartyBIC, String[] counterParty, String counterPartyAccountNumber, String counterPartyBIC, String[] purpose) throws IOException {
        super(null, 0, 4, 0);
        Field32A settlementAmount;
        Field36 exchangeRate = null;
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        Date processingDate = DateUtils.getTargetDay(c).getTime();
        if (EUR.getCurrencyCode().equals(currency.getCurrencyCode())) {
            settlementAmount = new Field32A(YYMMDD.get().format(processingDate), currency, amount);
        } else {
            exchangeRate = new Field36(BigDecimal.ZERO);
            settlementAmount = new Field32A(YYMMDD.get().format(processingDate), EUR, BigDecimal.ZERO);
        }
        Field50K field50K = new Field50K(localParty);
        field50K.setAccount(localPartyAccountNumber);
        Field59 field59 = new Field59(counterParty);
        if (counterPartyAccountNumber != null && counterPartyAccountNumber.length() > 0) {
            field59.setAccount(counterPartyAccountNumber);
        }
        this.message = new MT103Message(new Field20(sendersReference), new Field23B("CRED"), settlementAmount, field50K, field59, Field71A.SHA);
        this.message.setOriginalAmount(new Field33B(currency, amount));
        if (exchangeRate != null) {
            this.message.setExchangeRate(exchangeRate);
        }
        if (localPartyBIC != null && (localPartyBIC.length() == 8 || localPartyBIC.length() == 11)) {
            this.message.setAccountServicingInstitution(new Field52A(localPartyBIC));
        }
        this.message.setAccountWithInstitution(new Field57A(counterPartyBIC));
        if (purpose != null && purpose.length > 0) {
            this.message.setRemittanceInformation(new Field70(purpose));
        }
        this.buildBlock();
    }

    private void initMessage() throws IOException {
        if (this.message != null) {
            return;
        }
        try {
            MT103Parser p = new MT103Parser(new MT103Listener(){

                @Override
                public void handle(MT103Message message) {
                    BundesbankEMZSwiftItem.this.message = message;
                }
            });
            p.handleBytes(this.getBlock(), this.getHeaderBlockLength(), this.getSwiftBlockLength());
            p.close();
        }
        catch (ParseException p) {
            this.message = null;
            throw new IOException("Could not load MT103Message. ParseException " + String.valueOf(p));
        }
    }

    public MT103Message getMessage() {
        try {
            this.initMessage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.message;
    }

    public long getAmountAsLong() {
        if (this.message != null) {
            return this.message.getSettlementAmount().getAmount().movePointRight(2).longValue();
        }
        return -1L;
    }

    public BigDecimal getAmount() {
        if (this.message != null) {
            return this.message.getSettlementAmount().getAmount();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getOriginalAmount() {
        if (this.message.getOriginalAmount() != null) {
            return this.message.getOriginalAmount().getAmount();
        }
        return null;
    }

    public Currency getOriginalCurrency() {
        if (this.message.getOriginalAmount() != null) {
            return this.message.getOriginalAmount().getCurrency();
        }
        return null;
    }

    public String[] getLocalParty() {
        return this.message.getLocalParty();
    }

    public String getOriginator() {
        String[] sArr = this.message.getLocalParty();
        if (sArr != null && sArr.length > 0) {
            return this.checkForNull(sArr[0]);
        }
        return "";
    }

    public String getLocalPartyAccountNumber() {
        return this.message.getLocalPartyAccountNumber();
    }

    public String getLocalPartyBankCode() {
        return this.message.getLocalPartyBankCode();
    }

    public String[] getCounterParty() {
        return this.message.getCounterParty();
    }

    public String getRecipient() {
        String[] sArr = this.message.getCounterParty();
        if (sArr != null && sArr.length > 0) {
            return this.checkForNull(sArr[0]);
        }
        return "";
    }

    public String getCounterBEI() {
        return this.message.getCounterPartyBEI();
    }

    public String getCounterPartyAccountNumber() {
        return this.message.getCounterPartyAccountNumber();
    }

    public String getCounterPartyBIC() {
        return this.message.getCounterPartyBIC();
    }

    public String[] getPurpose() {
        return this.message.getPurpose();
    }

    public void setValueDate(Date valueDate) {
        this.message.getSettlementAmount().setValueDate(valueDate);
    }

    public void setSendersReference(String sendersReference) {
        this.message.setSendersReference(new Field20(sendersReference));
    }

    public String getSendersReference() {
        return this.message.getSendersReference().getReference();
    }

    public String getFeeType() {
        return this.message.getDetailsOfCharges().toString();
    }

    private String checkForNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

