/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankDtaExtractor;
import de.businesslogics.format.dta.BundesbankDtaItem;
import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAUSPayment;
import de.businesslogics.format.dta.DTAUSWriter;
import de.businesslogics.format.dta.FieldC7;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.SLF;
import de.businesslogics.io.Streams;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class BundesbankDtaToDTAUSConverter
implements DTAUSExtractor.DTAUSListener {
    private DTAUSPayment current;
    private List<DTAUSPayment> payments;

    @Override
    public void startLogicalFile(DTAUSLogicalFile logicalFile) {
        this.current = new DTAUSPayment(logicalFile);
    }

    @Override
    public void handleItem(DTAUSItem item) {
        this.current.addItem(item);
    }

    @Override
    public void endLogicalFile(DTAUSLogicalFile logicalFile) {
        this.payments.add(this.current);
    }

    @Override
    public void consumeError(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    @Override
    public void handleWarning(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertToDTAUS(boolean isBankFile, File ebcdicFile, File dtausFile) throws IOException, ParseException {
        FileInputStream ebcdicStream = null;
        FileOutputStream dtausStream = null;
        try {
            ebcdicStream = new FileInputStream(ebcdicFile);
            dtausStream = new FileOutputStream(dtausFile);
            new BundesbankDtaToDTAUSConverter().convertToDTAUS(isBankFile, ebcdicStream, dtausStream);
        }
        catch (Throwable throwable) {
            SystemUtils.close(ebcdicStream);
            SystemUtils.close(dtausStream);
            throw throwable;
        }
        SystemUtils.close(ebcdicStream);
        SystemUtils.close(dtausStream);
    }

    public void convertToDTAUS(boolean isBankFile, InputStream ebcdicStream, OutputStream dtausStream) throws IOException, ParseException {
        this.payments = new ArrayList<DTAUSPayment>();
        Streams.copy(ebcdicStream, new BundesbankDtaExtractor(this, SLF.SLF_4_UNCOMPRESSED), false);
        DTAUSWriter dtaw = new DTAUSWriter(dtausStream);
        for (DTAUSPayment payment : this.payments) {
            DTAUSLogicalFile lf = BundesbankDtaToDTAUSConverter.convertToDTAUS(((BundesbankDtaLogicalFile)payment.getLogicalFile()).isFromBundesbank(), (BundesbankDtaLogicalFile)payment.getLogicalFile());
            dtaw.startLogicalFile(lf);
            for (DTAUSItem item : payment.getItems()) {
                DTAUSItem dtausItem = BundesbankDtaToDTAUSConverter.convertToDTAUS(lf, (BundesbankDtaItem)item);
                dtaw.write(dtausItem);
            }
            dtaw.closeLogicalFile();
        }
    }

    public static DTAUSLogicalFile convertToDTAUS(boolean isBankFile, BundesbankDtaLogicalFile lf) throws ParseException {
        DTAUSLogicalFile dtausLf = new DTAUSLogicalFile(isBankFile, lf.isCredit(), lf.getOrigBankcode(), lf.getOrigAccount(), lf.getOriginator(), isBankFile ? lf.getCreation() : null, isBankFile ? lf.getCreation() : null);
        dtausLf.setReference(lf.getFileNumber());
        return dtausLf;
    }

    public static DTAUSItem convertToDTAUS(DTAUSLogicalFile dtausLf, BundesbankDtaItem item) throws ParseException {
        DTAUSItem dtausItem = new DTAUSItem(dtausLf, item.getCustomer(), item.getRecipientBankcode(), item.getRecipientAccount(), item.getRecipient(), FieldC7.getInstance(item.getTextKey()), item.getAmount(), item.getPurpose());
        if (item.getOriginatorBankcode() > 0) {
            dtausItem.setOriginatorBankcode(item.getOriginatorBankcode());
        }
        dtausItem.setC6(item.getC5());
        if (item.getOriginatorAccount() > 0L) {
            dtausItem.setOriginatorAccount(item.getOriginatorAccount());
        }
        return dtausItem;
    }

    public static int convertToBundesbankDta(String orderType, File dtausFile, File ebcdicFile, int fileNumber, int minFileNumber, int maxFileNumber, String fileType) throws IOException, ParseException {
        return BundesbankDtaToDTAUSConverter.convertToBundesbankDta(orderType, dtausFile, ebcdicFile, fileNumber, minFileNumber, maxFileNumber, fileType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int convertToBundesbankDta(String orderType, File dtausFile, File ebcdicFile, int fileNumber, int minFileNumber, int maxFileNumber, String fileType, boolean ignoreZeroAmountPayments) throws IOException, ParseException {
        int n;
        FileInputStream dtausStream = null;
        FileOutputStream ebcdicStream = null;
        try {
            dtausStream = new FileInputStream(dtausFile);
            ebcdicStream = new FileOutputStream(ebcdicFile);
            n = new BundesbankDtaToDTAUSConverter().convertToBundesbankDta(orderType, dtausStream, ebcdicStream, fileNumber, minFileNumber, maxFileNumber, fileType, ignoreZeroAmountPayments);
        }
        catch (Throwable throwable) {
            SystemUtils.close(ebcdicStream);
            SystemUtils.close(dtausStream);
            throw throwable;
        }
        SystemUtils.close(ebcdicStream);
        SystemUtils.close(dtausStream);
        return n;
    }

    public static int getCountZeroAmountPayments(File dtausFile) throws IOException, ParseException {
        int n;
        FileInputStream dtausStream = null;
        try {
            dtausStream = new FileInputStream(dtausFile);
            n = new BundesbankDtaToDTAUSConverter().getCountZeroAmountPayments(dtausStream);
        }
        catch (Throwable throwable) {
            SystemUtils.close(dtausStream);
            throw throwable;
        }
        SystemUtils.close(dtausStream);
        return n;
    }

    private int getCountZeroAmountPayments(InputStream dtausStream) throws IOException {
        this.payments = new ArrayList<DTAUSPayment>();
        Streams.copy(dtausStream, new DTAUSExtractor(this));
        int countItemsWithZeroAmount = 0;
        for (DTAUSPayment payment : this.payments) {
            for (DTAUSItem item : payment.getItems()) {
                if (item.getAmount() != 0L) continue;
                ++countItemsWithZeroAmount;
            }
        }
        return countItemsWithZeroAmount;
    }

    public int convertToBundesbankDta(String orderType, InputStream dtausStream, OutputStream ebcdicStream, int fileNumber, int minFileNumber, int maxFileNumber, String fileType, boolean ignoreZeroAmountPayments) throws IOException, ParseException {
        this.payments = new ArrayList<DTAUSPayment>();
        Streams.copy(dtausStream, new DTAUSExtractor(this));
        DTAUSWriter dtaw = new DTAUSWriter(ebcdicStream);
        for (DTAUSPayment payment : this.payments) {
            BundesbankDtaLogicalFile lf = BundesbankDtaToDTAUSConverter.convertToBundesbankDta(orderType, fileNumber++, fileType, payment.getLogicalFile());
            dtaw.startLogicalFile(lf);
            for (DTAUSItem item : payment.getItems()) {
                if (ignoreZeroAmountPayments && item.getAmount() <= 0L) continue;
                BundesbankDtaItem dtausItem = BundesbankDtaToDTAUSConverter.convertToBundesbankDta(lf, item);
                dtaw.write(dtausItem);
            }
            dtaw.closeLogicalFile();
            if (fileNumber <= maxFileNumber) continue;
            fileNumber = minFileNumber;
        }
        return fileNumber;
    }

    public static BundesbankDtaLogicalFile convertToBundesbankDta(String orderType, int fileNumber, String fileType, DTAUSLogicalFile lf) throws ParseException {
        long account;
        if (fileType == null) {
            fileType = lf.getFileType();
        }
        if ((account = lf.getOrigAccount()) == 0L) {
            account = Long.valueOf(lf.getFieldA5());
        }
        int blz = Integer.valueOf(lf.getFieldA4());
        return new BundesbankDtaLogicalFile(orderType, false, fileNumber, fileType, lf.isCredit(), blz, account, lf.getOriginator(), lf.isBankFile() ? lf.getCreation() : null);
    }

    public static BundesbankDtaItem convertToBundesbankDta(BundesbankDtaLogicalFile lf, DTAUSItem item) throws ParseException {
        BundesbankDtaItem bundesbankDtaItem = new BundesbankDtaItem(lf, item.getCustomer(), item.getRecipientBankcode(), item.getRecipientAccount(), item.getRecipient(), FieldC7.getInstance(item.getTextKey()), item.getAmount(), item.getPurpose());
        if (item.getOriginatorBankcode() > 0) {
            bundesbankDtaItem.setOriginatorBankcode(item.getOriginatorBankcode());
        }
        if (item.getOriginatorAccount() > 0L) {
            bundesbankDtaItem.setOriginatorAccount(item.getOriginatorAccount());
        }
        if (item.getFirstParticipatingBank() > 0) {
            bundesbankDtaItem.setFirstParticipatingBank(item.getFirstParticipatingBank());
        }
        bundesbankDtaItem.setInternalCustomerId(item.getInternalCustomerId());
        bundesbankDtaItem.setConversionType(item.getConversionType());
        return bundesbankDtaItem;
    }
}

