/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.EBCDICConverter;
import de.businesslogics.format.dta.InvalidNumberOfPaymentsException;
import de.businesslogics.format.dta.InvalidSumAmountException;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;

public class BundesbankDtaLogicalFile
extends DTAUSLogicalFile {
    private static final String QG1 = "QG1";
    private static final String XG1 = "XG1";
    private static final String YG1 = "YG1";
    private static final long serialVersionUID = 1L;
    private byte[] SLF_0128A = "0128A".getBytes();
    private byte[] SLF_000130A = "000130A".getBytes();
    private byte[] SLF_0128E = "0128E".getBytes();
    private byte[] SLF_000130E = "000130E".getBytes();
    private static final String A12_HBV = "ELS";
    private static final String A12_EMZ = "EDA";
    private static final String[] HBV_FILE_TYPES = new String[]{"DT", "GT", "TG", "WT", "WA", "M3", "M6", "M7", "M8", "M9", "MQ"};
    private static final String[] SWIFT_FILE_TYPES = new String[]{"DT", "WT", "GS", "TG", "GT"};
    private boolean isHBVSwiftPayment = false;
    private int offset = 0;
    private String currencyCode = "EUR";
    private BigDecimal totalAmount = BigDecimal.ZERO;

    public BundesbankDtaLogicalFile(String orderType, boolean isFromBBK, int fileNumber, String fileType, boolean isCredit, int blz, long accountNumber, String customerName, Date creationDate) {
        boolean isBankOrderType = orderType != null && orderType.startsWith("Q");
        boolean isMessageType = orderType != null && (orderType.startsWith("QM") || orderType.startsWith("YM"));
        boolean isSwiftPayment = this.isSwiftPaymentFileType(fileType, orderType);
        this.isHBVSwiftPayment = isSwiftPayment && this.isHBVFileType(fileType);
        int n = this.offset = this.isHBVSwiftPayment ? 2 : 0;
        if (this.offset == 2) {
            this.a_block = new byte[130];
            this.e_block = new byte[130];
            System.arraycopy(this.SLF_000130A, 0, this.a_block, 0, 7);
            System.arraycopy(this.SLF_000130E, 0, this.e_block, 0, 7);
        } else {
            this.a_block = new byte[128];
            this.e_block = new byte[128];
            System.arraycopy(this.SLF_0128A, 0, this.a_block, 0, 5);
            System.arraycopy(this.SLF_0128E, 0, this.e_block, 0, 5);
        }
        DTAUtil.setString(this.a_block, 5 + this.offset, 2, fileType);
        if (isFromBBK) {
            if (isBankOrderType) {
                DTAUtil.setBankcode(this.a_block, 7 + this.offset, (int)accountNumber);
            } else {
                Arrays.fill(this.a_block, 7 + this.offset, 15 + this.offset, (byte)48);
            }
            DTAUtil.setBankcode(this.a_block, 15 + this.offset, blz);
        } else {
            DTAUtil.setBankcode(this.a_block, 7 + this.offset, blz);
            if (isBankOrderType) {
                if (accountNumber > 99999999L) {
                    throw new IllegalArgumentException("Illegal account number for field A4: " + accountNumber);
                }
                DTAUtil.setBankcode(this.a_block, 15 + this.offset, (int)accountNumber);
            } else {
                Arrays.fill(this.a_block, 15 + this.offset, 23 + this.offset, (byte)48);
            }
        }
        if (!isFromBBK) {
            DTAUtil.setString(this.a_block, 23 + this.offset, 27, customerName);
        } else {
            this.setFromBundesbank(isFromBBK, isMessageType);
        }
        if (creationDate == null) {
            DTAUtil.setDDMMYY(this.a_block, 50 + this.offset, new Date());
        } else {
            DTAUtil.setDDMMYY(this.a_block, 50 + this.offset, creationDate);
        }
        DTAUtil.setNumericalField(this.a_block, 56 + this.offset, 5, fileNumber);
        Arrays.fill(this.a_block, 61 + this.offset, 67 + this.offset, (byte)48);
        if (isBankOrderType) {
            Arrays.fill(this.a_block, 67 + this.offset, 77 + this.offset, (byte)48);
        } else {
            DTAUtil.setAccount(this.a_block, 67 + this.offset, accountNumber);
        }
        DTAUtil.setString(this.a_block, 77 + this.offset, 3, isSwiftPayment ? "009" : "002");
        Arrays.fill(this.a_block, 80 + this.offset, 82 + this.offset, (byte)48);
        if (this.isHBVFileType(fileType)) {
            DTAUtil.setString(this.a_block, 82 + this.offset, 3, A12_HBV);
        } else {
            DTAUtil.setString(this.a_block, 82 + this.offset, 3, A12_EMZ);
        }
        Arrays.fill(this.a_block, 85 + this.offset, 128 + this.offset, (byte)32);
        DTAUtil.setString(this.e_block, 5 + this.offset, 2, fileType);
        this.e_block[14 + this.offset] = (byte)(isCredit ? 68 : 67);
        Arrays.fill(this.e_block, 15 + this.offset, 33 + this.offset, (byte)48);
        this.e_block[33 + this.offset] = 32;
        Arrays.fill(this.e_block, 34 + this.offset, 52 + this.offset, (byte)48);
        Arrays.fill(this.e_block, 52 + this.offset, 57 + this.offset, (byte)48);
        if (this.isHBVSwiftPayment) {
            Arrays.fill(this.e_block, 57 + this.offset, 75 + this.offset, (byte)32);
        }
        this.e_block[75 + this.offset] = 32;
        Arrays.fill(this.e_block, 76 + this.offset, 94 + this.offset, (byte)32);
        Arrays.fill(this.e_block, 94 + this.offset, 112 + this.offset, (byte)32);
        Arrays.fill(this.e_block, 112 + this.offset, 128 + this.offset, (byte)32);
    }

    BundesbankDtaLogicalFile(byte[] a_block, int offset) {
        this.offset = offset;
        int blockSize = 128 + offset;
        this.a_block = new byte[blockSize];
        System.arraycopy(a_block, 0, this.a_block, 0, blockSize);
        this.e_block = new byte[blockSize];
        if (offset == 2) {
            System.arraycopy(this.SLF_000130E, 0, this.e_block, 0, 7);
        } else {
            System.arraycopy(E_HEADER, 0, this.e_block, 0, 10);
        }
        Arrays.fill(this.e_block, 17 + offset, 30 + offset, (byte)48);
        Arrays.fill(this.e_block, 77 + offset, blockSize, (byte)32);
        String fileType = this.getFileType();
        this.isHBVSwiftPayment = this.isHBVFileType(fileType) && offset == 0 ? false : this.isSwiftPaymentFileType(fileType, null) && this.isHBVFileType(fileType);
    }

    @Override
    void setEBlock(byte[] e_block) {
        this.e_block = new byte[128 + this.offset];
        System.arraycopy(e_block, 0, this.e_block, 0, 128 + this.offset);
    }

    private boolean isHBVFileType(String fileType) {
        return StringUtils.isContainedInArray(fileType, HBV_FILE_TYPES);
    }

    private boolean isSwiftPaymentFileType(String fileType, String orderType) {
        if (orderType != null && (orderType.equalsIgnoreCase(QG1) || orderType.equalsIgnoreCase(XG1) || orderType.equalsIgnoreCase(YG1)) && "GT".equals(fileType)) {
            return false;
        }
        return StringUtils.isContainedInArray(fileType, SWIFT_FILE_TYPES);
    }

    @Override
    public String getFileType() {
        return DTAUtil.getString(this.a_block, 5 + this.offset, 2);
    }

    public String getFieldA12() {
        return DTAUtil.getString(this.a_block, 82 + this.offset, 3);
    }

    public boolean isHBV() {
        return A12_HBV.equals(this.getFieldA12());
    }

    public boolean isEMZ() {
        return A12_EMZ.equals(this.getFieldA12());
    }

    @Override
    public int getOrigBankcode() {
        if (this.isFromBundesbank()) {
            return (int)DTAUtil.getNumericalField(this.a_block, 15 + this.offset, 8);
        }
        return (int)DTAUtil.getNumericalField(this.a_block, 7 + this.offset, 8);
    }

    @Override
    public void setOrigBankcode(int bankcode) {
        if (this.isFromBundesbank()) {
            DTAUtil.setBankcode(this.a_block, 15 + this.offset, bankcode);
        } else {
            DTAUtil.setBankcode(this.a_block, 7 + this.offset, bankcode);
        }
    }

    @Override
    public int getOrigBankcodeFromDTIFile() {
        return (int)DTAUtil.getNumericalField(this.a_block, 15 + this.offset, 8);
    }

    @Override
    public String getOriginator() {
        return DTAUtil.getString(this.a_block, 23 + this.offset, 27);
    }

    @Override
    public String getCreationDate() {
        return new String(this.a_block, 50 + this.offset, 6);
    }

    @Override
    public int getFileNumber() {
        return (int)DTAUtil.getNumericalField(this.a_block, 56 + this.offset, 5);
    }

    @Override
    public void setFileNumber(int fileNumber) {
        DTAUtil.setNumericalField(this.a_block, 56 + this.offset, 5, fileNumber);
    }

    @Override
    public long getOrigAccount() {
        long accNumber = DTAUtil.getNumericalField(this.a_block, 67 + this.offset, 10);
        if (accNumber > 0L) {
            return accNumber;
        }
        if (this.isFromBundesbank()) {
            return Long.parseLong(DTAUtil.getString(this.a_block, 7 + this.offset, 8));
        }
        return Long.parseLong(DTAUtil.getString(this.a_block, 15 + this.offset, 8));
    }

    public boolean isFromBundesbank() {
        String x = DTAUtil.getString(this.a_block, 23 + this.offset, 27);
        return "BBK GATEWAY - NETZ".equals(x) || "BUNDESBANK".equals(x);
    }

    public void setFromBundesbank(boolean isFromBBK, boolean isMessage) {
        if (isMessage) {
            DTAUtil.setString(this.a_block, 23 + this.offset, 27, "BBK GATEWAY - NETZ");
        } else {
            DTAUtil.setString(this.a_block, 23 + this.offset, 27, "BUNDESBANK");
        }
    }

    @Override
    @Deprecated
    public void setOrigAccount(long account) {
        DTAUtil.setAccount(this.a_block, 67 + this.offset, account);
    }

    @Override
    void setSumAccount(long l) {
    }

    @Override
    void setSumBankcode(long l) {
    }

    @Override
    public void copyE8(byte[] dest, int offset) {
    }

    @Override
    public int getNumberOfPayments() throws InvalidNumberOfPaymentsException {
        try {
            return (int)DTAUtil.getNumericalField(this.e_block, 7 + this.offset, 7);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidNumberOfPaymentsException(new String(this.e_block, 7 + this.offset, 7));
        }
    }

    @Override
    void setNumberOfPayments(int i) {
        DTAUtil.setNumericalField(this.e_block, 7 + this.offset, 7, i);
    }

    @Override
    public long getSumAmount() throws InvalidSumAmountException {
        int position = this.isHBVSwiftPayment ? 15 + this.offset : 57 + this.offset;
        try {
            return DTAUtil.getNumericalField(this.e_block, position, 18);
        }
        catch (NumberFormatException numberFormat) {
            throw new InvalidSumAmountException(new String(this.e_block, position, 18));
        }
    }

    @Override
    void setSumAmount(long amount) {
        DTAUtil.setNumericalField(this.e_block, this.isHBVSwiftPayment ? 15 + this.offset : 57 + this.offset, 18, amount);
    }

    public String getFieldE4() {
        return DTAUtil.getString(this.e_block, 14 + this.offset, 1);
    }

    @Override
    protected void writeBlock(byte[] block, OutputStream out) throws IOException {
        byte[] ebcdicBlock = EBCDICConverter.convertToEbcdic(block);
        super.writeBlock(ebcdicBlock, out);
    }

    @Override
    public boolean isDebit() {
        return !(this.a_block[5 + this.offset] != 76 && this.a_block[5 + this.offset] != 73 || this.a_block[6 + this.offset] != 75 && this.a_block[6 + this.offset] != 66);
    }

    @Override
    public boolean isCredit() {
        return !this.isDebit();
    }

    @Override
    public boolean isBankFile() {
        return this.isFromBundesbank();
    }

    public void setA10(String value) {
        DTAUtil.setString(this.a_block, 77 + this.offset, 3, value);
    }

    public String getUniqueCurrencyCode() {
        return this.currencyCode;
    }

    public void setUniqueCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
}

