/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.FieldC7;
import java.util.Arrays;

public class BundesbankDtaItem
extends DTAUSItem {
    protected static final int[] BUNDESBANK_DTA_BLOCK_SIZES = new int[]{187, 216, 245, 274, 303, 332, 361, 390, 419, 448, 477, 506, 535, 564, 593, 622};
    private static final long serialVersionUID = 1L;

    BundesbankDtaItem(byte[] cblock, int len) {
        super(cblock, len);
    }

    public BundesbankDtaItem(DTAUSLogicalFile file, String[] customer, int recipientBankcode, long recipientAccount, String[] recipientName, FieldC7 textKey, long amount, String[] purpose) {
        super(file, customer, recipientBankcode, recipientAccount, recipientName, textKey, amount, purpose);
        this.setOriginatorAccount(file.getOrigAccount());
        this.setOriginatorBankcode(file.getOrigBankcode());
        this.cblock[182] = 32;
    }

    public BundesbankDtaItem(BundesbankDtaLogicalFile file, String[] customer, int recipientBankcode, long recipientAccount, String[] recipientName, FieldC7 textKey, long amount, String[] purpose) {
        this.fillCommonValues(customer, recipientBankcode, recipientAccount, recipientName, textKey, amount, purpose);
        if (customer == null) {
            System.arraycopy(file.a_block, 23, this.cblock, 128, 27);
        } else {
            DTAUtil.setString(this.cblock, 128, 27, customer[0]);
        }
        this.setOriginatorAccount(file.getOrigAccount());
        this.setOriginatorBankcode(file.getOrigBankcode());
        this.cblock[182] = 32;
    }

    @Override
    protected int getBlockSize(int countExtensions) {
        return BUNDESBANK_DTA_BLOCK_SIZES[countExtensions];
    }

    @Override
    public String[] getPurpose() {
        int e = this.countExtensions();
        int p = 1;
        int i = e;
        while (--i >= 0) {
            if (this.cblock[BUNDESBANK_DTA_BLOCK_SIZES[i] + 1] != 50) continue;
            ++p;
        }
        String[] purpose = new String[p];
        p = 1;
        purpose[0] = DTAUtil.getString(this.cblock, 155, 27);
        for (int i2 = 0; i2 < e; ++i2) {
            if (this.cblock[BUNDESBANK_DTA_BLOCK_SIZES[i2] + 1] != 50) continue;
            purpose[p++] = DTAUtil.getString(this.cblock, BUNDESBANK_DTA_BLOCK_SIZES[i2] + 2, 27);
        }
        return purpose;
    }

    @Override
    public String[] getCustomer() {
        int e = this.countExtensions();
        int p = 1;
        int i = e;
        while (--i >= 0) {
            if (this.cblock[BUNDESBANK_DTA_BLOCK_SIZES[i] + 1] != 51) continue;
            ++p;
        }
        String[] toReturn = new String[p];
        p = 1;
        toReturn[0] = DTAUtil.getString(this.cblock, 128, 27).trim();
        for (int i2 = 0; i2 < e; ++i2) {
            if (this.cblock[BUNDESBANK_DTA_BLOCK_SIZES[i2] + 1] != 51) continue;
            toReturn[p++] = DTAUtil.getString(this.cblock, BUNDESBANK_DTA_BLOCK_SIZES[i2] + 2, 27);
        }
        return toReturn;
    }

    @Override
    public String[] getRecipient() {
        int e = this.countExtensions();
        int p = 1;
        int i = e;
        while (--i >= 0) {
            if (this.cblock[BUNDESBANK_DTA_BLOCK_SIZES[i] + 1] != 49) continue;
            ++p;
        }
        String[] toReturn = new String[p];
        p = 1;
        toReturn[0] = DTAUtil.getString(this.cblock, 93, 27).trim();
        for (int i2 = 0; i2 < e; ++i2) {
            if (this.cblock[BUNDESBANK_DTA_BLOCK_SIZES[i2] + 1] != 49) continue;
            toReturn[p++] = DTAUtil.getString(this.cblock, BUNDESBANK_DTA_BLOCK_SIZES[i2] + 2, 27);
        }
        return toReturn;
    }

    @Override
    protected int setExtensions(int count, int tag, String[] values, int maxOccurence) {
        if (values.length > maxOccurence) {
            throw new IllegalArgumentException("Too many extensions of type " + tag);
        }
        for (int i = 1; i < values.length; ++i) {
            int p = BUNDESBANK_DTA_BLOCK_SIZES[count++];
            DTAUtil.setNumericalField(this.cblock, p, 2, tag);
            DTAUtil.setString(this.cblock, p += 2, 27, values[i]);
            Arrays.fill(this.cblock, p += 27, BUNDESBANK_DTA_BLOCK_SIZES[count], (byte)32);
        }
        return count;
    }

    public long getReferenceNumber() {
        long refNumber = 0L;
        try {
            refNumber = Long.parseLong(new String(this.cblock, 32, 11));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return refNumber;
    }

    public long getC5() {
        long c5 = 0L;
        try {
            c5 = Long.parseLong(new String(this.cblock, 31, 13));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c5;
    }
}

