/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankDtaItem;
import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.dta.EBCDICExtractor;
import de.businesslogics.format.dta.InvalidBlockLengthException;
import de.businesslogics.format.dta.MandatoryDebitMissmatchException;
import de.businesslogics.format.dta.SLF;
import java.io.IOException;
import java.util.Arrays;

public class BundesbankDtaExtractor
extends EBCDICExtractor {
    private String expectedFileType = null;
    protected DTAUSLogicalFile logicalFile;
    private Boolean mandatoryIsDebit;

    public BundesbankDtaExtractor(DTAUSExtractor.DTAUSListener listener, SLF slf) {
        this(listener, slf, null);
    }

    public BundesbankDtaExtractor(DTAUSExtractor.DTAUSListener listener, SLF slf, String expectedFileType) {
        super(listener, slf);
        this.dta = null;
        this.expectedFileType = expectedFileType;
    }

    @Override
    protected void handleBlockA() throws IOException {
        String fileType;
        if (this.writePos != this.lengthBlockA) {
            this.listener.consumeError(new InvalidBlockLengthException(this.writePos));
        }
        DTAUtil.setNumericalField(this.dta_bytes, 0, this.slf.getLength(), this.lengthBlockA);
        this.dta_bytes[this.slf.getLength()] = 65;
        this.copyCharacterField(5 + this.offset, 5 + this.offset, 2);
        if (this.expectedFileType != null && !this.expectedFileType.equals(fileType = DTAUtil.getString(this.dta_bytes, 5 + this.offset, 2))) {
            throw new IOException("Invalid file type = " + fileType);
        }
        this.copyNumericalField(7 + this.offset, 7 + this.offset, 8);
        this.copyNumericalField(15 + this.offset, 15 + this.offset, 8);
        this.copyCharacterField(23 + this.offset, 23 + this.offset, 27);
        this.copyNumericalField(50 + this.offset, 50 + this.offset, 6);
        this.copyNumericalField(56 + this.offset, 56 + this.offset, 5);
        this.copyNumericalField(61 + this.offset, 61 + this.offset, 6);
        this.copyNumericalField(67 + this.offset, 67 + this.offset, 10);
        this.copyNumericalField(77 + this.offset, 77 + this.offset, 3);
        this.copyNumericalField(80 + this.offset, 80 + this.offset, 2);
        this.copyCharacterField(82 + this.offset, 82 + this.offset, 3);
        this.copyCharacterField(85 + this.offset, 85 + this.offset, 43);
        this.logicalFile = new BundesbankDtaLogicalFile(this.dta_bytes, this.offset);
        if (this.mandatoryIsDebit != null && this.logicalFile.isDebit() != this.mandatoryIsDebit.booleanValue()) {
            this.listener.consumeError(new MandatoryDebitMissmatchException(this.mandatoryIsDebit));
        }
        ((DTAUSExtractor.DTAUSListener)this.listener).startLogicalFile(this.logicalFile);
    }

    @Override
    protected void handleBlockC() throws IOException {
        if (this.writePos < DTAUSItem.LENGTH_CONSTANT_PART_BLOCK_C || (this.writePos - DTAUSItem.LENGTH_CONSTANT_PART_BLOCK_C) % DTAUSItem.LENGTH_EXTENSION_PART_BLOCK_C != 0) {
            this.listener.consumeError(new InvalidBlockLengthException(this.writePos));
        }
        int extensions = (this.writePos - DTAUSItem.LENGTH_CONSTANT_PART_BLOCK_C) / DTAUSItem.LENGTH_EXTENSION_PART_BLOCK_C;
        DTAUtil.setNumericalField(this.dta_bytes, 0, 4, BundesbankDtaItem.BUNDESBANK_DTA_BLOCK_SIZES[extensions]);
        this.dta_bytes[4] = 67;
        this.copyNumericalField(5, 5, 8);
        this.copyNumericalField(13, 13, 8);
        this.copyNumericalField(21, 21, 10);
        this.copyNumericalField(31, 31, 13);
        this.copyNumericalField(44, 44, 2);
        this.copyNumericalField(46, 46, 3);
        this.copyCharacterField(49, 49, 1);
        this.copyNumericalField(50, 50, 11);
        this.copyNumericalField(61, 61, 8);
        this.copyNumericalField(69, 69, 10);
        this.copyNumericalField(79, 79, 11);
        this.copyCharacterField(90, 90, 3);
        this.copyCharacterField(93, 93, 27);
        Arrays.fill(this.dta_bytes, 120, 128, (byte)32);
        this.copyCharacterField(128, 128, 27);
        this.copyCharacterField(155, 155, 27);
        this.copyCharacterField(182, 182, 3);
        this.copyNumericalField(185, 185, 2);
        int extension = 0;
        int dtaPos = BundesbankDtaItem.BUNDESBANK_DTA_BLOCK_SIZES[0];
        for (int pos = DTAUSItem.LENGTH_CONSTANT_PART_BLOCK_C; pos < this.writePos; pos += DTAUSItem.LENGTH_EXTENSION_PART_BLOCK_C) {
            this.copyCharacterField(pos, dtaPos, DTAUSItem.LENGTH_EXTENSION_PART_BLOCK_C);
            int i = BundesbankDtaItem.BUNDESBANK_DTA_BLOCK_SIZES[++extension];
            Arrays.fill(this.dta_bytes, dtaPos += DTAUSItem.LENGTH_EXTENSION_PART_BLOCK_C, i, (byte)32);
            dtaPos = i;
        }
        BundesbankDtaItem item = new BundesbankDtaItem(this.dta_bytes, BundesbankDtaItem.BUNDESBANK_DTA_BLOCK_SIZES[extension]);
        ((DTAUSExtractor.DTAUSListener)this.listener).handleItem(item);
    }

    @Override
    protected void handleBlockE() throws IOException {
        if (this.writePos != this.lengthBlockE) {
            this.listener.consumeError(new InvalidBlockLengthException(this.writePos));
        }
        DTAUtil.setNumericalField(this.dta_bytes, 0, this.slf.getLength(), this.lengthBlockE);
        this.dta_bytes[this.slf.getLength()] = 69;
        this.copyCharacterField(5 + this.offset, 5 + this.offset, 2);
        this.copyNumericalField(7 + this.offset, 7 + this.offset, 7);
        this.copyCharacterField(14 + this.offset, 14 + this.offset, 1);
        this.copyNumericalField(15 + this.offset, 15 + this.offset, 18);
        this.copyCharacterField(33 + this.offset, 33 + this.offset, 1);
        this.copyNumericalField(34 + this.offset, 34 + this.offset, 18);
        this.copyNumericalField(52 + this.offset, 52 + this.offset, 5);
        this.copyNumericalField(57 + this.offset, 57 + this.offset, 18);
        this.copyCharacterField(75 + this.offset, 75 + this.offset, 1);
        this.copyCharacterField(76 + this.offset, 76 + this.offset, 18);
        this.copyCharacterField(94 + this.offset, 94 + this.offset, 18);
        this.copyCharacterField(112 + this.offset, 112 + this.offset, 16);
        this.logicalFile.setEBlock(this.dta_bytes);
        ((DTAUSExtractor.DTAUSListener)this.listener).endLogicalFile(this.logicalFile);
        this.logicalFile = null;
    }

    public Boolean getMandatoryIsDebit() {
        return this.mandatoryIsDebit;
    }

    public void setMandatoryIsDebit(Boolean mandatoryIsDebit) {
        this.mandatoryIsDebit = mandatoryIsDebit;
    }
}

