/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.dta;

import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.BundesbankSwiftPaymentItem;
import de.businesslogics.format.dta.DTAUtil;
import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field23B;
import de.businesslogics.format.swift.Field32A;
import de.businesslogics.format.swift.Field33B;
import de.businesslogics.format.swift.Field50K;
import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.Field57A;
import de.businesslogics.format.swift.Field59;
import de.businesslogics.format.swift.Field70;
import de.businesslogics.format.swift.Field71A;
import de.businesslogics.format.swift.Field71F;
import de.businesslogics.format.swift.Field71G;
import de.businesslogics.format.swift.mt103.MT103Message;
import de.businesslogics.iban.IbanUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class BundesbankDomesticSwiftItem
extends BundesbankSwiftPaymentItem {
    protected BundesbankDomesticSwiftItem(byte[] nBlock, int lengthNBlock, int lengthSwiftMessage) throws IOException {
        super(nBlock, lengthNBlock, lengthSwiftMessage);
    }

    public BundesbankDomesticSwiftItem(int blzOriginator, int blzRecipient, MT103Message message) throws IOException {
        this.swiftMessage = message;
        this.buildBlock(blzOriginator, blzRecipient, "103", null);
    }

    public BundesbankDomesticSwiftItem(BundesbankDtaLogicalFile logicalFile, BigDecimal amount, String messageType, String refNumber, String sendersReference, String bankOperationCode, String[] localParty, String localPartyAccountNumber, String localPartyBIC, String[] counterParty, String counterPartyAccountNumber, String counterPartyBIC, String[] purpose, String detailsOfCharges) throws IOException {
        Field20 field20 = new Field20(sendersReference);
        Field23B field23B = new Field23B(bankOperationCode);
        Field32A settlementAmount = new Field32A(((SimpleDateFormat)YYMMDD.get()).format(new Date()), EUR, amount);
        Field33B originalAmount = new Field33B(EUR, amount);
        Field50K field50K = new Field50K(localParty);
        field50K.setAccount(localPartyAccountNumber);
        Field59 field59 = new Field59(counterParty);
        if (counterPartyAccountNumber != null && counterPartyAccountNumber.length() > 0) {
            field59.setAccount(counterPartyAccountNumber);
        }
        Field71A field71A = Field71A.OUR;
        Field71F[] fields71F = null;
        Field71G field71G = null;
        if ("BEN".equals(detailsOfCharges)) {
            field71A = Field71A.BEN;
            fields71F = new Field71F[]{new Field71F(EUR, BigDecimal.ZERO)};
        } else if ("SHA".equals(detailsOfCharges)) {
            field71A = Field71A.SHA;
        }
        this.swiftMessage = new MT103Message(field20, field23B, settlementAmount, field50K, field59, field71A);
        this.swiftMessage.setOriginalAmount(originalAmount);
        if (localPartyBIC != null && (localPartyBIC.length() == 8 || localPartyBIC.length() == 11)) {
            this.swiftMessage.setAccountServicingInstitution(new Field52A(localPartyBIC));
        }
        if (counterPartyBIC != null && counterPartyBIC.length() >= 8) {
            this.swiftMessage.setAccountWithInstitution(new Field57A(counterPartyBIC));
        }
        if (purpose != null && purpose.length > 0) {
            this.swiftMessage.setRemittanceInformation(new Field70(purpose));
        }
        if (fields71F != null) {
            this.swiftMessage.setSendersCharges(fields71F);
        } else if (field71G != null) {
            this.swiftMessage.setReceiversCharges(field71G);
        }
        int recipientBlz = 50400000;
        if (IbanUtil.isGermanIban(counterPartyAccountNumber)) {
            try {
                recipientBlz = Integer.parseInt(counterPartyAccountNumber.substring(4, 12));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.buildBlock(logicalFile.getOrigBankcode(), recipientBlz, messageType, refNumber);
    }

    private void buildBlock(int blzOriginator, int blzRecipient, String messageType, String refNumber) throws IOException {
        int blockSize = 83 + this.getMessageBytes().length;
        DTAUtil.setNumericalField(this.block, 0, 6, blockSize);
        this.block[6] = 72;
        DTAUtil.setString(this.block, 7, 3, messageType);
        DTAUtil.setBankcode(this.block, 10, blzOriginator);
        DTAUtil.setBankcode(this.block, 18, blzRecipient);
        DTAUtil.setNumericalField(this.block, 26, 15, 0L);
        if (refNumber != null) {
            DTAUtil.setString(this.block, 41, 16, refNumber);
        } else {
            Arrays.fill(this.block, 41, 57, (byte)32);
        }
        Arrays.fill(this.block, 57, 63, (byte)48);
        this.block[63] = 67;
        DTAUtil.setString(this.block, 64, 3, this.swiftMessage.getSettlementAmount().getCurrency().getCurrencyCode());
        DTAUtil.setNumericalField(this.block, 67, 1, 0L);
        DTAUtil.setNumericalField(this.block, 68, 1, 0L);
        DTAUtil.setNumericalField(this.block, 69, 1, blzRecipient > 0 ? 1L : 2L);
        DTAUtil.setNumericalField(this.block, 70, 12, this.swiftMessage.getSettlementAmount().getAmount().movePointRight(2).longValue());
        this.block[82] = 48;
    }

    @Override
    public long getAmountAsLong() {
        return Long.parseLong(new String(this.block, 70, 12));
    }

    public byte getH9d() {
        try {
            long value = DTAUtil.getNumericalField(this.block, 69, 1);
            return (byte)value;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getH4() {
        return new String(this.block, 18, 8);
    }
}

