/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.csv;

import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.NumberToTextConverter;

public class XLSUtil {
    public static Workbook createWorkbook(File f) throws IOException {
        Workbook workbook;
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            workbook = WorkbookFactory.create((InputStream)in);
        }
        catch (Throwable throwable) {
            SystemUtils.close(in);
            throw throwable;
        }
        SystemUtils.close(in);
        return workbook;
    }

    public static boolean isXLS(File in) throws FileNotFoundException {
        try {
            XLSUtil.createWorkbook(in);
            return true;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEmpty(Row row) {
        for (int cellNum = row.getFirstCellNum(); cellNum < row.getLastCellNum(); ++cellNum) {
            Cell cell = row.getCell(cellNum);
            if (cell == null || CellType.BLANK.equals((Object)cell.getCellType()) || StringUtils.isEmpty(cell.toString())) continue;
            return false;
        }
        return true;
    }

    public static String getColumnDescription(int column) {
        return CellReference.convertNumToColString((int)column);
    }

    public static String getStringFromXLS(Cell cell) {
        switch (cell.getCellType()) {
            case BLANK: {
                return "";
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case NUMERIC: {
                return NumberToTextConverter.toText((double)cell.getNumericCellValue());
            }
        }
        return null;
    }

    public static String getAmountStringFromXLS(Cell cell) {
        switch (cell.getCellType()) {
            case NUMERIC: {
                return NumberToTextConverter.toText((double)cell.getNumericCellValue());
            }
            case STRING: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    public static String getCellTypeName(Cell c) {
        switch (c.getCellType()) {
            case BLANK: {
                return "BLANK";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case ERROR: {
                return "ERROR";
            }
            case FORMULA: {
                return "FORMULA";
            }
            case NUMERIC: {
                return "NUMERIC";
            }
            case STRING: {
                return "STRING";
            }
        }
        return "Unknown: " + String.valueOf(c.getCellType());
    }

    public static int getNumberOfSheets(File in) {
        try {
            return XLSUtil.createWorkbook(in).getNumberOfSheets();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String[] getSheetNames(File in) {
        try {
            Workbook workbook = XLSUtil.createWorkbook(in);
            int countSheets = workbook.getNumberOfSheets();
            String[] sheetNames = new String[countSheets];
            for (int i = 0; i < countSheets; ++i) {
                sheetNames[i] = workbook.getSheetAt(i).getSheetName();
            }
            return sheetNames;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String[]> getLinesFromXLS(File in, int sheetIndex) throws Exception {
        Workbook workbook = XLSUtil.createWorkbook(in);
        if (sheetIndex < 0 || sheetIndex >= workbook.getNumberOfSheets()) {
            throw new IOException("No sheet with index = " + sheetIndex);
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        ArrayList<String[]> lines = new ArrayList<String[]>();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
            Row r = sheet.getRow(row);
            if (r == null) continue;
            rows.add(r);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Row r : rows) {
            int lastCell = r.getLastCellNum();
            ArrayList<String> line = new ArrayList<String>();
            for (int j = 0; j < lastCell; ++j) {
                Cell c = r.getCell(j);
                if (c != null) {
                    line.add(switch (c.getCellType()) {
                        case CellType.STRING -> c.getStringCellValue();
                        case CellType.BOOLEAN -> String.valueOf(c.getBooleanCellValue());
                        case CellType.NUMERIC -> {
                            if (DateUtil.isCellDateFormatted((Cell)c)) {
                                yield sdf.format(DateUtil.getJavaDate((double)c.getNumericCellValue()));
                            }
                            yield NumberToTextConverter.toText((double)c.getNumericCellValue());
                        }
                        default -> "";
                    });
                    continue;
                }
                line.add("");
            }
            String[] sArr = line.toArray(new String[0]);
            lines.add(sArr);
        }
        return lines;
    }
}

