/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.csv;

import de.businesslogics.format.csv.BaseParser;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.csv.FormatI;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.NumberToTextConverter;

public abstract class BaseXLSFormatParser
extends BaseParser {
    public BaseXLSFormatParser(FormatI format2) {
        super(format2);
    }

    public String checkRow(Row row) {
        if (row.getLastCellNum() < this.format.minimumColumns()) {
            return "Wrong number of columns: " + row.getLastCellNum() + ". At least " + this.format.minimumColumns() + " columns are required.";
        }
        return this.validateRow(row);
    }

    protected abstract String validateRow(Row var1);

    protected String checkString(Row row, Column column, RegularExpressions ex) {
        if (column == null) {
            return null;
        }
        int columnIndex = column.getColumnIndex();
        if (columnIndex >= 0 && row != null) {
            Cell cell = row.getCell(columnIndex);
            if (cell == null) {
                return "Column " + (columnIndex + 1) + " missing";
            }
            if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
                String value = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                return this.checkPattern(value, ex, columnIndex);
            }
            if (CellType.STRING.equals((Object)cell.getCellType())) {
                return this.checkPattern(cell.getStringCellValue(), ex, columnIndex);
            }
            return "Column " + (columnIndex + 1) + ": Wrong cell type " + XLSUtil.getCellTypeName(cell) + ". Required: STRING or NUMERIC.";
        }
        return null;
    }

    protected String getString(Row row, Column c, boolean isMandatory) throws CSVConverterException {
        return this.getString(row, row.getRowNum(), c, isMandatory, true);
    }

    protected String getString(Row row, Column c, boolean isMandatory, boolean checkPattern) throws CSVConverterException {
        return this.getString(row, row.getRowNum(), c, isMandatory, checkPattern);
    }

    @Deprecated
    protected String getString(Row row, int line, Column c, boolean isMandatory) throws CSVConverterException {
        return this.getString(row, line, c, isMandatory, true);
    }

    private String getString(Row row, int line, Column c, boolean isMandatory, boolean checkPattern) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingString("Column == NULL") : null;
        }
        String v = c.getValue();
        if (v == null && row != null && c.getColumnIndex() >= 0) {
            v = XLSUtil.getStringFromXLS(row.getCell(c.getColumnIndex(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
            line = row.getRowNum();
        }
        if (v != null) {
            v = v.trim();
        }
        if (v == null || v.length() == 0) {
            return isMandatory ? this.handleMissingString(c.getFieldKey(), line, c.getColumnIndex()) : null;
        }
        if (c.getMaxFieldLength() > 0) {
            return this.getValidString(v, c.getMaxFieldLength());
        }
        RegularExpressions pattern = c.getPattern();
        if (pattern != null) {
            if (RegularExpressions.IBAN.equals((Object)pattern)) {
                v = StringUtils.removeAllWhitespace(v);
            }
            if (!checkPattern || pattern.matches(v)) {
                return v;
            }
        }
        throw new CSVConverterException(this.getInvalidValueMessage(v, c.getFieldKey(), line, c.getColumnIndex()), line, c.getColumnIndex());
    }

    protected String checkValue(Row row, Column c, boolean isMandatory, String[] allowedValues) throws CSVConverterException {
        return this.checkValue(row, row.getRowNum(), c, isMandatory, allowedValues);
    }

    @Deprecated
    protected String checkValue(Row row, int line, Column c, boolean isMandatory, String[] allowedValues) throws CSVConverterException {
        String value = this.getString(row, line, c, isMandatory);
        if (value != null && value.length() > 0) {
            return this.checkValue(value, allowedValues, c.getFieldKey(), line, c.getColumnIndex());
        }
        return value;
    }

    protected String checkAmount(Row row, Column column) {
        if (column == null) {
            return "Mandatory amount missing";
        }
        String value = column.getValue();
        if (value != null) {
            try {
                Double.parseDouble(this.format.getAmountString(value));
                return null;
            }
            catch (NumberFormatException nf) {
                if (this.format.getAmountString(column.getValue()).trim().length() == 0) {
                    return "Missing amount value";
                }
                return "Wrong amount format: \"" + this.format.getAmountString(value) + "\"";
            }
        }
        int columnIndex = column.getColumnIndex();
        Cell c = row.getCell(columnIndex);
        if (c == null) {
            return "Mandatory amount missing in cell " + columnIndex;
        }
        if (CellType.NUMERIC.equals((Object)c.getCellType())) {
            return null;
        }
        if (CellType.STRING.equals((Object)c.getCellType())) {
            try {
                Double.parseDouble(this.format.getAmountString(c.getStringCellValue()));
                return null;
            }
            catch (NumberFormatException nf) {
                return "Column " + (columnIndex + 1) + ": Wrong amount format: \"" + this.format.getAmountString(c.getStringCellValue()) + "\"";
            }
        }
        return "Column " + (columnIndex + 1) + ": Wrong cell type for mandatory amount: " + XLSUtil.getCellTypeName(c);
    }

    protected BigDecimal getAmount(Row row, Column c) throws CSVConverterException {
        return this.getAmount(row, row.getRowNum(), c);
    }

    @Deprecated
    protected BigDecimal getAmount(Row row, int line, Column c) throws CSVConverterException {
        if (c == null) {
            throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), "Column == NULL"));
        }
        String v = c.getValue();
        if (v != null) {
            return this.getAmount(v, c.getFieldKey(), -1, -1);
        }
        int columnIndex = c.getColumnIndex();
        Cell cell = row.getCell(columnIndex);
        if (cell == null) {
            throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), c.getFieldKey()));
        }
        String s = XLSUtil.getAmountStringFromXLS(cell);
        if (s != null) {
            return this.getAmount(s, c.getFieldKey(), row.getRowNum(), columnIndex);
        }
        throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), c.getFieldKey()));
    }

    protected String getCountryCode(Row row, Column c, boolean isMandatory) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingString("Column == NULL") : null;
        }
        int line = row.getRowNum();
        String value = c.getValue();
        int columnIndex = c.getColumnIndex();
        String fieldKey = c.getFieldKey();
        if (value == null) {
            Cell cell = row.getCell(columnIndex);
            if (cell == null) {
                return isMandatory ? this.handleMissingString(fieldKey, line, columnIndex) : null;
            }
            value = XLSUtil.getStringFromXLS(row.getCell(c.getColumnIndex(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
        }
        if (value == null || value.trim().length() == 0) {
            return isMandatory ? this.handleMissingString(fieldKey, line, columnIndex) : null;
        }
        return this.getCountryCode(value.trim(), fieldKey, line, columnIndex);
    }

    protected Currency getCurrency(Row row, Column c, boolean isMandatory) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingCurrency("Column == NULL") : null;
        }
        int line = row.getRowNum();
        String value = c.getValue();
        int columnIndex = c.getColumnIndex();
        String fieldKey = c.getFieldKey();
        if (value == null) {
            Cell cell = row.getCell(columnIndex);
            if (cell == null) {
                return isMandatory ? this.handleMissingCurrency(fieldKey, line, columnIndex) : null;
            }
            value = XLSUtil.getStringFromXLS(row.getCell(c.getColumnIndex(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
        }
        if (value == null || value.trim().length() == 0) {
            return isMandatory ? this.handleMissingCurrency(fieldKey, line, columnIndex) : null;
        }
        return this.getCurrency(value.trim(), fieldKey, line, columnIndex);
    }

    protected String checkDate(Row row, Column column) {
        try {
            this.getDate(row, 0, column, false);
            return null;
        }
        catch (CSVConverterException e) {
            return "Invalid date";
        }
    }

    protected Date getDate(Row row, Column c, boolean isMandatory) throws CSVConverterException {
        return this.getDate(row, row.getRowNum(), c, isMandatory);
    }

    @Deprecated
    protected Date getDate(Row row, int line, Column c, boolean isMandatory) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingDate("Column == NULL") : null;
        }
        String v = c.getValue();
        if (v == null && row != null) {
            line = row.getRowNum();
            Cell cell = row.getCell(c.getColumnIndex());
            if (cell == null) {
                return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
            }
            switch (cell.getCellType()) {
                case NUMERIC: {
                    return cell.getDateCellValue();
                }
                case STRING: {
                    v = cell.getStringCellValue();
                    break;
                }
                default: {
                    return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
                }
            }
        }
        if (v == null || v.trim().length() == 0) {
            return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
        }
        for (String dateFormat : DATE_FORMATS) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                return sdf.parse(v);
            }
            catch (ParseException parseException) {
            }
        }
        throw new CSVConverterException(this.getInvalidDateMessage(v, c.getFieldKey(), line, c.getColumnIndex(), DATE_FORMATS), line, c.getColumnIndex());
    }

    protected boolean getBoolean(Row row, Column c, boolean defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        String v = c.getValue();
        if (v != null) {
            return Boolean.valueOf(v);
        }
        Cell cell = row.getCell(c.getColumnIndex());
        if (cell == null) {
            return defaultValue;
        }
        switch (cell.getCellType()) {
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case STRING: {
                return Boolean.valueOf(cell.getStringCellValue());
            }
        }
        return defaultValue;
    }

    @Override
    protected String getColumnDescription(int column) {
        return XLSUtil.getColumnDescription(column);
    }
}

