/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.csv;

import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.FormatI;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BaseParser {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.csv.Message");
    protected static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "dd.MM.yyyy", "dd/MM/yyyy"};
    protected FormatI format;

    public BaseParser(FormatI format2) {
        this.format = format2;
    }

    protected abstract String getValidString(String var1, int var2);

    protected String checkPattern(String value, RegularExpressions ex, int columnIndex) {
        if (RegularExpressions.IBAN.equals((Object)ex)) {
            value = StringUtils.removeAllWhitespace(value);
        }
        if (ex.matches(value)) {
            return null;
        }
        return "Column " + (columnIndex + 1) + ": Wrong cell value: '" + value + "' does not match '" + this.shorten(ex) + "'";
    }

    protected String shorten(RegularExpressions ex) {
        Object toReturn = ex.getPattern().pattern();
        if (((String)toReturn).length() > 80) {
            toReturn = ((String)toReturn).substring(0, 77) + "...";
        }
        return toReturn;
    }

    protected BigDecimal getAmount(String s, String fieldKey, int line, int column) throws CSVConverterException {
        try {
            return new BigDecimal(this.format.getAmountString(s));
        }
        catch (NumberFormatException e) {
            throw new CSVConverterException(this.getInvalidValueMessage(s, fieldKey, line, column), line, column);
        }
    }

    protected String getCountryCode(String value, String fieldKey, int line, int column) throws CSVConverterException {
        if (RegularExpressions.COUNTRY_CODE.matches(value)) {
            return value;
        }
        throw new CSVConverterException(this.getInvalidValueMessage(value, fieldKey, line, column), line, column);
    }

    protected Currency getCurrency(String value, String fieldKey, int line, int column) throws CSVConverterException {
        try {
            return Currency.getInstance(value);
        }
        catch (IllegalArgumentException e) {
            throw new CSVConverterException(this.getInvalidValueMessage(value, fieldKey, line, column), line, column);
        }
    }

    protected String checkValue(String value, String[] allowedValues, String fieldKey, int line, int column) throws CSVConverterException {
        if (StringUtils.isContainedInArray(value, allowedValues)) {
            return value;
        }
        throw new CSVConverterException(this.getInvalidValueMessage(value, fieldKey, line, column), line, column);
    }

    protected String getInvalidValueMessage(String value, String fieldKey, int line, int column) {
        if (line >= 0 && column >= 0) {
            return MessageFormat.format(bundle.getString("INVALID_VALUE_IN_FILE"), value, this.getFieldName(fieldKey), line + 1, this.getColumnDescription(column));
        }
        return MessageFormat.format(bundle.getString("INVALID_VALUE"), value, this.getFieldName(fieldKey));
    }

    protected String handleMissingString(String fieldKey) throws CSVConverterException {
        return this.handleMissingString(fieldKey, -1, -1);
    }

    protected String handleMissingString(String fieldKey, int line, int column) throws CSVConverterException {
        throw new CSVConverterException(this.getNoValueMessage(fieldKey, line, column), line, column);
    }

    protected Currency handleMissingCurrency(String fieldKey) throws CSVConverterException {
        return this.handleMissingCurrency(fieldKey, -1, -1);
    }

    protected Currency handleMissingCurrency(String fieldKey, int line, int column) throws CSVConverterException {
        throw new CSVConverterException(this.getNoValueMessage(fieldKey, line, column), line, column);
    }

    protected Date handleMissingDate(String fieldKey) throws CSVConverterException {
        return this.handleMissingDate(fieldKey, -1, -1);
    }

    protected Date handleMissingDate(String fieldKey, int line, int column) throws CSVConverterException {
        throw new CSVConverterException(this.getNoValueMessage(fieldKey, line, column), line, column);
    }

    protected String getNoValueMessage(String fieldKey, int line, int column) {
        if (line >= 0 && column >= 0) {
            return MessageFormat.format(bundle.getString("NO_VALUE_IN_FILE"), this.getFieldName(fieldKey), line + 1, column);
        }
        return MessageFormat.format(bundle.getString("NO_VALUE"), this.getFieldName(fieldKey));
    }

    protected String getInvalidDateMessage(String value, String fieldKey, int line, int column, String[] formats) {
        StringBuilder sb = new StringBuilder();
        for (String format : formats) {
            sb.append(format);
            sb.append("    ");
        }
        if (line >= 0 && column >= 0) {
            return MessageFormat.format(bundle.getString("INVALID_DATE_IN_FILE"), value, this.getFieldName(fieldKey), line + 1, this.getColumnDescription(column), sb.toString());
        }
        return MessageFormat.format(bundle.getString("INVALID_DATE"), value, this.getFieldName(fieldKey), sb.toString());
    }

    protected abstract String getColumnDescription(int var1);

    protected String getFieldName(String fieldKey) {
        String fieldName = null;
        if (!this.format.isCreditFormat()) {
            try {
                fieldName = bundle.getString(fieldKey + "_DEBIT");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (fieldName == null) {
            try {
                fieldName = bundle.getString(fieldKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (fieldName == null) {
            fieldName = fieldKey;
        }
        return fieldName;
    }

    protected String getMissingBicOrBankAddressMessage(int line) {
        return MessageFormat.format(bundle.getString("BIC_OR_BANK_ADDRESS_MISSING"), line + 1);
    }
}

