/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.csv;

import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.NumberToTextConverter;

public abstract class BaseFormat {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.csv.Message");
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "dd.MM.yyyy", "dd/MM/yyyy", "yyyy-MM-dd"};
    protected NumberFormat numberFormat = null;

    public String checkRow(Row row) {
        if (row.getLastCellNum() < this.minimumColumns()) {
            return "Wrong number of columns: " + row.getLastCellNum() + ". At least " + this.minimumColumns() + " columns are required.";
        }
        return this.validateRow(row, null);
    }

    public String checkRow(String[] row) {
        if (row == null || row.length < this.minimumColumns()) {
            return "Wrong number of columns: " + String.valueOf(row == null ? "0" : Integer.valueOf(row.length)) + ". At least " + this.minimumColumns() + " columns are required.";
        }
        return this.validateRow(null, row);
    }

    protected abstract int minimumColumns();

    protected abstract String validateRow(Row var1, String[] var2);

    protected abstract String getValidString(String var1, int var2);

    protected boolean isCreditFormat() {
        return true;
    }

    protected String checkString(Row row, String[] row2, Column column, RegularExpressions ex) {
        if (column == null) {
            return null;
        }
        int columnIndex = column.getColumnIndex();
        if (columnIndex >= 0) {
            if (row != null) {
                Cell cell = row.getCell(columnIndex);
                if (cell == null) {
                    return "Column " + (columnIndex + 1) + " missing";
                }
                if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
                    String value = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                    return this.checkPattern(value, ex, columnIndex);
                }
                if (CellType.STRING.equals((Object)cell.getCellType())) {
                    return this.checkPattern(cell.getStringCellValue(), ex, columnIndex);
                }
                return "Column " + (columnIndex + 1) + ": Wrong cell type " + XLSUtil.getCellTypeName(cell) + ". Required: STRING or NUMERIC.";
            }
            if (row2.length >= column.getColumnIndex()) {
                return this.checkPattern(row2[column.getColumnIndex()], ex, columnIndex);
            }
        }
        return null;
    }

    private String checkPattern(String value, RegularExpressions ex, int columnIndex) {
        if (value != null) {
            value = value.trim();
        }
        if (ex.matches(value)) {
            return null;
        }
        return "Column " + (columnIndex + 1) + ": Wrong cell value: '" + value + "' does not match '" + this.shorten(ex) + "'";
    }

    private String shorten(RegularExpressions ex) {
        Object toReturn = ex.getPattern().pattern();
        if (((String)toReturn).length() > 80) {
            toReturn = ((String)toReturn).substring(0, 77) + "...";
        }
        return toReturn;
    }

    protected String getString(Row row, String[] row2, int line, Column c, boolean isMandatory) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingString("Column == NULL") : null;
        }
        String v = c.getValue();
        if (v == null) {
            if (row != null) {
                if (c.getColumnIndex() >= 0) {
                    v = XLSUtil.getStringFromXLS(row.getCell(c.getColumnIndex(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
                    line = row.getRowNum();
                }
            } else {
                v = row2.length <= c.getColumnIndex() || c.getColumnIndex() < 0 ? "" : row2[c.getColumnIndex()];
            }
        }
        if (v != null) {
            v = v.trim();
        }
        if (v == null || v.length() == 0) {
            return isMandatory ? this.handleMissingString(c.getFieldKey(), line, c.getColumnIndex()) : null;
        }
        if (c.getMaxFieldLength() > 0) {
            return this.getValidString(v, c.getMaxFieldLength());
        }
        RegularExpressions pattern = c.getPattern();
        if (pattern != null) {
            if (RegularExpressions.IBAN.equals((Object)pattern)) {
                v = StringUtils.removeAllWhitespace(v);
            }
            if (pattern.matches(v)) {
                return v;
            }
        }
        throw new CSVConverterException(this.getInvalidValueMessage(v, c.getFieldKey(), line, c.getColumnIndex()), line, c.getColumnIndex());
    }

    protected String checkAmount(Row row, String[] row2, Column column) {
        if (column == null) {
            return "Mandatory amount missing";
        }
        String value = column.getValue();
        if (value != null) {
            try {
                Double.parseDouble(this.getAmountString(value));
                return null;
            }
            catch (NumberFormatException nf) {
                if (this.getAmountString(column.getValue()).trim().length() == 0) {
                    return "Missing amount value";
                }
                return "Wrong amount format: \"" + this.getAmountString(value) + "\"";
            }
        }
        int columnIndex = column.getColumnIndex();
        if (row == null) {
            try {
                if (row2.length <= columnIndex) {
                    return "Amount column not present (row " + String.valueOf(columnIndex + 1) + " missing)";
                }
                Double.parseDouble(this.getAmountString(row2[columnIndex]));
                return null;
            }
            catch (NumberFormatException nf) {
                return "Column " + columnIndex + ": Wrong amount format: \"" + this.getAmountString(row2[columnIndex]) + "\"";
            }
        }
        Cell c = row.getCell(columnIndex);
        if (c == null) {
            return "Mandatory amount missing in cell " + columnIndex;
        }
        if (CellType.NUMERIC.equals((Object)c.getCellType())) {
            return null;
        }
        if (CellType.STRING.equals((Object)c.getCellType())) {
            try {
                Double.parseDouble(this.getAmountString(c.getStringCellValue()));
                return null;
            }
            catch (NumberFormatException nf) {
                return "Column " + (columnIndex + 1) + ": Wrong amount format: \"" + this.getAmountString(c.getStringCellValue()) + "\"";
            }
        }
        return "Column " + (columnIndex + 1) + ": Wrong cell type for mandatory amount: " + XLSUtil.getCellTypeName(c);
    }

    protected BigDecimal getAmount(Row row, String[] row2, int line, Column c) throws CSVConverterException {
        if (c == null) {
            throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), "Column == NULL"));
        }
        String v = c.getValue();
        if (v != null) {
            return this.getAmount(v, c.getFieldKey(), -1, -1);
        }
        int columnIndex = c.getColumnIndex();
        if (row == null) {
            if (row2.length <= columnIndex) {
                throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), c.getFieldKey()));
            }
            return this.getAmount(row2[columnIndex], c.getFieldKey(), line, columnIndex);
        }
        Cell cell = row.getCell(columnIndex);
        if (cell == null) {
            throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), c.getFieldKey()));
        }
        String s = XLSUtil.getAmountStringFromXLS(cell);
        if (s != null) {
            return this.getAmount(s, c.getFieldKey(), row.getRowNum(), columnIndex);
        }
        throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), c.getFieldKey()));
    }

    private BigDecimal getAmount(String s, String fieldKey, int line, int column) throws CSVConverterException {
        try {
            return new BigDecimal(this.getAmountString(s));
        }
        catch (NumberFormatException e) {
            throw new CSVConverterException(this.getInvalidValueMessage(s, fieldKey, line, column), line, column);
        }
    }

    private String getAmountString(String s) {
        if (s == null) {
            return "";
        }
        if (this.numberFormat != null) {
            try {
                Number n = this.numberFormat.parse(s);
                return n.toString();
            }
            catch (ParseException pe) {
                return "";
            }
        }
        if (s.contains(",")) {
            s = s.replace(',', '.');
        }
        return s;
    }

    protected String checkDate(Row row, String[] row2, Column column) {
        try {
            this.getDate(row, row2, 0, column, false);
            return null;
        }
        catch (CSVConverterException e) {
            return "Invalid date";
        }
    }

    protected Date getDate(Row row, String[] row2, int line, Column c, boolean isMandatory) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingDate("Column == NULL") : null;
        }
        String v = c.getValue();
        if (v == null) {
            if (row != null) {
                line = row.getRowNum();
                Cell cell = row.getCell(c.getColumnIndex());
                if (cell == null) {
                    return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
                }
                switch (cell.getCellType()) {
                    case NUMERIC: {
                        return cell.getDateCellValue();
                    }
                    case STRING: {
                        v = cell.getStringCellValue();
                        break;
                    }
                    default: {
                        return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
                    }
                }
            } else {
                if (row2.length <= c.getColumnIndex()) {
                    return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
                }
                v = row2[c.getColumnIndex()];
            }
        }
        if (v == null || v.trim().length() == 0) {
            return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
        }
        for (String dateFormat : DATE_FORMATS) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                return sdf.parse(v);
            }
            catch (ParseException parseException) {
            }
        }
        throw new CSVConverterException(this.getInvalidDateMessage(v, c.getFieldKey(), line, c.getColumnIndex(), DATE_FORMATS), line, c.getColumnIndex());
    }

    protected boolean getBoolean(Row row, String[] row2, Column c, boolean defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        String v = c.getValue();
        if (v != null) {
            return Boolean.valueOf(v);
        }
        if (row == null) {
            if (row2.length <= c.getColumnIndex()) {
                return defaultValue;
            }
            return Boolean.valueOf(row2[c.getColumnIndex()]);
        }
        Cell cell = row.getCell(c.getColumnIndex());
        if (cell == null) {
            return defaultValue;
        }
        switch (cell.getCellType()) {
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case STRING: {
                return Boolean.valueOf(cell.getStringCellValue());
            }
        }
        return defaultValue;
    }

    private String getInvalidValueMessage(String value, String fieldKey, int line, int column) {
        if (line >= 0 && column >= 0) {
            return MessageFormat.format(bundle.getString("INVALID_VALUE_IN_FILE"), value, this.getFieldName(fieldKey), line + 1, XLSUtil.getColumnDescription(column));
        }
        return MessageFormat.format(bundle.getString("INVALID_VALUE"), value, this.getFieldName(fieldKey));
    }

    private String getInvalidDateMessage(String value, String fieldKey, int line, int column, String[] formats) {
        StringBuilder sb = new StringBuilder();
        for (String format : formats) {
            sb.append(format);
            sb.append("    ");
        }
        if (line >= 0 && column >= 0) {
            return MessageFormat.format(bundle.getString("INVALID_DATE_IN_FILE"), value, this.getFieldName(fieldKey), line + 1, XLSUtil.getColumnDescription(column), sb.toString());
        }
        return MessageFormat.format(bundle.getString("INVALID_DATE"), value, this.getFieldName(fieldKey), sb.toString());
    }

    private String handleMissingString(String fieldKey) throws CSVConverterException {
        return this.handleMissingString(fieldKey, -1, -1);
    }

    private String handleMissingString(String fieldKey, int line, int column) throws CSVConverterException {
        throw new CSVConverterException(this.getNoValueMessage(fieldKey, line, column), line, column);
    }

    private Date handleMissingDate(String fieldKey) throws CSVConverterException {
        return this.handleMissingDate(fieldKey, -1, -1);
    }

    private Date handleMissingDate(String fieldKey, int line, int column) throws CSVConverterException {
        throw new CSVConverterException(this.getNoValueMessage(fieldKey, line, column), line, column);
    }

    private String getNoValueMessage(String fieldKey, int line, int column) {
        if (line >= 0 && column >= 0) {
            return MessageFormat.format(bundle.getString("NO_VALUE_IN_FILE"), this.getFieldName(fieldKey), line + 1, column);
        }
        return MessageFormat.format(bundle.getString("NO_VALUE"), this.getFieldName(fieldKey));
    }

    private String getFieldName(String fieldKey) {
        String fieldName = null;
        if (!this.isCreditFormat()) {
            try {
                fieldName = bundle.getString(fieldKey + "_DEBIT");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (fieldName == null) {
            try {
                fieldName = bundle.getString(fieldKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (fieldName == null) {
            fieldName = fieldKey;
        }
        return fieldName;
    }

    protected String getMissingBicOrBankAddressMessage(int line) {
        return MessageFormat.format(bundle.getString("BIC_OR_BANK_ADDRESS_MISSING"), line + 1);
    }
}

