/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.csv;

import de.businesslogics.format.csv.BaseParser;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.csv.FormatI;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BaseCSVFormatParser
extends BaseParser {
    public BaseCSVFormatParser(FormatI format) {
        super(format);
    }

    public String checkRow(String[] row) {
        if (row == null || row.length < this.format.minimumColumns()) {
            return "Wrong number of columns: " + String.valueOf(row == null ? "0" : Integer.valueOf(row.length)) + ". At least " + this.format.minimumColumns() + " columns are required.";
        }
        return this.validateRow(row);
    }

    protected abstract String validateRow(String[] var1);

    protected String checkString(String[] row, Column column, RegularExpressions ex) {
        if (column == null) {
            return null;
        }
        int columnIndex = column.getColumnIndex();
        if (columnIndex >= 0 && row.length > columnIndex) {
            return this.checkPattern(row[columnIndex], ex, columnIndex);
        }
        return null;
    }

    protected String checkValue(String[] row, int line, Column c, boolean isMandatory, String[] allowedValues) throws CSVConverterException {
        String value = this.getString(row, line, c, isMandatory);
        if (value != null && value.length() > 0) {
            return this.checkValue(value, allowedValues, c.getFieldKey(), line, c.getColumnIndex());
        }
        return value;
    }

    protected String getString(String[] row, int line, Column c, boolean isMandatory) throws CSVConverterException {
        return this.getString(row, line, c, isMandatory, true);
    }

    protected String getString(String[] row, int line, Column c, boolean isMandatory, boolean checkPattern) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingString("Column == NULL") : null;
        }
        String v = c.getValue();
        if (v == null) {
            v = row.length <= c.getColumnIndex() || c.getColumnIndex() < 0 ? "" : row[c.getColumnIndex()];
        }
        if (v != null) {
            v = v.trim();
        }
        if (v == null || v.length() == 0) {
            return isMandatory ? this.handleMissingString(c.getFieldKey(), line, c.getColumnIndex()) : null;
        }
        if (c.getMaxFieldLength() > 0) {
            return this.getValidString(v, c.getMaxFieldLength());
        }
        RegularExpressions pattern = c.getPattern();
        if (pattern != null) {
            if (RegularExpressions.IBAN.equals((Object)pattern)) {
                v = StringUtils.removeAllWhitespace(v);
            }
            if (!checkPattern || pattern.matches(v)) {
                return v;
            }
        }
        throw new CSVConverterException(this.getInvalidValueMessage(v, c.getFieldKey(), line, c.getColumnIndex()), line, c.getColumnIndex());
    }

    protected String checkAmount(String[] row, Column column) {
        if (column == null) {
            return "Mandatory amount missing";
        }
        String value = column.getValue();
        if (value != null) {
            try {
                Double.parseDouble(this.format.getAmountString(value));
                return null;
            }
            catch (NumberFormatException nf) {
                if (this.format.getAmountString(column.getValue()).trim().length() == 0) {
                    return "Missing amount value";
                }
                return "Wrong amount format: \"" + this.format.getAmountString(value) + "\"";
            }
        }
        int columnIndex = column.getColumnIndex();
        try {
            if (row.length <= columnIndex) {
                return "Amount column not present (row " + String.valueOf(columnIndex + 1) + " missing)";
            }
            Double.parseDouble(this.format.getAmountString(row[columnIndex]));
            return null;
        }
        catch (NumberFormatException nf) {
            return "Column " + columnIndex + ": Wrong amount format: \"" + this.format.getAmountString(row[columnIndex]) + "\"";
        }
    }

    protected BigDecimal getAmount(String[] row, int line, Column c) throws CSVConverterException {
        if (c == null) {
            throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), "Column == NULL"));
        }
        String v = c.getValue();
        if (v != null) {
            return this.getAmount(v, c.getFieldKey(), -1, -1);
        }
        int columnIndex = c.getColumnIndex();
        if (row.length <= columnIndex) {
            throw new CSVConverterException(MessageFormat.format(bundle.getString("NO_VALUE"), c.getFieldKey()));
        }
        return this.getAmount(row[columnIndex], c.getFieldKey(), line, columnIndex);
    }

    protected String getCountryCode(String[] row, int line, Column column, boolean isMandatory) throws CSVConverterException {
        if (column == null) {
            return isMandatory ? this.handleMissingString("Column == NULL") : null;
        }
        String value = column.getValue();
        int columnIndex = column.getColumnIndex();
        String fieldKey = column.getFieldKey();
        if (value == null) {
            if (row.length <= columnIndex) {
                return isMandatory ? this.handleMissingString(fieldKey, line, columnIndex) : null;
            }
            value = row[columnIndex];
        }
        if (value == null || value.trim().length() == 0) {
            return isMandatory ? this.handleMissingString(fieldKey, line, columnIndex) : null;
        }
        return this.getCountryCode(value, fieldKey, line, columnIndex);
    }

    protected Currency getCurrency(String[] row, int line, Column column, boolean isMandatory) throws CSVConverterException {
        if (column == null) {
            return isMandatory ? this.handleMissingCurrency("Column == NULL") : null;
        }
        String value = column.getValue();
        int columnIndex = column.getColumnIndex();
        String fieldKey = column.getFieldKey();
        if (value == null) {
            if (row.length <= columnIndex) {
                return isMandatory ? this.handleMissingCurrency(fieldKey, line, columnIndex) : null;
            }
            value = row[columnIndex];
        }
        if (value == null || value.trim().length() == 0) {
            return isMandatory ? this.handleMissingCurrency(fieldKey, line, columnIndex) : null;
        }
        return this.getCurrency(value, fieldKey, line, columnIndex);
    }

    protected String checkDate(String[] row, Column column) {
        try {
            this.getDate(row, 0, column, false);
            return null;
        }
        catch (CSVConverterException e) {
            return "Invalid date";
        }
    }

    protected Date getDate(String[] row, int line, Column c, boolean isMandatory) throws CSVConverterException {
        if (c == null) {
            return isMandatory ? this.handleMissingDate("Column == NULL") : null;
        }
        String v = c.getValue();
        if (v == null) {
            if (row.length <= c.getColumnIndex()) {
                return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
            }
            v = row[c.getColumnIndex()];
        }
        if (v == null || v.trim().length() == 0) {
            return isMandatory ? this.handleMissingDate(c.getFieldKey(), line, c.getColumnIndex()) : null;
        }
        for (String dateFormat : DATE_FORMATS) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                return sdf.parse(v);
            }
            catch (ParseException parseException) {
            }
        }
        throw new CSVConverterException(this.getInvalidDateMessage(v, c.getFieldKey(), line, c.getColumnIndex(), DATE_FORMATS), line, c.getColumnIndex());
    }

    @Override
    protected String getColumnDescription(int column) {
        return String.valueOf(column);
    }

    protected boolean getBoolean(String[] row, Column c, boolean defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        String v = c.getValue();
        if (v != null) {
            return Boolean.valueOf(v);
        }
        if (row.length <= c.getColumnIndex()) {
            return defaultValue;
        }
        return Boolean.valueOf(row[c.getColumnIndex()]);
    }
}

