/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.csv;

import de.businesslogics.format.csv.Column;
import de.businesslogics.format.csv.FormatI;
import de.businesslogics.format.sepa.csv.FieldI;
import java.text.NumberFormat;
import java.text.ParseException;

public abstract class AbstractFormat
implements FormatI {
    protected NumberFormat numberFormat = null;

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (FieldI f : this.getFields()) {
            Column c = this.getColumn(f);
            if (c != null) {
                if (b.length() > 0) {
                    b.append(this.getSeparator());
                }
                if (c.getValue() != null) {
                    b.append("=");
                    b.append(c.getValue());
                    continue;
                }
                b.append(c.getColumnIndex());
                continue;
            }
            b.append(this.getSeparator());
        }
        return b.toString();
    }

    public abstract FieldI[] getFields();

    public abstract char getSeparator();

    @Override
    public String getAmountString(String s) {
        if (s == null) {
            return "";
        }
        if (this.numberFormat != null) {
            try {
                Number n = this.numberFormat.parse(s);
                return n.toString();
            }
            catch (ParseException pe) {
                return "";
            }
        }
        if (s.contains(",")) {
            s = s.replace(',', '.');
        }
        return s;
    }

    @Override
    public boolean isBicMandatory() {
        return false;
    }

    @Override
    public boolean isCreditFormat() {
        return true;
    }

    @Override
    public boolean isDifferingCurrencyAllowed() {
        return true;
    }

    @Override
    public boolean isSCTInstAllowed() {
        return false;
    }
}

