/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.cfonb120;

import de.businesslogics.format.cfonb120.CFONB120AmountConverter;
import de.businesslogics.format.cfonb120.CFONB120Block01;
import de.businesslogics.format.cfonb120.CFONB120Block07;
import de.businesslogics.format.cfonb120.CFONB120Booking;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CFONB120Statement {
    private static ThreadLocal<SimpleDateFormat> DDMMYY = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("ddMMyy");
        }
    };
    private static final char SPACE = ' ';
    private CFONB120Block01 header;
    private CFONB120Block07 trailer;
    private List<CFONB120Booking> bookings = new ArrayList<CFONB120Booking>();

    public CFONB120Statement(String bankCode, String branchCode, String accNumber, Currency currency, Date date, BigDecimal balance, Date previousDate, BigDecimal previousBalance) {
        StringBuffer sb = new StringBuffer();
        sb.append(bankCode);
        this.appendSpaces(sb, 4);
        sb.append(branchCode);
        sb.append(currency.getCurrencyCode());
        sb.append(currency.getDefaultFractionDigits());
        sb.append(' ');
        sb.append(accNumber);
        this.appendSpaces(sb, 2);
        String commonPart = sb.toString();
        StringBuffer headerBlock = new StringBuffer("01");
        headerBlock.append(commonPart);
        headerBlock.append(DDMMYY.get().format(previousDate));
        this.appendSpaces(headerBlock, 50);
        headerBlock.append(CFONB120AmountConverter.convertToString(previousBalance));
        this.appendSpaces(headerBlock, 16);
        this.header = new CFONB120Block01(headerBlock.toString());
        StringBuffer trailerBlock = new StringBuffer("07");
        trailerBlock.append(commonPart);
        trailerBlock.append(DDMMYY.get().format(date));
        this.appendSpaces(trailerBlock, 50);
        trailerBlock.append(CFONB120AmountConverter.convertToString(balance));
        this.appendSpaces(trailerBlock, 16);
        this.trailer = new CFONB120Block07(trailerBlock.toString());
    }

    public CFONB120Statement(CFONB120Block01 header) {
        this.header = header;
        this.bookings = new ArrayList<CFONB120Booking>();
    }

    public void setTrailer(CFONB120Block07 trailer) {
        this.trailer = trailer;
    }

    public List<CFONB120Booking> getBookings() {
        return this.bookings;
    }

    public String getAccountIdentifier() {
        return this.trailer.getAccountIdentifier();
    }

    public String getBankCode() {
        return this.trailer.getBankCode();
    }

    public String getBranchCode() {
        return this.trailer.getBranchCode();
    }

    public String getAccountNumber() {
        return this.trailer.getAccountNumber();
    }

    public Currency getCurrency() {
        return this.trailer.getCurrency();
    }

    public String getRIB() {
        return this.trailer.getRIB();
    }

    public BigDecimal getOpeningBalance() {
        return this.header.getAmount();
    }

    public Date getOpeningDate() {
        return this.header.getDate();
    }

    public BigDecimal getBalance() {
        return this.trailer.getAmount();
    }

    public Date getDate() {
        return this.trailer.getDate();
    }

    private void appendSpaces(StringBuffer sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
    }

    public void store(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        w.write(this.header.getContent());
        for (CFONB120Booking booking : this.bookings) {
            for (String content : booking.getContents()) {
                w.write(content);
            }
        }
        w.write(this.trailer.getContent());
        ((Writer)w).flush();
    }

    public void parseContent() {
        this.header.parseContent();
        if (this.bookings != null && this.bookings.size() > 0) {
            for (CFONB120Booking booking : this.bookings) {
                booking.parseContent();
            }
        }
        if (this.trailer != null) {
            this.trailer.parseContent();
        }
    }
}

