/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.cfonb120;

import de.businesslogics.format.cfonb120.CFONB120Block01;
import de.businesslogics.format.cfonb120.CFONB120Block04;
import de.businesslogics.format.cfonb120.CFONB120Block05;
import de.businesslogics.format.cfonb120.CFONB120Block07;
import de.businesslogics.format.cfonb120.CFONB120Block08;
import de.businesslogics.format.cfonb120.CFONB120Block09;
import de.businesslogics.format.cfonb120.CFONB120Listener;
import de.businesslogics.io.LFCRFilter;
import java.io.IOException;
import java.io.InputStream;

public class CFONB120Parser {
    private static final int BLOCK_LENGTH = 120;
    private CFONB120Listener listener;

    public CFONB120Parser(CFONB120Listener listener) {
        this.listener = listener;
    }

    public void parse(InputStream in) throws IOException {
        LFCRFilter filter = new LFCRFilter(in);
        byte[] buffer = new byte[120];
        while (filter.readUntilBufferIsFull(buffer) > 0) {
            this.processBlock(buffer);
        }
    }

    private void processBlock(byte[] bytes) throws IOException {
        String block = new String(bytes);
        String blockType = block.substring(0, 2);
        if ("01".equals(blockType)) {
            this.listener.handleBlock01(new CFONB120Block01(block));
        } else if ("04".equals(blockType)) {
            this.listener.handleBlock04(new CFONB120Block04(block));
        } else if ("05".equals(blockType)) {
            this.listener.handleBlock05(new CFONB120Block05(block));
        } else if ("07".equals(blockType)) {
            this.listener.handleBlock07(new CFONB120Block07(block));
        } else if ("08".equals(blockType)) {
            this.listener.handleBlock08(new CFONB120Block08(block));
        } else if ("09".equals(blockType)) {
            this.listener.handleBlock09(new CFONB120Block09(block));
        } else {
            throw new IOException("Unknown block type " + blockType + " in CFONB120 file");
        }
    }
}

