/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.cfonb120;

import de.businesslogics.format.cfonb120.CFONB120AmountConverter;
import de.businesslogics.format.cfonb120.CFONB120Block04;
import de.businesslogics.format.cfonb120.CFONB120Block05;
import de.businesslogics.format.cfonb120.CFONB120Statement;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.List;

public class CFONB120Booking {
    private static ThreadLocal<SimpleDateFormat> DDMMYY = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("ddMMyy");
        }
    };
    private static final char SPACE = ' ';
    private CFONB120Block04 block04;
    private List<CFONB120Block05> libBlocks;
    private CFONB120Block05 idoBlock;
    private CFONB120Block05 mmoBlock;
    private List<String> purposeLines;

    public CFONB120Booking(CFONB120Statement statement, Date bookingDate, Date valueDate, BigDecimal amount, String transactionCode, String rejectionCode) {
        StringBuffer sb = new StringBuffer("04");
        sb.append(statement.getBankCode());
        if (transactionCode != null && rejectionCode.length() == 4) {
            sb.append(transactionCode);
        } else {
            this.appendSpaces(sb, 4);
        }
        sb.append(statement.getBranchCode());
        sb.append(statement.getCurrency().getCurrencyCode());
        sb.append(statement.getCurrency().getDefaultFractionDigits());
        sb.append(' ');
        sb.append(statement.getAccountNumber());
        this.appendSpaces(sb, 2);
        sb.append(DDMMYY.get().format(bookingDate));
        if (rejectionCode != null && rejectionCode.length() == 2) {
            sb.append(rejectionCode);
        } else {
            this.appendSpaces(sb, 2);
        }
        sb.append(DDMMYY.get().format(valueDate));
        this.appendSpaces(sb, 42);
        sb.append(CFONB120AmountConverter.convertToString(amount));
        this.appendSpaces(sb, 16);
        this.block04 = new CFONB120Block04(sb.toString());
    }

    public CFONB120Booking(CFONB120Block04 block04) {
        this.block04 = block04;
    }

    public void addBlock(CFONB120Block05 block05) {
        String blockQualifier = block05.getBlockQualifier();
        if ("LIB".equals(blockQualifier)) {
            if (this.libBlocks == null) {
                this.libBlocks = new ArrayList<CFONB120Block05>();
            }
            this.libBlocks.add(block05);
        } else if ("IDO".equals(blockQualifier)) {
            this.idoBlock = block05;
        } else if ("MMO".equals(blockQualifier)) {
            this.mmoBlock = block05;
        } else {
            if (this.libBlocks == null) {
                this.libBlocks = new ArrayList<CFONB120Block05>();
            }
            this.libBlocks.add(block05);
        }
    }

    public Date getValueDate() {
        return this.block04.getValueDate();
    }

    public Date getBookingDate() {
        return this.block04.getDate();
    }

    public BigDecimal getAmount() {
        return this.block04.getAmount();
    }

    public int getNumberOfDecimals() {
        return this.block04.getNumberOfDecimals();
    }

    public List<String> getPurposeLines() {
        if (this.purposeLines == null) {
            this.purposeLines = new ArrayList<String>();
            this.purposeLines.add(this.block04.getPurpose());
            if (this.libBlocks != null) {
                for (CFONB120Block05 libBlock : this.libBlocks) {
                    this.purposeLines.add(libBlock.getAdditionalPurpose());
                }
            }
        }
        return this.purposeLines;
    }

    public String getTransactionCode() {
        return this.block04.getTransactionCode();
    }

    public String getInterbankTransactionCode() {
        return this.block04.getInterbankTransactionCode();
    }

    public String getRejectionCauseCode() {
        return this.block04.getRejectionCauseCode();
    }

    public String getEntryNumber() {
        return this.block04.getEntryNumber();
    }

    public String getExemption() {
        return this.block04.getExemption();
    }

    public String getUnavailabiltyRating() {
        return this.block04.getUnavailabiltyRating();
    }

    public String getOriginatorBankCode() {
        if (this.idoBlock != null) {
            return this.idoBlock.getOriginatorBankCode();
        }
        return null;
    }

    public String getOriginatorBranchCode() {
        if (this.idoBlock != null) {
            return this.idoBlock.getOriginatorBranchCode();
        }
        return null;
    }

    public String getOriginatorAccountNumber() {
        if (this.idoBlock != null) {
            return this.idoBlock.getOriginatorAccountNumber();
        }
        return null;
    }

    public String getOriginator() {
        if (this.idoBlock != null) {
            return this.idoBlock.getOriginator();
        }
        return null;
    }

    public Currency getOriginalCurrency() {
        if (this.mmoBlock != null) {
            return this.mmoBlock.getOriginalCurrency();
        }
        return null;
    }

    public BigDecimal getOriginalAmount() {
        if (this.mmoBlock != null) {
            return this.mmoBlock.getOriginalAmount();
        }
        return null;
    }

    private void appendSpaces(StringBuffer sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
    }

    public List<String> getContents() {
        ArrayList<String> contents = new ArrayList<String>();
        contents.add(this.block04.getContent());
        if (this.libBlocks != null && this.libBlocks.size() > 0) {
            for (CFONB120Block05 libBlock : this.libBlocks) {
                contents.add(libBlock.getContent());
            }
        }
        if (this.idoBlock != null) {
            contents.add(this.idoBlock.getContent());
        }
        if (this.mmoBlock != null) {
            contents.add(this.mmoBlock.getContent());
        }
        return contents;
    }

    public void parseContent() {
        this.block04.parseContent();
        if (this.libBlocks != null && this.libBlocks.size() > 0) {
            for (CFONB120Block05 libBlock : this.libBlocks) {
                libBlock.parseContent();
            }
        }
        if (this.idoBlock != null) {
            this.idoBlock.parseContent();
        }
        if (this.mmoBlock != null) {
            this.mmoBlock.parseContent();
        }
    }
}

