/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.cfonb120;

import de.businesslogics.format.cfonb120.CFONB120AmountConverter;
import de.businesslogics.format.cfonb120.CFONB120Block;
import java.math.BigDecimal;
import java.util.Currency;

public class CFONB120Block05
extends CFONB120Block {
    protected static final String LIB = "LIB";
    protected static final String MMO = "MMO";
    protected static final String IDO = "IDO";
    private String blockQualifier;
    private String additionalPurpose;
    private String originatorBankCode;
    private String originatorBranchCode;
    private String originatorAccountNumber;
    private String originator;
    private Currency originalCurrency;
    private BigDecimal originalAmount;

    public CFONB120Block05(String block) {
        super(block);
    }

    @Override
    protected void parseSpecialPart() {
        this.blockQualifier = this.content.substring(45, 48);
        if (LIB.equals(this.blockQualifier)) {
            this.additionalPurpose = this.content.substring(48, 118).trim();
        } else if (IDO.equals(this.blockQualifier)) {
            this.originatorBankCode = this.content.substring(52, 57).trim();
            this.originatorBranchCode = this.content.substring(57, 62).trim();
            this.originatorAccountNumber = this.content.substring(62, 73).trim();
            this.originator = this.content.substring(73, 118).trim();
        } else if (MMO.equals(this.blockQualifier)) {
            try {
                String currencyCode = this.content.substring(48, 51);
                this.originalCurrency = Currency.getInstance(currencyCode);
                int numberOfDecimals = Integer.parseInt(this.content.substring(51, 52));
                String amountStr = this.content.substring(52, 66);
                this.originalAmount = CFONB120AmountConverter.convertToBigDecimal(amountStr, numberOfDecimals);
            }
            catch (Exception exception) {}
        } else {
            this.additionalPurpose = this.content.substring(48, 118).trim();
        }
    }

    public String getBlockQualifier() {
        return this.blockQualifier;
    }

    public String getAdditionalPurpose() {
        return this.additionalPurpose;
    }

    public String getOriginatorBankCode() {
        return this.originatorBankCode;
    }

    public String getOriginatorBranchCode() {
        return this.originatorBranchCode;
    }

    public String getOriginatorAccountNumber() {
        return this.originatorAccountNumber;
    }

    public String getOriginator() {
        return this.originator;
    }

    public Currency getOriginalCurrency() {
        return this.originalCurrency;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }
}

