/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.cfonb120;

import de.businesslogics.format.cfonb120.CFONB120AmountConverter;
import de.businesslogics.format.cfonb120.CFONB120Block05;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class CFONB120Block {
    protected static ThreadLocal<SimpleDateFormat> DDMMYY = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("ddMMyy");
        }
    };
    private static final char SLASH = '/';
    public static final String BLOCK_TYPE_01 = "01";
    public static final String BLOCK_TYPE_04 = "04";
    public static final String BLOCK_TYPE_05 = "05";
    public static final String BLOCK_TYPE_07 = "07";
    public static final String BLOCK_TYPE_08 = "08";
    public static final String BLOCK_TYPE_09 = "09";
    protected String content;
    private String bankCode;
    private String branchCode;
    private String accountNumber;
    private String currencyCode;
    private Currency currency;
    private int numberOfDecimals;
    private String dateAsDDMMYY;
    private String dateAsYYMMDD;
    private Date date;
    private String amountStr;
    private BigDecimal amount;
    private String accountIdentifier;
    private String rib;
    private String transactionCode;
    private String interbankTransactionCode;

    public CFONB120Block(String block) {
        this.content = block;
        this.bankCode = block.substring(2, 7);
        this.branchCode = block.substring(11, 16);
        this.currencyCode = block.substring(16, 19);
        this.accountNumber = block.substring(21, 32);
        this.dateAsDDMMYY = block.substring(34, 40);
        try {
            this.date = DDMMYY.get().parse(this.dateAsDDMMYY);
        }
        catch (Exception e) {
            this.date = null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.bankCode);
        sb.append('/');
        sb.append(this.branchCode);
        sb.append('/');
        sb.append(this.accountNumber);
        sb.append('/');
        sb.append(this.currencyCode);
        this.accountIdentifier = sb.toString();
    }

    public String getContent() {
        return this.content;
    }

    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getBranchCode() {
        return this.branchCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public Currency getCurrency() {
        if (this.currency == null) {
            this.currency = Currency.getInstance(this.currencyCode);
        }
        return this.currency;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getRIB() {
        if (this.rib == null) {
            this.rib = PaymentUtils.getRib(this.bankCode, this.branchCode, this.accountNumber, null, '/');
        }
        return this.rib;
    }

    public String getDateAsYYMMDD() {
        if (this.dateAsYYMMDD == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.dateAsDDMMYY.substring(4));
            sb.append(this.dateAsDDMMYY.substring(2, 4));
            sb.append(this.dateAsDDMMYY.substring(0, 2));
            this.dateAsYYMMDD = sb.toString();
        }
        return this.dateAsYYMMDD;
    }

    protected void parseContent() {
        this.parseGeneralPart();
        this.parseSpecialPart();
    }

    protected void parseGeneralPart() {
        this.transactionCode = this.content.substring(7, 11).trim();
        try {
            this.numberOfDecimals = Integer.parseInt(this.content.substring(19, 20));
        }
        catch (NumberFormatException e) {
            this.numberOfDecimals = 2;
        }
        this.interbankTransactionCode = this.content.substring(32, 34).trim();
        if (!(this instanceof CFONB120Block05)) {
            this.amountStr = this.content.substring(90, 104);
            this.amount = CFONB120AmountConverter.convertToBigDecimal(this.amountStr, this.numberOfDecimals);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getTransactionCode() {
        return this.transactionCode;
    }

    public String getInterbankTransactionCode() {
        return this.interbankTransactionCode;
    }

    public int getNumberOfDecimals() {
        return this.numberOfDecimals;
    }

    protected abstract void parseSpecialPart();
}

