/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.cfonb120;

import java.math.BigDecimal;
import java.util.regex.Pattern;

public class CFONB120AmountConverter {
    private static Pattern lastDigitPattern = Pattern.compile("[A-R{}]");
    private static final BigDecimal MAX_AMOUNT = new BigDecimal("999999999999.99");
    private static final BigDecimal MIN_AMOUNT = new BigDecimal("-999999999999.99");

    public static BigDecimal convertToBigDecimal(String s, int numberOfDecimals) {
        char lastDigit;
        if (s == null || s.length() != 14) {
            return null;
        }
        String integerPart = "0";
        int lengthIntegerPart = Math.min(13, 14 - numberOfDecimals);
        for (int i = 0; i < lengthIntegerPart; ++i) {
            if (s.charAt(i) == '0') continue;
            integerPart = s.substring(i, lengthIntegerPart);
            break;
        }
        boolean isCredit = true;
        char c = s.charAt(13);
        switch (c) {
            case '{': {
                lastDigit = '0';
                break;
            }
            case 'A': {
                lastDigit = '1';
                break;
            }
            case 'B': {
                lastDigit = '2';
                break;
            }
            case 'C': {
                lastDigit = '3';
                break;
            }
            case 'D': {
                lastDigit = '4';
                break;
            }
            case 'E': {
                lastDigit = '5';
                break;
            }
            case 'F': {
                lastDigit = '6';
                break;
            }
            case 'G': {
                lastDigit = '7';
                break;
            }
            case 'H': {
                lastDigit = '8';
                break;
            }
            case 'I': {
                lastDigit = '9';
                break;
            }
            case '}': {
                lastDigit = '0';
                isCredit = false;
                break;
            }
            case 'J': {
                lastDigit = '1';
                isCredit = false;
                break;
            }
            case 'K': {
                lastDigit = '2';
                isCredit = false;
                break;
            }
            case 'L': {
                lastDigit = '3';
                isCredit = false;
                break;
            }
            case 'M': {
                lastDigit = '4';
                isCredit = false;
                break;
            }
            case 'N': {
                lastDigit = '5';
                isCredit = false;
                break;
            }
            case 'O': {
                lastDigit = '6';
                isCredit = false;
                break;
            }
            case 'P': {
                lastDigit = '7';
                isCredit = false;
                break;
            }
            case 'Q': {
                lastDigit = '8';
                isCredit = false;
                break;
            }
            case 'R': {
                lastDigit = '9';
                isCredit = false;
                break;
            }
            default: {
                return null;
            }
        }
        StringBuffer sb = new StringBuffer();
        if (!isCredit) {
            sb.append('-');
        }
        sb.append(integerPart);
        if (numberOfDecimals > 0) {
            sb.append('.');
            for (int i = lengthIntegerPart; i < 13; ++i) {
                sb.append(s.charAt(i));
            }
        }
        sb.append(lastDigit);
        try {
            return new BigDecimal(sb.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String convertToString(BigDecimal bd) {
        boolean isCredit;
        if (bd == null) {
            return null;
        }
        if (bd.compareTo(MAX_AMOUNT) > 0 || bd.compareTo(MIN_AMOUNT) < 0) {
            return null;
        }
        if (bd.signum() == 0) {
            return "0000000000000{";
        }
        boolean bl = isCredit = bd.signum() > 0;
        if (!isCredit) {
            bd = bd.abs();
        }
        String s = bd.toPlainString();
        String integerPart = "";
        String decimalPart = "";
        int indexOfDecimalPoint = s.indexOf(46);
        if (indexOfDecimalPoint >= 0) {
            integerPart = s.substring(0, indexOfDecimalPoint);
            if (s.length() > indexOfDecimalPoint) {
                decimalPart = s.substring(indexOfDecimalPoint + 1);
            }
        } else {
            integerPart = s;
        }
        int lengthIntegerPart = integerPart.length();
        int lengthDecimalPart = decimalPart.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 12 - lengthIntegerPart; ++i) {
            sb.append('0');
        }
        sb.append(integerPart);
        if (lengthDecimalPart == 0) {
            if (isCredit) {
                sb.append("0{");
            } else {
                sb.append("0}");
            }
        } else if (lengthDecimalPart == 1) {
            sb.append(decimalPart.charAt(0));
            if (isCredit) {
                sb.append('{');
            } else {
                sb.append('}');
            }
        } else {
            sb.append(decimalPart.charAt(0));
            sb.append(CFONB120AmountConverter.getLastDigit(decimalPart.charAt(1), isCredit));
        }
        return sb.toString();
    }

    private static char getLastDigit(char number, boolean isCredit) {
        if (isCredit) {
            switch (number) {
                case '0': {
                    return '{';
                }
                case '1': {
                    return 'A';
                }
                case '2': {
                    return 'B';
                }
                case '3': {
                    return 'C';
                }
                case '4': {
                    return 'D';
                }
                case '5': {
                    return 'E';
                }
                case '6': {
                    return 'F';
                }
                case '7': {
                    return 'G';
                }
                case '8': {
                    return 'H';
                }
            }
            return 'I';
        }
        switch (number) {
            case '0': {
                return '}';
            }
            case '1': {
                return 'J';
            }
            case '2': {
                return 'K';
            }
            case '3': {
                return 'L';
            }
            case '4': {
                return 'M';
            }
            case '5': {
                return 'N';
            }
            case '6': {
                return 'O';
            }
            case '7': {
                return 'P';
            }
            case '8': {
                return 'Q';
            }
        }
        return 'R';
    }

    public static boolean isLastDigitValid(String s) {
        return lastDigitPattern.matcher(s).matches();
    }
}

