/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt05x;

import de.businesslogics.format.camt05x.Booking;
import de.businesslogics.format.swift.mt940.CMUtil;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;

public abstract class BaseBooking
implements Booking {
    protected BigDecimal amount;
    private boolean hasNegativeAmount;
    protected Currency currency;
    private boolean isDirectDebit = false;
    protected boolean isReversal;
    protected String status;
    protected String domainCode;
    protected String familyCode;
    protected String subFamilyCode;
    private String transactionCode;
    private String bookingKey;
    private String gvc;
    private String primanota;
    private String textKeyAppendix;
    protected String counterParty;
    protected String counterPartyAccount;
    protected String counterPartyBankCode;
    protected String counterPartyCreditorId;
    protected String ultimateCounterParty;
    protected String localParty;
    protected String localPartyAccount;
    protected String localPartyBankCode;
    protected String localPartyCreditorId;
    protected String ultimateLocalParty;
    protected String mandateId;
    protected String ntryRef;
    protected Integer nbOfTxs;

    @Override
    public final BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public final Currency getCurrency() {
        return this.currency;
    }

    @Override
    public final boolean isDirectDebit() {
        return this.isDirectDebit;
    }

    @Override
    public final boolean isReversal() {
        return this.isReversal;
    }

    @Override
    public final String getStatus() {
        return this.status;
    }

    @Override
    public final String getDomainCode() {
        return this.domainCode;
    }

    @Override
    public final String getFamilyCode() {
        return this.familyCode;
    }

    @Override
    public final String getSubFamilyCode() {
        return this.subFamilyCode;
    }

    @Override
    public final String getTransactionCode() {
        return this.transactionCode;
    }

    @Override
    public final String getBookingKey() {
        return this.bookingKey;
    }

    @Override
    public final String getGvc() {
        return this.gvc;
    }

    @Override
    public final String getPrimanota() {
        return this.primanota;
    }

    @Override
    public final String getTextKeyAppendix() {
        return this.textKeyAppendix;
    }

    @Override
    public final String getCounterParty() {
        return this.counterParty;
    }

    @Override
    public final String getCounterPartyAccount() {
        return this.counterPartyAccount;
    }

    @Override
    public final String getCounterPartyBankCode() {
        return this.counterPartyBankCode;
    }

    @Override
    public final String getCounterPartyCreditorId() {
        return this.counterPartyCreditorId;
    }

    @Override
    public final String getUltimateCounterParty() {
        return this.ultimateCounterParty;
    }

    @Override
    public final String getLocalParty() {
        return this.localParty;
    }

    @Override
    public final String getLocalPartyAccount() {
        return this.localPartyAccount;
    }

    @Override
    public final String getLocalPartyBankCode() {
        return this.localPartyBankCode;
    }

    @Override
    public final String getLocalPartyCreditorId() {
        return this.localPartyCreditorId;
    }

    @Override
    public final String getUltimateLocalParty() {
        return this.ultimateLocalParty;
    }

    @Override
    public final String getMandateId() {
        return this.mandateId;
    }

    @Override
    public final String getNtryRef() {
        return this.ntryRef;
    }

    @Override
    public final Integer getNbOfTxs() {
        return this.nbOfTxs;
    }

    public void setNbOfTxs(Integer nbOfTxs) {
        this.nbOfTxs = nbOfTxs;
    }

    protected final void setHasNegativeAmount(String creditDebitIndicator) {
        this.hasNegativeAmount = "DBIT".equals(creditDebitIndicator);
    }

    protected final boolean isCounterPartyCreditor() {
        if (this.isReversal) {
            return !this.hasNegativeAmount;
        }
        return this.hasNegativeAmount;
    }

    protected void evaluateTransactionCode(String txCode) {
        String[] array;
        if (txCode != null && (array = txCode.split("\\+")) != null) {
            if (array.length > 0) {
                String s = array[0];
                if (s != null && s.length() == 4 && s.startsWith("N")) {
                    this.bookingKey = s.substring(1);
                } else {
                    this.transactionCode = BaseBooking.shorten(s, 4);
                }
            }
            if (array.length > 1) {
                this.gvc = BaseBooking.shorten(array[1], 3);
            }
            if (array.length > 2) {
                this.primanota = BaseBooking.shorten(array[2], 10);
            }
            if (array.length > 3) {
                this.textKeyAppendix = BaseBooking.shorten(array[3], 3);
            }
        }
    }

    private static String shorten(String in, int maxLengh) {
        if (in == null) {
            return null;
        }
        if (in.length() <= maxLengh) {
            return in;
        }
        return in.substring(0, maxLengh);
    }

    protected void determineGvcFromISOBtc() {
        if (this.gvc == null) {
            // empty if block
        }
    }

    protected void determineDirectDebitFlag() {
        this.isDirectDebit = CMUtil.isDirectDebit(this.gvc) || this.mandateId != null && this.mandateId.length() > 0 || this.counterPartyCreditorId != null && this.counterPartyCreditorId.length() > 0 || this.localPartyCreditorId != null && this.localPartyCreditorId.length() > 0;
    }
}

