/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.format.iso20022.camt05400102.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05400102.AccountNotification2;
import de.businesslogics.format.iso20022.camt05400102.BankToCustomerDebitCreditNotificationV02;
import de.businesslogics.format.iso20022.camt05400102.CashAccount20;
import de.businesslogics.format.iso20022.camt05400102.Document;
import de.businesslogics.format.iso20022.camt05400102.GroupHeader42;
import de.businesslogics.format.iso20022.camt05400102.Pagination;
import de.businesslogics.format.iso20022.camt05400102.ReportEntry2;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt054Statement {
    private GroupHeader42 header;
    private AccountNotification2 statement;

    public Camt054Statement() {
    }

    Camt054Statement(GroupHeader42 header, AccountNotification2 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount20 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        if (this.statement.getNtrys().size() > 0) {
            ReportEntry2 entry = this.statement.getNtrys().get(0);
            return Currency.getInstance(entry.getAmt().getCcy().getValue());
        }
        return Currency.getInstance("EUR");
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination pagination = this.header.getMsgPgntn();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            if ("1".equals(pageNumber) && isLastPage) {
                return 0;
            }
            try {
                return Integer.parseInt(pageNumber);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        return this.statement.getCreDtTm().getDate();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlNtfctnInf() != null) {
            return this.statement.getAddtlNtfctnInf().getValue();
        }
        return null;
    }

    public GroupHeader42 getHeader() {
        return this.header;
    }

    public AccountNotification2 getStatement() {
        return this.statement;
    }

    public static List<Camt054Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt054Statement> statements = new ArrayList<Camt054Statement>();
        BankToCustomerDebitCreditNotificationV02 msg = d.getBkToCstmrDbtCdtNtfctn();
        GroupHeader42 header = msg.getGrpHdr();
        for (AccountNotification2 accountStatement : msg.getNtfctns()) {
            statements.add(new Camt054Statement(header, accountStatement));
        }
        return statements;
    }
}

