/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.format.camt054.Camt054Util;
import de.businesslogics.format.camt05x.ChargeRecord;
import de.businesslogics.format.iso20022.camt05400102.ChargeType2Choice;
import de.businesslogics.format.iso20022.camt05400102.ChargesInformation6;
import de.businesslogics.format.iso20022.camt05400102.ClearingSystemIdentification2Choice;
import de.businesslogics.format.iso20022.camt05400102.FinancialInstitutionIdentification7;
import java.io.Serializable;
import java.math.BigDecimal;

public class Camt054ChargeRecord
implements Serializable,
ChargeRecord {
    private static final long serialVersionUID = 1L;
    private final ChargesInformation6 chargesRecord;
    private final BigDecimal amount;
    private final String currencyCode;

    public Camt054ChargeRecord(ChargesInformation6 chargesRecord) {
        this.chargesRecord = chargesRecord;
        this.amount = Camt054Util.getAmount(chargesRecord.getAmt(), chargesRecord.getCdtDbtInd());
        this.currencyCode = chargesRecord.getAmt().getCcy().getValue();
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public BigDecimal getRate() {
        if (this.chargesRecord.getRate() != null) {
            return this.chargesRecord.getRate().getValue();
        }
        return null;
    }

    @Override
    public boolean isIncluded() {
        return true;
    }

    @Override
    public String getBankIdentification() {
        if (this.chargesRecord.getPty() != null) {
            FinancialInstitutionIdentification7 identification = this.chargesRecord.getPty().getFinInstnId();
            if (identification.getBIC() != null) {
                return identification.getBIC().getValue();
            }
            if (identification.getNm() != null) {
                return identification.getNm().getValue();
            }
            if (identification.getOthr() != null) {
                return identification.getOthr().getId().getValue();
            }
            if (identification.getClrSysMmbId() != null) {
                String clearingSystem = null;
                ClearingSystemIdentification2Choice clrSysIdChoice = identification.getClrSysMmbId().getClrSysId();
                if (clrSysIdChoice != null) {
                    if (clrSysIdChoice.getChoice1().getCd() != null) {
                        clearingSystem = clrSysIdChoice.getChoice1().getCd().getValue();
                    } else if (clrSysIdChoice.getChoice1().getPrtry() != null) {
                        clearingSystem = clrSysIdChoice.getChoice1().getPrtry().getValue();
                    }
                }
                if (clearingSystem != null) {
                    return identification.getClrSysMmbId().getMmbId().getValue() + " (" + clearingSystem + ")";
                }
                return identification.getClrSysMmbId().getMmbId().getValue();
            }
        }
        return null;
    }

    @Override
    public String getType() {
        if (this.chargesRecord.getTp() != null) {
            ChargeType2Choice.ChargeType2Choice_C1 typeChoice = this.chargesRecord.getTp().getChoice1();
            if (typeChoice.getCd() != null) {
                return typeChoice.getCd().getValue();
            }
            if (typeChoice.getPrtry() != null) {
                return typeChoice.getPrtry().getId().getValue();
            }
        }
        return null;
    }

    @Override
    public String getChargeBearerType() {
        if (this.chargesRecord.getBr() != null) {
            return this.chargesRecord.getBr().getValue();
        }
        return null;
    }

    @Override
    public String getTaxIdentification() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getId() != null) {
            return this.chargesRecord.getTax().getId().getValue();
        }
        return null;
    }

    @Override
    public BigDecimal getTaxAmount() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getAmt() != null) {
            return this.chargesRecord.getTax().getAmt().getValue();
        }
        return null;
    }

    @Override
    public String getTaxCurrencyCode() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getAmt() != null) {
            return this.chargesRecord.getTax().getAmt().getCcy().getValue();
        }
        return null;
    }

    @Override
    public BigDecimal getTaxRate() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getRate() != null) {
            return this.chargesRecord.getTax().getRate().getValue();
        }
        return null;
    }
}

