/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.camt.StrdPurposeContentHandler;
import de.businesslogics.format.camt054.Camt054ChargeRecord;
import de.businesslogics.format.camt054.Camt054Util;
import de.businesslogics.format.camt05x.BaseBooking;
import de.businesslogics.format.camt05x.ChargeRecord;
import de.businesslogics.format.iso20022.camt05400102.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.camt05400102.AmountAndCurrencyExchange3;
import de.businesslogics.format.iso20022.camt05400102.BankTransactionCodeStructure4;
import de.businesslogics.format.iso20022.camt05400102.BankTransactionCodeStructure5;
import de.businesslogics.format.iso20022.camt05400102.BatchInformation2;
import de.businesslogics.format.iso20022.camt05400102.ChargesInformation6;
import de.businesslogics.format.iso20022.camt05400102.CurrencyExchange5;
import de.businesslogics.format.iso20022.camt05400102.EntryDetails1;
import de.businesslogics.format.iso20022.camt05400102.EntryTransaction2;
import de.businesslogics.format.iso20022.camt05400102.ExternalPurpose1Code;
import de.businesslogics.format.iso20022.camt05400102.ExternalReturnReason1Code;
import de.businesslogics.format.iso20022.camt05400102.Max105Text;
import de.businesslogics.format.iso20022.camt05400102.Max140Text;
import de.businesslogics.format.iso20022.camt05400102.Max35Text;
import de.businesslogics.format.iso20022.camt05400102.PartyIdentification32;
import de.businesslogics.format.iso20022.camt05400102.ReportEntry2;
import de.businesslogics.format.iso20022.camt05400102.StructuredRemittanceInformation7;
import de.businesslogics.format.iso20022.camt05400102.TransactionAgents2;
import de.businesslogics.format.iso20022.camt05400102.TransactionParty2;
import de.businesslogics.format.iso20022.camt05400102.TransactionReferences2;
import de.businesslogics.format.swift.mt940.CMUtil;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Camt054Booking
extends BaseBooking {
    private final ReportEntry2 ntry;
    private final EntryDetails1 details;
    private final EntryTransaction2 transaction;
    private BigDecimal calculatedTotalChargesAmount = null;
    private String uniqueCurrencyCode = null;
    private final List<ChargeRecord> chargesRecordsOnTxLevel = new ArrayList<ChargeRecord>();
    private final List<ChargeRecord> chargesRecordsOnNtryLevel = new ArrayList<ChargeRecord>();

    public Camt054Booking(ReportEntry2 ntry, EntryDetails1 details, EntryTransaction2 transaction) {
        Iterator<ChargesInformation6> batch;
        this.ntry = ntry;
        this.details = details;
        this.transaction = transaction;
        if (ntry != null) {
            this.amount = this.internalGetAmount();
            this.setHasNegativeAmount(ntry.getCdtDbtInd().getValue());
            this.currency = Currency.getInstance(ntry.getAmt().getCcy().getValue());
            this.isReversal = ntry.getRvslInd() != null ? ntry.getRvslInd().booleanValue() : false;
            this.status = ntry.getSts().getValue();
            if (ntry.getNtryRef() != null) {
                this.ntryRef = ntry.getNtryRef().getValue();
            }
        }
        if (details != null && (batch = details.getBtch()) != null && ((BatchInformation2)((Object)batch)).getNbOfTxs() != null) {
            try {
                this.nbOfTxs = Integer.valueOf(((BatchInformation2)((Object)batch)).getNbOfTxs().getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.transaction != null && this.transaction.getChrgss() != null && this.transaction.getChrgss().size() > 0) {
            for (ChargesInformation6 chrgRcrd : this.transaction.getChrgss()) {
                this.chargesRecordsOnTxLevel.add(new Camt054ChargeRecord(chrgRcrd));
            }
            this.calculateTotalChargesAmount(this.chargesRecordsOnTxLevel);
        } else if (this.ntry != null && this.ntry.getChrgss() != null && this.ntry.getChrgss().size() > 0) {
            for (ChargesInformation6 chrgRcrd : this.ntry.getChrgss()) {
                this.chargesRecordsOnNtryLevel.add(new Camt054ChargeRecord(chrgRcrd));
            }
            this.calculateTotalChargesAmount(this.chargesRecordsOnNtryLevel);
        }
        BankTransactionCodeStructure4 btc = null;
        if (transaction != null && (btc = transaction.getBkTxCd()) != null) {
            this.extractBTC(btc);
        }
        if (btc == null && ntry != null) {
            this.extractBTC(ntry.getBkTxCd());
        }
        if (!this.isReversal) {
            this.isReversal = CMUtil.isReversal(this.getGvc());
        }
        if (transaction != null) {
            TransactionReferences2 references;
            TransactionAgents2 agents;
            TransactionParty2 parties = transaction.getRltdPties();
            if (parties != null) {
                PartyIdentification32 creditor = parties.getCdtr();
                PartyIdentification32 debtor = parties.getDbtr();
                if (this.isCounterPartyCreditor()) {
                    this.counterParty = Camt054Util.getPartyName(creditor);
                    this.counterPartyAccount = Camt054Util.getAccount(parties.getCdtrAcct());
                    this.counterPartyCreditorId = Camt054Util.getCreditorId(creditor);
                    this.ultimateCounterParty = Camt054Util.getPartyName(parties.getUltmtCdtr());
                    this.localParty = Camt054Util.getPartyName(debtor);
                    this.localPartyAccount = Camt054Util.getAccount(parties.getDbtrAcct());
                    this.localPartyCreditorId = Camt054Util.getCreditorId(debtor);
                    this.ultimateLocalParty = Camt054Util.getPartyName(parties.getUltmtDbtr());
                } else {
                    this.counterParty = Camt054Util.getPartyName(debtor);
                    this.counterPartyAccount = Camt054Util.getAccount(parties.getDbtrAcct());
                    this.counterPartyCreditorId = Camt054Util.getCreditorId(debtor);
                    this.ultimateCounterParty = Camt054Util.getPartyName(parties.getUltmtDbtr());
                    this.localParty = Camt054Util.getPartyName(creditor);
                    this.localPartyAccount = Camt054Util.getAccount(parties.getCdtrAcct());
                    this.localPartyCreditorId = Camt054Util.getCreditorId(creditor);
                    this.ultimateLocalParty = Camt054Util.getPartyName(parties.getUltmtCdtr());
                }
            }
            if ((agents = transaction.getRltdAgts()) != null) {
                if (this.isCounterPartyCreditor()) {
                    this.counterPartyBankCode = Camt054Util.getBic(agents.getCdtrAgt());
                    this.localPartyBankCode = Camt054Util.getBic(agents.getDbtrAgt());
                } else {
                    this.counterPartyBankCode = Camt054Util.getBic(agents.getDbtrAgt());
                    this.localPartyBankCode = Camt054Util.getBic(agents.getCdtrAgt());
                }
            }
            if ((references = transaction.getRefs()) != null && references.getMndtId() != null) {
                this.mandateId = transaction.getRefs().getMndtId().getValue();
            }
        }
        this.determineDirectDebitFlag();
    }

    private void extractBTC(BankTransactionCodeStructure4 btc) {
        if (btc != null) {
            BankTransactionCodeStructure5 domain = btc.getDomn();
            if (domain != null) {
                this.domainCode = domain.getCd().getValue();
                this.familyCode = domain.getFmly().getCd().getValue();
                this.subFamilyCode = domain.getFmly().getSubFmlyCd().getValue();
            }
            if (btc.getPrtry() != null) {
                this.evaluateTransactionCode(btc.getPrtry().getCd().getValue());
            }
            this.determineGvcFromISOBtc();
        }
    }

    private void calculateTotalChargesAmount(List<ChargeRecord> chargeRecords) {
        if (chargeRecords.size() > 1) {
            boolean hasUniqueCurrency = true;
            this.calculatedTotalChargesAmount = BigDecimal.ZERO;
            for (ChargeRecord chargeRecord : chargeRecords) {
                if (!hasUniqueCurrency) continue;
                String recordCurrencyCode = chargeRecord.getCurrencyCode();
                if (this.uniqueCurrencyCode != null && !this.uniqueCurrencyCode.equals(recordCurrencyCode)) {
                    hasUniqueCurrency = false;
                    this.calculatedTotalChargesAmount = null;
                    this.uniqueCurrencyCode = null;
                    continue;
                }
                if (this.uniqueCurrencyCode == null) {
                    this.uniqueCurrencyCode = recordCurrencyCode;
                }
                this.calculatedTotalChargesAmount = this.calculatedTotalChargesAmount.add(chargeRecord.getAmount());
            }
        }
    }

    private BigDecimal internalGetAmount() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getTxAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getTxAmt().getAmt();
            return Camt054Util.getAmount(amt, this.ntry.getCdtDbtInd());
        }
        return Camt054Util.getAmount(this.ntry.getAmt(), this.ntry.getCdtDbtInd());
    }

    @Override
    public Date getBookingDate() {
        return Camt054Util.getDateFromChoice(this.ntry.getBookgDt());
    }

    @Override
    public Date getValueDate() {
        return Camt054Util.getDateFromChoice(this.ntry.getValDt());
    }

    @Override
    public String getDtiReference() {
        if (this.ntry.getAddtlInfInd() != null && this.ntry.getAddtlInfInd().getMsgId() != null) {
            return this.ntry.getAddtlInfInd().getMsgId().getValue();
        }
        if (this.transaction != null && this.transaction.getRefs() != null) {
            String intrId = Camt054Util.getValue(this.transaction.getRefs().getInstrId());
            if (intrId != null && !"NOTPROVIDED".equals(intrId)) {
                return intrId;
            }
            String clrSysRef = Camt054Util.getValue(this.transaction.getRefs().getClrSysRef());
            if (clrSysRef != null && !"NOTPROVIDED".equals(clrSysRef)) {
                return clrSysRef;
            }
        }
        return null;
    }

    @Override
    public String getMsgId() {
        if (this.ntry.getAddtlInfInd() != null && this.ntry.getAddtlInfInd().getMsgId() != null) {
            return this.ntry.getAddtlInfInd().getMsgId().getValue();
        }
        if (this.details != null && this.details.getBtch() != null && this.details.getBtch().getMsgId() != null) {
            return this.details.getBtch().getMsgId().getValue();
        }
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getMsgId() != null) {
            return this.transaction.getRefs().getMsgId().getValue();
        }
        return null;
    }

    @Override
    public String getPmtInfId() {
        if (this.details != null && this.details.getBtch() != null && this.details.getBtch().getPmtInfId() != null) {
            return this.details.getBtch().getPmtInfId().getValue();
        }
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getPmtInfId() != null) {
            return this.transaction.getRefs().getPmtInfId().getValue();
        }
        return null;
    }

    @Override
    public String getEndToEndId() {
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getEndToEndId() != null) {
            return this.transaction.getRefs().getEndToEndId().getValue();
        }
        return null;
    }

    @Override
    public String getTransactionId() {
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getTxId() != null) {
            return this.transaction.getRefs().getTxId().getValue();
        }
        return null;
    }

    @Override
    public String getInstructionId() {
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getInstrId() != null) {
            return this.transaction.getRefs().getInstrId().getValue();
        }
        return null;
    }

    @Override
    public String getBankReference() {
        if (this.ntry.getAcctSvcrRef() != null) {
            return this.ntry.getAcctSvcrRef().getValue();
        }
        return null;
    }

    @Override
    public String getAdditionalInformation() {
        List<Max105Text> list;
        String firstText = null;
        if (this.ntry.getAddtlNtryInf() != null) {
            firstText = this.ntry.getAddtlNtryInf().getValue();
        }
        if (this.transaction != null && this.transaction.getRtrInf() != null && this.transaction.getRtrInf().getAddtlInfs() != null && (list = this.transaction.getRtrInf().getAddtlInfs()) != null) {
            StringBuilder b = firstText == null ? new StringBuilder() : new StringBuilder(firstText);
            for (Max105Text t : list) {
                if (b.length() > 0) {
                    b.append('\n');
                }
                b.append(t.getValue());
            }
            return b.toString();
        }
        return firstText;
    }

    @Override
    public BigDecimal getOriginalAmount() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getInstdAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getInstdAmt().getAmt();
            return Camt054Util.getAmount(amt, this.ntry.getCdtDbtInd());
        }
        return null;
    }

    @Override
    public Currency getOriginalCurrency() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getInstdAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getInstdAmt().getAmt();
            return Currency.getInstance(amt.getCcy().getValue());
        }
        return null;
    }

    @Override
    public BigDecimal getConvertedAmount() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getCntrValAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getCntrValAmt().getAmt();
            return Camt054Util.getAmount(amt, this.ntry.getCdtDbtInd());
        }
        return null;
    }

    @Override
    public Currency getConvertedCurrency() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getCntrValAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getCntrValAmt().getAmt();
            return Currency.getInstance(amt.getCcy().getValue());
        }
        return null;
    }

    @Override
    public BigDecimal getExchangeRate() {
        CurrencyExchange5 exchange;
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getCntrValAmt() != null && amtDtls.getCntrValAmt().getCcyXchg() != null && (exchange = amtDtls.getCntrValAmt().getCcyXchg()).getXchgRate() != null) {
            return exchange.getXchgRate().getValue();
        }
        return null;
    }

    @Override
    public BigDecimal getTotalChargesAmount() {
        return null;
    }

    @Override
    public String getTotalChargesCurrencyCode() {
        return null;
    }

    @Override
    public String getCalculatedTotalChargesCurrencyCode() {
        return this.uniqueCurrencyCode;
    }

    @Override
    public BigDecimal getCalculatedTotalChargesAmount() {
        return this.calculatedTotalChargesAmount;
    }

    @Override
    public List<ChargeRecord> getChargesRecordsOnTxLevel() {
        return this.chargesRecordsOnTxLevel;
    }

    @Override
    public List<ChargeRecord> getChargesRecordsOnNtryLevel() {
        return this.chargesRecordsOnNtryLevel;
    }

    @Override
    public String[] getPurpose() {
        if (this.transaction != null && this.transaction.getRmtInf() != null) {
            List<StructuredRemittanceInformation7> strds;
            ArrayList<String> purposeList = new ArrayList<String>();
            if (this.transaction.getRmtInf().getUstrds() != null) {
                List<Max140Text> texts = this.transaction.getRmtInf().getUstrds();
                for (Max140Text text : texts) {
                    purposeList.add(Camt054Util.getValue(text));
                }
            }
            if ((strds = this.transaction.getRmtInf().getStrds()) != null) {
                StructuredRemittanceInformation7 strd;
                if (strds.size() == 1 && (strd = strds.get(0)).getCdtrRefInf() != null && strd.getCdtrRefInf().getRef() != null) {
                    return new String[]{strd.getCdtrRefInf().getRef().getValue()};
                }
                for (StructuredRemittanceInformation7 s : strds) {
                    StrdPurposeContentHandler handler = new StrdPurposeContentHandler();
                    EbicsPrintStream print = new EbicsPrintStream(handler);
                    print.setPretty(false);
                    s.printOut("", print);
                    purposeList.add(handler.toString());
                }
            }
            if (!purposeList.isEmpty()) {
                return purposeList.toArray(new String[purposeList.size()]);
            }
        }
        return null;
    }

    @Override
    public String getPurposeCode() {
        if (this.transaction != null && this.transaction.getPurp() != null) {
            ExternalPurpose1Code purposeCode = this.transaction.getPurp().getChoice1().getCd();
            if (purposeCode != null) {
                return purposeCode.getValue();
            }
            Max35Text prtry = this.transaction.getPurp().getChoice1().getPrtry();
            if (prtry != null) {
                return prtry.getValue();
            }
        }
        return null;
    }

    @Override
    public String getRejectionCode() {
        ExternalReturnReason1Code code;
        if (this.transaction != null && this.transaction.getRtrInf() != null && this.transaction.getRtrInf().getRsn() != null && (code = this.transaction.getRtrInf().getRsn().getChoice1().getCd()) != null) {
            return code.getValue();
        }
        return null;
    }
}

