/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.iso20022.camt05400108.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.camt05400108.AmountAndCurrencyExchange3;
import de.businesslogics.format.iso20022.camt05400108.BranchAndFinancialInstitutionIdentification6;
import de.businesslogics.format.iso20022.camt05400108.CashAccount38;
import de.businesslogics.format.iso20022.camt05400108.CreditDebitCode;
import de.businesslogics.format.iso20022.camt05400108.DateAndDateTime2Choice;
import de.businesslogics.format.iso20022.camt05400108.EntryTransaction10;
import de.businesslogics.format.iso20022.camt05400108.Party40Choice;
import de.businesslogics.format.iso20022.camt05400108.PartyIdentification135;
import de.businesslogics.format.iso20022.camt05400108.PersonIdentification13;
import de.businesslogics.format.iso20022.camt05400108.ReportEntry10;
import java.math.BigDecimal;
import java.util.Date;

public class Camt05400108Util {
    public static BigDecimal getAmount(EntryTransaction10 transaction, ReportEntry10 ntry) {
        if (transaction != null) {
            ActiveOrHistoricCurrencyAndAmount amt = transaction.getAmt();
            if (amt != null) {
                if (transaction.getCdtDbtInd() != null) {
                    return Camt05400108Util.getAmount(amt, transaction.getCdtDbtInd());
                }
                return Camt05400108Util.getAmount(amt, ntry.getCdtDbtInd());
            }
            AmountAndCurrencyExchange3 amtDtls = transaction.getAmtDtls();
            if (amtDtls != null && amtDtls.getTxAmt() != null) {
                return Camt05400108Util.getAmount(amtDtls.getTxAmt().getAmt(), ntry.getCdtDbtInd());
            }
        }
        return Camt05400108Util.getAmount(ntry.getAmt(), ntry.getCdtDbtInd());
    }

    public static BigDecimal getAmount(ActiveOrHistoricCurrencyAndAmount amt, CreditDebitCode creditDebitCode) {
        if (creditDebitCode == null || "DBIT".equals(creditDebitCode.getValue())) {
            return amt.getValue().negate();
        }
        return amt.getValue();
    }

    public static Date getDateFromChoice(DateAndDateTime2Choice c) {
        if (c != null) {
            DateAndDateTime2Choice.DateAndDateTime2Choice_C1 choice = c.getChoice1();
            if (choice.getDt() != null) {
                return choice.getDt().getDate();
            }
            return choice.getDtTm().getDate();
        }
        return null;
    }

    public static String getBic(BranchAndFinancialInstitutionIdentification6 bank) {
        if (bank != null) {
            if (bank.getFinInstnId().getBICFI() != null) {
                return bank.getFinInstnId().getBICFI().getValue();
            }
            if (bank.getFinInstnId().getOthr() != null) {
                return bank.getFinInstnId().getOthr().getId().getValue();
            }
        }
        return null;
    }

    public static String getAccount(CashAccount38 account) {
        if (account != null) {
            if (account.getId().getChoice1().getIBAN() != null) {
                return account.getId().getChoice1().getIBAN().getValue();
            }
            return account.getId().getChoice1().getOthr().getId().getValue();
        }
        return null;
    }

    public static String getCreditorId(PartyIdentification135 cdtr) {
        PersonIdentification13 prvtId;
        if (cdtr != null && cdtr.getId() != null && (prvtId = cdtr.getId().getChoice1().getPrvtId()) != null && prvtId.getOthrs().size() > 0) {
            return Camt05400108Util.getValue(prvtId.getOthrs().get(0).getId());
        }
        return "";
    }

    public static String getPartyName(Party40Choice party) {
        if (party != null) {
            return Camt05400108Util.getPartyName(party.getChoice1().getPty());
        }
        return null;
    }

    public static String getPartyName(PartyIdentification135 party) {
        if (party != null) {
            return Camt05400108Util.getValue(party.getNm());
        }
        return null;
    }

    public static String getValue(SimpleStringElement e) {
        if (e != null) {
            return e.getValue();
        }
        return "";
    }
}

