/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.format.iso20022.camt05400108.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05400108.AccountNotification17;
import de.businesslogics.format.iso20022.camt05400108.BankToCustomerDebitCreditNotificationV08;
import de.businesslogics.format.iso20022.camt05400108.CashAccount39;
import de.businesslogics.format.iso20022.camt05400108.Document;
import de.businesslogics.format.iso20022.camt05400108.GroupHeader81;
import de.businesslogics.format.iso20022.camt05400108.Pagination1;
import de.businesslogics.format.iso20022.camt05400108.ReportEntry10;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt05400108Statement {
    private GroupHeader81 header;
    private AccountNotification17 statement;

    public Camt05400108Statement() {
    }

    Camt05400108Statement(GroupHeader81 header, AccountNotification17 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount39 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        if (this.statement.getNtrys().size() > 0) {
            ReportEntry10 entry = this.statement.getNtrys().get(0);
            return Currency.getInstance(entry.getAmt().getCcy().getValue());
        }
        return Currency.getInstance("EUR");
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination1 pagination = this.getPagination();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            if ("1".equals(pageNumber) && isLastPage) {
                return 0;
            }
            try {
                return Integer.parseInt(pageNumber);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    private Pagination1 getPagination() {
        Pagination1 pagination = this.statement.getNtfctnPgntn();
        if (pagination != null) {
            return pagination;
        }
        return this.header.getMsgPgntn();
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        if (this.statement.getCreDtTm() != null) {
            return this.statement.getCreDtTm().getDate();
        }
        return this.getCreationDateFromHeader();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlNtfctnInf() != null) {
            return this.statement.getAddtlNtfctnInf().getValue();
        }
        return null;
    }

    public GroupHeader81 getHeader() {
        return this.header;
    }

    public AccountNotification17 getStatement() {
        return this.statement;
    }

    public static List<Camt05400108Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt05400108Statement> statements = new ArrayList<Camt05400108Statement>();
        BankToCustomerDebitCreditNotificationV08 msg = d.getBkToCstmrDbtCdtNtfctn();
        GroupHeader81 header = msg.getGrpHdr();
        for (AccountNotification17 accountStatement : msg.getNtfctns()) {
            statements.add(new Camt05400108Statement(header, accountStatement));
        }
        return statements;
    }
}

