/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.format.camt054.Camt05400108ChargeRecord;
import de.businesslogics.format.camt05x.ChargeRecord;
import de.businesslogics.format.camt05x.Charges;
import de.businesslogics.format.iso20022.camt05400108.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.camt05400108.Charges6;
import de.businesslogics.format.iso20022.camt05400108.ChargesRecord3;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Camt05400108Charges
implements Serializable,
Charges {
    private static final long serialVersionUID = 1L;
    private final BigDecimal totalAmount;
    private final String currencyCode;
    private BigDecimal calculatedTotalAmount = null;
    private String uniqueCurrencyCode = null;
    private final List<ChargeRecord> chargesRecords = new ArrayList<ChargeRecord>();

    public Camt05400108Charges(Charges6 charges) {
        ActiveOrHistoricCurrencyAndAmount ttlAmt = charges.getTtlChrgsAndTaxAmt();
        if (ttlAmt != null) {
            this.totalAmount = ttlAmt.getValue().negate();
            this.currencyCode = ttlAmt.getCcy().getValue();
        } else {
            this.totalAmount = null;
            this.currencyCode = null;
        }
        List<ChargesRecord3> chrgRcrds = charges.getRcrds();
        if (chrgRcrds != null) {
            int countRecords = chrgRcrds.size();
            if (countRecords == 1) {
                this.chargesRecords.add(new Camt05400108ChargeRecord(chrgRcrds.get(0)));
            } else if (countRecords > 1) {
                boolean hasUniqueCurrency = true;
                this.calculatedTotalAmount = BigDecimal.ZERO;
                for (ChargesRecord3 chrgRcrd : chrgRcrds) {
                    Camt05400108ChargeRecord chargeRecord = new Camt05400108ChargeRecord(chrgRcrd);
                    this.chargesRecords.add(chargeRecord);
                    if (!hasUniqueCurrency) continue;
                    String recordCurrencyCode = chargeRecord.getCurrencyCode();
                    if (this.uniqueCurrencyCode != null && !this.uniqueCurrencyCode.equals(recordCurrencyCode)) {
                        hasUniqueCurrency = false;
                        this.calculatedTotalAmount = null;
                        this.uniqueCurrencyCode = null;
                        continue;
                    }
                    if (this.uniqueCurrencyCode == null) {
                        this.uniqueCurrencyCode = recordCurrencyCode;
                    }
                    this.calculatedTotalAmount = this.calculatedTotalAmount.add(chargeRecord.getAmount());
                }
            }
        }
    }

    @Override
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    @Override
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public BigDecimal getCalculatedTotalAmount() {
        return this.calculatedTotalAmount;
    }

    @Override
    public String getUniqueCurrencyCode() {
        return this.uniqueCurrencyCode;
    }

    @Override
    public List<ChargeRecord> getChargeRecords() {
        return this.chargesRecords;
    }
}

