/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.format.camt054.Camt05400108Util;
import de.businesslogics.format.camt05x.ChargeRecord;
import de.businesslogics.format.iso20022.camt05400108.ChargeType3Choice;
import de.businesslogics.format.iso20022.camt05400108.ChargesRecord3;
import de.businesslogics.format.iso20022.camt05400108.ClearingSystemIdentification2Choice;
import de.businesslogics.format.iso20022.camt05400108.FinancialInstitutionIdentification18;
import java.io.Serializable;
import java.math.BigDecimal;

public class Camt05400108ChargeRecord
implements Serializable,
ChargeRecord {
    private static final long serialVersionUID = 1L;
    private final ChargesRecord3 chargesRecord;
    private final BigDecimal amount;
    private final String currencyCode;

    public Camt05400108ChargeRecord(ChargesRecord3 chargesRecord) {
        this.chargesRecord = chargesRecord;
        this.amount = Camt05400108Util.getAmount(chargesRecord.getAmt(), chargesRecord.getCdtDbtInd());
        this.currencyCode = chargesRecord.getAmt().getCcy().getValue();
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public BigDecimal getRate() {
        if (this.chargesRecord.getRate() != null) {
            return this.chargesRecord.getRate().getValue();
        }
        return null;
    }

    @Override
    public boolean isIncluded() {
        if (this.chargesRecord.getChrgInclInd() != null) {
            return this.chargesRecord.getChrgInclInd().booleanValue();
        }
        return true;
    }

    @Override
    public String getBankIdentification() {
        if (this.chargesRecord.getAgt() != null) {
            FinancialInstitutionIdentification18 identification = this.chargesRecord.getAgt().getFinInstnId();
            if (identification.getBICFI() != null) {
                return identification.getBICFI().getValue();
            }
            if (identification.getNm() != null) {
                return identification.getNm().getValue();
            }
            if (identification.getOthr() != null) {
                return identification.getOthr().getId().getValue();
            }
            if (identification.getClrSysMmbId() != null) {
                String clearingSystem = null;
                ClearingSystemIdentification2Choice clrSysIdChoice = identification.getClrSysMmbId().getClrSysId();
                if (clrSysIdChoice != null) {
                    if (clrSysIdChoice.getChoice1().getCd() != null) {
                        clearingSystem = clrSysIdChoice.getChoice1().getCd().getValue();
                    } else if (clrSysIdChoice.getChoice1().getPrtry() != null) {
                        clearingSystem = clrSysIdChoice.getChoice1().getPrtry().getValue();
                    }
                }
                if (clearingSystem != null) {
                    return identification.getClrSysMmbId().getMmbId().getValue() + " (" + clearingSystem + ")";
                }
                return identification.getClrSysMmbId().getMmbId().getValue();
            }
            if (identification.getLEI() != null) {
                return identification.getLEI().getValue();
            }
        }
        return null;
    }

    @Override
    public String getType() {
        if (this.chargesRecord.getTp() != null) {
            ChargeType3Choice.ChargeType3Choice_C1 typeChoice = this.chargesRecord.getTp().getChoice1();
            if (typeChoice.getCd() != null) {
                return typeChoice.getCd().getValue();
            }
            if (typeChoice.getPrtry() != null) {
                return typeChoice.getPrtry().getId().getValue();
            }
        }
        return null;
    }

    @Override
    public String getChargeBearerType() {
        if (this.chargesRecord.getBr() != null) {
            return this.chargesRecord.getBr().getValue();
        }
        return null;
    }

    @Override
    public String getTaxIdentification() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getId() != null) {
            return this.chargesRecord.getTax().getId().getValue();
        }
        return null;
    }

    @Override
    public BigDecimal getTaxAmount() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getAmt() != null) {
            return this.chargesRecord.getTax().getAmt().getValue();
        }
        return null;
    }

    @Override
    public String getTaxCurrencyCode() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getAmt() != null) {
            return this.chargesRecord.getTax().getAmt().getCcy().getValue();
        }
        return null;
    }

    @Override
    public BigDecimal getTaxRate() {
        if (this.chargesRecord.getTax() != null && this.chargesRecord.getTax().getRate() != null) {
            return this.chargesRecord.getTax().getRate().getValue();
        }
        return null;
    }
}

