/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt054;

import de.businesslogics.format.iso20022.camt05400104.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05400104.AccountNotification7;
import de.businesslogics.format.iso20022.camt05400104.BankToCustomerDebitCreditNotificationV04;
import de.businesslogics.format.iso20022.camt05400104.CashAccount25;
import de.businesslogics.format.iso20022.camt05400104.Document;
import de.businesslogics.format.iso20022.camt05400104.GroupHeader58;
import de.businesslogics.format.iso20022.camt05400104.Pagination;
import de.businesslogics.format.iso20022.camt05400104.ReportEntry4;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt05400104Statement {
    private GroupHeader58 header;
    private AccountNotification7 statement;

    public Camt05400104Statement() {
    }

    private Camt05400104Statement(GroupHeader58 header, AccountNotification7 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount25 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        if (this.statement.getNtrys().size() > 0) {
            ReportEntry4 entry = this.statement.getNtrys().get(0);
            return Currency.getInstance(entry.getAmt().getCcy().getValue());
        }
        return Currency.getInstance("EUR");
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination pagination = this.getPagination();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            if ("1".equals(pageNumber) && isLastPage) {
                return 0;
            }
            try {
                return Integer.parseInt(pageNumber);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    private Pagination getPagination() {
        Pagination pagination = this.statement.getNtfctnPgntn();
        if (pagination != null) {
            return pagination;
        }
        return this.header.getMsgPgntn();
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        return this.statement.getCreDtTm().getDate();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlNtfctnInf() != null) {
            return this.statement.getAddtlNtfctnInf().getValue();
        }
        return null;
    }

    public GroupHeader58 getHeader() {
        return this.header;
    }

    public AccountNotification7 getStatement() {
        return this.statement;
    }

    public static List<Camt05400104Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt05400104Statement> statements = new ArrayList<Camt05400104Statement>();
        BankToCustomerDebitCreditNotificationV04 msg = d.getBkToCstmrDbtCdtNtfctn();
        GroupHeader58 header = msg.getGrpHdr();
        for (AccountNotification7 accountStatement : msg.getNtfctns()) {
            statements.add(new Camt05400104Statement(header, accountStatement));
        }
        return statements;
    }
}

