/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt053;

import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.iso20022.camt05300102.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.camt05300102.BranchAndFinancialInstitutionIdentification4;
import de.businesslogics.format.iso20022.camt05300102.CashAccount16;
import de.businesslogics.format.iso20022.camt05300102.CreditDebitCode;
import de.businesslogics.format.iso20022.camt05300102.DateAndDateTimeChoice;
import de.businesslogics.format.iso20022.camt05300102.PartyIdentification32;
import de.businesslogics.format.iso20022.camt05300102.PersonIdentification5;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class Camt053Util {
    public static BigDecimal getAmount(ActiveOrHistoricCurrencyAndAmount amt, CreditDebitCode creditDebitCode) {
        if (creditDebitCode == null || "DBIT".equals(creditDebitCode.getValue())) {
            return amt.getValue().negate();
        }
        return amt.getValue();
    }

    public static Date getDateFromChoice(DateAndDateTimeChoice c) {
        if (c != null) {
            DateAndDateTimeChoice.DateAndDateTimeChoice_C1 choice = c.getChoice1();
            if (choice.getDt() != null) {
                return choice.getDt().getDate();
            }
            return choice.getDtTm().getDate();
        }
        return null;
    }

    public static String getBic(BranchAndFinancialInstitutionIdentification4 bank) {
        if (bank != null) {
            if (bank.getFinInstnId().getBIC() != null) {
                return bank.getFinInstnId().getBIC().getValue();
            }
            if (bank.getFinInstnId().getOthr() != null) {
                return bank.getFinInstnId().getOthr().getId().getValue();
            }
        }
        return null;
    }

    public static String getAccount(CashAccount16 account) {
        if (account != null) {
            if (account.getId().getChoice1().getIBAN() != null) {
                return account.getId().getChoice1().getIBAN().getValue();
            }
            return account.getId().getChoice1().getOthr().getId().getValue();
        }
        return null;
    }

    public static String[] getName(PartyIdentification32 party) {
        if (party != null) {
            ArrayList<String> l = new ArrayList<String>();
            if (party.getNm() != null) {
                l.add(party.getNm().getValue());
            }
            return l.toArray(new String[l.size()]);
        }
        return null;
    }

    public static String getCreditorId(PartyIdentification32 cdtr) {
        PersonIdentification5 prvtId;
        if (cdtr != null && cdtr.getId() != null && (prvtId = cdtr.getId().getChoice1().getPrvtId()) != null && prvtId.getOthrs().size() > 0) {
            return Camt053Util.getValue(prvtId.getOthrs().get(0).getId());
        }
        return "";
    }

    public static String getPartyName(PartyIdentification32 party) {
        if (party != null) {
            return Camt053Util.getValue(party.getNm());
        }
        return null;
    }

    public static String getValue(SimpleStringElement e) {
        if (e != null) {
            return e.getValue();
        }
        return "";
    }
}

