/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt053;

import de.businesslogics.format.camt053.Camt053BalanceCode;
import de.businesslogics.format.camt053.Camt053Util;
import de.businesslogics.format.iso20022.camt05300102.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05300102.AccountStatement2;
import de.businesslogics.format.iso20022.camt05300102.BankToCustomerStatementV02;
import de.businesslogics.format.iso20022.camt05300102.CashAccount20;
import de.businesslogics.format.iso20022.camt05300102.CashBalance3;
import de.businesslogics.format.iso20022.camt05300102.Document;
import de.businesslogics.format.iso20022.camt05300102.GroupHeader42;
import de.businesslogics.format.iso20022.camt05300102.Pagination;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt053Statement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private GroupHeader42 header;
    private AccountStatement2 statement;

    public Camt053Statement() {
    }

    private Camt053Statement(GroupHeader42 header, AccountStatement2 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount20 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        CashBalance3 balance = this.statement.getBals().get(0);
        return Currency.getInstance(balance.getAmt().getCcy().getValue());
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination pagination = this.header.getMsgPgntn();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            int i = 0;
            try {
                i = Integer.parseInt(pageNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (i == 1 && isLastPage) {
                return 0;
            }
            return i;
        }
        return 0;
    }

    public boolean isLastPage() {
        Pagination pagination = this.header.getMsgPgntn();
        if (pagination != null) {
            return pagination.getLastPgInd().booleanValue();
        }
        return true;
    }

    public boolean isFirstPage() {
        Pagination pagination = this.header.getMsgPgntn();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            return "1".equals(pageNumber);
        }
        return true;
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getClosingDate() {
        CashBalance3 b1 = this.getBalance(Camt053BalanceCode.getClosingBalanceCodes());
        if (b1 != null) {
            return Camt053Util.getDateFromChoice(b1.getDt());
        }
        return null;
    }

    public BigDecimal getClosingBalance() {
        CashBalance3 balance = this.getBalance(Camt053BalanceCode.getClosingBalanceCodes());
        if (balance != null) {
            return Camt053Util.getAmount(balance.getAmt(), balance.getCdtDbtInd());
        }
        return null;
    }

    private CashBalance3 getBalance(String[] codes) {
        for (String code : codes) {
            for (CashBalance3 bl : this.statement.getBals()) {
                if (bl.getTp() == null || bl.getTp().getCdOrPrtry() == null || bl.getTp().getCdOrPrtry().getChoice1().getCd() == null || !code.equals(bl.getTp().getCdOrPrtry().getChoice1().getCd().getValue())) continue;
                return bl;
            }
        }
        return null;
    }

    public Date getOpeningDate() {
        CashBalance3 balance = this.getBalance(Camt053BalanceCode.getOpeningBalanceCodes());
        if (balance != null) {
            return Camt053Util.getDateFromChoice(balance.getDt());
        }
        return null;
    }

    public BigDecimal getOpeningBalance() {
        CashBalance3 b0 = this.getBalance(Camt053BalanceCode.getOpeningBalanceCodes());
        if (b0 != null) {
            return Camt053Util.getAmount(b0.getAmt(), b0.getCdtDbtInd());
        }
        return null;
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        return this.statement.getCreDtTm().getDate();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlStmtInf() != null) {
            return this.statement.getAddtlStmtInf().getValue();
        }
        return null;
    }

    public GroupHeader42 getHeader() {
        return this.header;
    }

    public AccountStatement2 getStatement() {
        return this.statement;
    }

    public static List<Camt053Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt053Statement> camt053Statements = new ArrayList<Camt053Statement>();
        BankToCustomerStatementV02 msg = d.getBkToCstmrStmt();
        GroupHeader42 header = msg.getGrpHdr();
        for (AccountStatement2 statement : msg.getStmts()) {
            camt053Statements.add(new Camt053Statement(header, statement));
        }
        return camt053Statements;
    }
}

