/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt053;

import de.businesslogics.format.camt053.Camt05300108Util;
import de.businesslogics.format.camt053.Camt053BalanceCode;
import de.businesslogics.format.iso20022.camt05300108.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05300108.AccountStatement9;
import de.businesslogics.format.iso20022.camt05300108.BankToCustomerStatementV08;
import de.businesslogics.format.iso20022.camt05300108.CashAccount39;
import de.businesslogics.format.iso20022.camt05300108.CashBalance8;
import de.businesslogics.format.iso20022.camt05300108.Document;
import de.businesslogics.format.iso20022.camt05300108.GroupHeader81;
import de.businesslogics.format.iso20022.camt05300108.Pagination1;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt05300108Statement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private GroupHeader81 header;
    private AccountStatement9 statement;

    public Camt05300108Statement() {
    }

    private Camt05300108Statement(GroupHeader81 header, AccountStatement9 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount39 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        CashBalance8 balance = this.statement.getBals().get(0);
        return Currency.getInstance(balance.getAmt().getCcy().getValue());
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination1 pagination = this.getPagination();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            int i = 0;
            try {
                i = Integer.parseInt(pageNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (i == 1 && isLastPage) {
                return 0;
            }
            return i;
        }
        return 0;
    }

    private Pagination1 getPagination() {
        Pagination1 pagination = this.statement.getStmtPgntn();
        if (pagination != null) {
            return pagination;
        }
        return this.header.getMsgPgntn();
    }

    public boolean isLastPage() {
        Pagination1 pagination = this.header.getMsgPgntn();
        if (pagination != null) {
            return pagination.getLastPgInd().booleanValue();
        }
        return true;
    }

    public boolean isFirstPage() {
        Pagination1 pagination = this.header.getMsgPgntn();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            return "1".equals(pageNumber);
        }
        return true;
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getClosingDate() {
        CashBalance8 b1 = this.getBalance(Camt053BalanceCode.getClosingBalanceCodes());
        if (b1 != null) {
            return Camt05300108Util.getDateFromChoice(b1.getDt());
        }
        return null;
    }

    public BigDecimal getClosingBalance() {
        CashBalance8 balance = this.getBalance(Camt053BalanceCode.getClosingBalanceCodes());
        if (balance != null) {
            return Camt05300108Util.getAmount(balance.getAmt(), balance.getCdtDbtInd());
        }
        return null;
    }

    private CashBalance8 getBalance(String[] codes) {
        for (String code : codes) {
            for (CashBalance8 bl : this.statement.getBals()) {
                if (bl.getTp() == null || bl.getTp().getCdOrPrtry() == null || bl.getTp().getCdOrPrtry().getChoice1().getCd() == null || !code.equals(bl.getTp().getCdOrPrtry().getChoice1().getCd().getValue())) continue;
                return bl;
            }
        }
        return null;
    }

    public Date getOpeningDate() {
        CashBalance8 balance = this.getBalance(Camt053BalanceCode.getOpeningBalanceCodes());
        if (balance != null) {
            return Camt05300108Util.getDateFromChoice(balance.getDt());
        }
        return null;
    }

    public BigDecimal getOpeningBalance() {
        CashBalance8 b0 = this.getBalance(Camt053BalanceCode.getOpeningBalanceCodes());
        if (b0 != null) {
            return Camt05300108Util.getAmount(b0.getAmt(), b0.getCdtDbtInd());
        }
        return null;
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        if (this.statement.getCreDtTm() != null) {
            return this.statement.getCreDtTm().getDate();
        }
        return this.getCreationDateFromHeader();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlStmtInf() != null) {
            return this.statement.getAddtlStmtInf().getValue();
        }
        return null;
    }

    public GroupHeader81 getHeader() {
        return this.header;
    }

    public AccountStatement9 getStatement() {
        return this.statement;
    }

    public static List<Camt05300108Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt05300108Statement> statements = new ArrayList<Camt05300108Statement>();
        BankToCustomerStatementV08 msg = d.getBkToCstmrStmt();
        GroupHeader81 header = msg.getGrpHdr();
        for (AccountStatement9 accountStatement : msg.getStmts()) {
            statements.add(new Camt05300108Statement(header, accountStatement));
        }
        return statements;
    }
}

