/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt052;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.camt052.Camt052Util;
import de.businesslogics.format.iso20022.camt05200102.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05200102.AccountReport11;
import de.businesslogics.format.iso20022.camt05200102.BankToCustomerAccountReportV02;
import de.businesslogics.format.iso20022.camt05200102.CashAccount20;
import de.businesslogics.format.iso20022.camt05200102.CashBalance3;
import de.businesslogics.format.iso20022.camt05200102.Document;
import de.businesslogics.format.iso20022.camt05200102.GroupHeader42;
import de.businesslogics.format.iso20022.camt05200102.Pagination;
import de.businesslogics.format.iso20022.camt05200102.ReportEntry2;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt052Statement {
    private GroupHeader42 header;
    private AccountReport11 statement;

    public Camt052Statement() {
    }

    private Camt052Statement(GroupHeader42 header, AccountReport11 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount20 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        if (this.statement.getNtrys().size() > 0) {
            ReportEntry2 entry = this.statement.getNtrys().get(0);
            return Currency.getInstance(entry.getAmt().getCcy().getValue());
        }
        return Currency.getInstance("EUR");
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination pagination = this.header.getMsgPgntn();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            if ("1".equals(pageNumber) && isLastPage) {
                return 0;
            }
            try {
                return Integer.parseInt(pageNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        return this.statement.getCreDtTm().getDate();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlRptInf() != null) {
            return this.statement.getAddtlRptInf().getValue();
        }
        return null;
    }

    public GroupHeader42 getHeader() {
        return this.header;
    }

    public AccountReport11 getStatement() {
        return this.statement;
    }

    public Date getClosingDate() {
        if (this.statement.getBals() == null || this.statement.getBals().size() <= 1) {
            return null;
        }
        CashBalance3 b1 = this.statement.getBals().get(1);
        return Camt052Util.getDateFromChoice(b1.getDt());
    }

    public BigDecimal getClosingBalance() {
        if (this.statement.getBals() == null || this.statement.getBals().size() <= 1) {
            return null;
        }
        CashBalance3 b1 = this.statement.getBals().get(1);
        return Camt052Util.getAmount(b1.getAmt(), b1.getCdtDbtInd());
    }

    public Date getOpeningDate() {
        if (this.statement.getBals() == null || this.statement.getBals().isEmpty()) {
            return null;
        }
        CashBalance3 b0 = this.statement.getBals().get(0);
        return Camt052Util.getDateFromChoice(b0.getDt());
    }

    public BigDecimal getOpeningBalance() {
        if (this.statement.getBals() == null || this.statement.getBals().isEmpty()) {
            return null;
        }
        CashBalance3 b0 = this.statement.getBals().get(0);
        return Camt052Util.getAmount(b0.getAmt(), b0.getCdtDbtInd());
    }

    public static List<Camt052Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt052Statement> camt052Statements = new ArrayList<Camt052Statement>();
        BankToCustomerAccountReportV02 msg = d.getBkToCstmrAcctRpt();
        GroupHeader42 header = msg.getGrpHdr();
        for (AccountReport11 statement : msg.getRpts()) {
            camt052Statements.add(new Camt052Statement(header, statement));
        }
        return camt052Statements;
    }

    @Deprecated
    public void load(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(Document.class);
        EbicsElement d = EbicsHandler.parse(in, p);
        if (d instanceof Document) {
            BankToCustomerAccountReportV02 msg = ((Document)d).getBkToCstmrAcctRpt();
            this.header = msg.getGrpHdr();
            List<AccountReport11> statements = msg.getRpts();
            if (statements.size() != 1) {
                throw new IOException("Camt052 file contains " + statements.size() + " messages. Only 1 is allowed !");
            }
            this.statement = statements.get(0);
        }
    }

    @Deprecated
    public static List<Camt052Statement> loadCamt052Statements(InputStream in) throws IOException, SAXException {
        ArrayList<Camt052Statement> camt052Statements = new ArrayList<Camt052Statement>();
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(Document.class);
        EbicsElement d = EbicsHandler.parse(in, p);
        if (d instanceof Document) {
            BankToCustomerAccountReportV02 msg = ((Document)d).getBkToCstmrAcctRpt();
            GroupHeader42 header = msg.getGrpHdr();
            for (AccountReport11 statement : msg.getRpts()) {
                camt052Statements.add(new Camt052Statement(header, statement));
            }
        }
        return camt052Statements;
    }
}

