/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt052;

import de.businesslogics.format.camt052.Camt05200108Util;
import de.businesslogics.format.iso20022.camt05200108.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05200108.AccountReport25;
import de.businesslogics.format.iso20022.camt05200108.BankToCustomerAccountReportV08;
import de.businesslogics.format.iso20022.camt05200108.CashAccount39;
import de.businesslogics.format.iso20022.camt05200108.CashBalance8;
import de.businesslogics.format.iso20022.camt05200108.Document;
import de.businesslogics.format.iso20022.camt05200108.GroupHeader81;
import de.businesslogics.format.iso20022.camt05200108.Pagination1;
import de.businesslogics.format.iso20022.camt05200108.ReportEntry10;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt05200108Statement {
    private GroupHeader81 header;
    private AccountReport25 statement;

    public Camt05200108Statement() {
    }

    private Camt05200108Statement(GroupHeader81 header, AccountReport25 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount39 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        if (this.statement.getNtrys().size() > 0) {
            ReportEntry10 entry = this.statement.getNtrys().get(0);
            return Currency.getInstance(entry.getAmt().getCcy().getValue());
        }
        return Currency.getInstance("EUR");
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination1 pagination = this.getPagination1();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            if ("1".equals(pageNumber) && isLastPage) {
                return 0;
            }
            try {
                return Integer.parseInt(pageNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private Pagination1 getPagination1() {
        Pagination1 pagination = this.statement.getRptPgntn();
        if (pagination != null) {
            return pagination;
        }
        return this.header.getMsgPgntn();
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        if (this.statement.getCreDtTm() != null) {
            return this.statement.getCreDtTm().getDate();
        }
        return this.getCreationDateFromHeader();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlRptInf() != null) {
            return this.statement.getAddtlRptInf().getValue();
        }
        return null;
    }

    public GroupHeader81 getHeader() {
        return this.header;
    }

    public AccountReport25 getStatement() {
        return this.statement;
    }

    public Date getClosingDate() {
        if (this.statement.getBals() == null || this.statement.getBals().size() <= 1) {
            return null;
        }
        CashBalance8 b1 = this.statement.getBals().get(1);
        return Camt05200108Util.getDateFromChoice(b1.getDt());
    }

    public BigDecimal getClosingBalance() {
        if (this.statement.getBals() == null || this.statement.getBals().size() <= 1) {
            return null;
        }
        CashBalance8 b1 = this.statement.getBals().get(1);
        return Camt05200108Util.getAmount(b1.getAmt(), b1.getCdtDbtInd());
    }

    public Date getOpeningDate() {
        if (this.statement.getBals() == null || this.statement.getBals().isEmpty()) {
            return null;
        }
        CashBalance8 b0 = this.statement.getBals().get(0);
        return Camt05200108Util.getDateFromChoice(b0.getDt());
    }

    public BigDecimal getOpeningBalance() {
        if (this.statement.getBals() == null || this.statement.getBals().isEmpty()) {
            return null;
        }
        CashBalance8 b0 = this.statement.getBals().get(0);
        return Camt05200108Util.getAmount(b0.getAmt(), b0.getCdtDbtInd());
    }

    public static List<Camt05200108Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt05200108Statement> camt052Statements = new ArrayList<Camt05200108Statement>();
        BankToCustomerAccountReportV08 msg = d.getBkToCstmrAcctRpt();
        GroupHeader81 header = msg.getGrpHdr();
        for (AccountReport25 statement : msg.getRpts()) {
            camt052Statements.add(new Camt05200108Statement(header, statement));
        }
        return camt052Statements;
    }
}

