/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt052;

import de.businesslogics.format.camt052.Camt05200104Util;
import de.businesslogics.format.iso20022.camt05200104.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05200104.AccountReport16;
import de.businesslogics.format.iso20022.camt05200104.BankToCustomerAccountReportV04;
import de.businesslogics.format.iso20022.camt05200104.CashAccount25;
import de.businesslogics.format.iso20022.camt05200104.CashBalance3;
import de.businesslogics.format.iso20022.camt05200104.Document;
import de.businesslogics.format.iso20022.camt05200104.GroupHeader58;
import de.businesslogics.format.iso20022.camt05200104.Pagination;
import de.businesslogics.format.iso20022.camt05200104.ReportEntry4;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt05200104Statement {
    private GroupHeader58 header;
    private AccountReport16 statement;

    public Camt05200104Statement() {
    }

    private Camt05200104Statement(GroupHeader58 header, AccountReport16 statement) {
        this.header = header;
        this.statement = statement;
    }

    public String getAccountIdentifier() {
        CashAccount25 acct = this.statement.getAcct();
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = acct.getId().getChoice1();
        if (c1.getIBAN() != null) {
            return c1.getIBAN().getValue();
        }
        return c1.getOthr().getId().getValue();
    }

    public Currency getCurrency() {
        if (this.statement.getNtrys().size() > 0) {
            ReportEntry4 entry = this.statement.getNtrys().get(0);
            return Currency.getInstance(entry.getAmt().getCcy().getValue());
        }
        return Currency.getInstance("EUR");
    }

    public String getNumber() {
        if (this.statement.getElctrncSeqNb() != null) {
            return this.statement.getElctrncSeqNb().getValue().toPlainString();
        }
        return this.getLegalNumber();
    }

    public String getLegalNumber() {
        if (this.statement.getLglSeqNb() != null) {
            return this.statement.getLglSeqNb().getValue().toPlainString();
        }
        return null;
    }

    public int getPageNumber() {
        Pagination pagination = this.getPagination();
        if (pagination != null) {
            String pageNumber = pagination.getPgNb().getValue();
            boolean isLastPage = pagination.getLastPgInd().booleanValue();
            if ("1".equals(pageNumber) && isLastPage) {
                return 0;
            }
            try {
                return Integer.parseInt(pageNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private Pagination getPagination() {
        Pagination pagination = this.statement.getRptPgntn();
        if (pagination != null) {
            return pagination;
        }
        return this.header.getMsgPgntn();
    }

    public String getMessageId() {
        return this.header.getMsgId().getValue();
    }

    public String getReference() {
        return this.statement.getId().getValue();
    }

    public Date getCreationDateFromHeader() {
        return this.header.getCreDtTm().getDate();
    }

    public Date getCreationDate() {
        return this.statement.getCreDtTm().getDate();
    }

    public String getAdditionalInfo() {
        if (this.statement.getAddtlRptInf() != null) {
            return this.statement.getAddtlRptInf().getValue();
        }
        return null;
    }

    public GroupHeader58 getHeader() {
        return this.header;
    }

    public AccountReport16 getStatement() {
        return this.statement;
    }

    public Date getClosingDate() {
        if (this.statement.getBals() == null || this.statement.getBals().size() <= 1) {
            return null;
        }
        CashBalance3 b1 = this.statement.getBals().get(1);
        return Camt05200104Util.getDateFromChoice(b1.getDt());
    }

    public BigDecimal getClosingBalance() {
        if (this.statement.getBals() == null || this.statement.getBals().size() <= 1) {
            return null;
        }
        CashBalance3 b1 = this.statement.getBals().get(1);
        return Camt05200104Util.getAmount(b1.getAmt(), b1.getCdtDbtInd());
    }

    public Date getOpeningDate() {
        if (this.statement.getBals() == null || this.statement.getBals().isEmpty()) {
            return null;
        }
        CashBalance3 b0 = this.statement.getBals().get(0);
        return Camt05200104Util.getDateFromChoice(b0.getDt());
    }

    public BigDecimal getOpeningBalance() {
        if (this.statement.getBals() == null || this.statement.getBals().isEmpty()) {
            return null;
        }
        CashBalance3 b0 = this.statement.getBals().get(0);
        return Camt05200104Util.getAmount(b0.getAmt(), b0.getCdtDbtInd());
    }

    public static List<Camt05200104Statement> loadStatements(Document d) throws IOException, SAXException {
        ArrayList<Camt05200104Statement> camt052Statements = new ArrayList<Camt05200104Statement>();
        BankToCustomerAccountReportV04 msg = d.getBkToCstmrAcctRpt();
        GroupHeader58 header = msg.getGrpHdr();
        for (AccountReport16 statement : msg.getRpts()) {
            camt052Statements.add(new Camt05200104Statement(header, statement));
        }
        return camt052Statements;
    }
}

