/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt052;

import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.camt.StrdPurposeContentHandler;
import de.businesslogics.format.camt052.Camt05200104Charges;
import de.businesslogics.format.camt052.Camt05200104Util;
import de.businesslogics.format.camt05x.BaseBooking;
import de.businesslogics.format.camt05x.ChargeRecord;
import de.businesslogics.format.iso20022.camt05200104.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.camt05200104.AmountAndCurrencyExchange3;
import de.businesslogics.format.iso20022.camt05200104.BankTransactionCodeStructure4;
import de.businesslogics.format.iso20022.camt05200104.BankTransactionCodeStructure5;
import de.businesslogics.format.iso20022.camt05200104.BatchInformation2;
import de.businesslogics.format.iso20022.camt05200104.CurrencyExchange5;
import de.businesslogics.format.iso20022.camt05200104.EntryDetails3;
import de.businesslogics.format.iso20022.camt05200104.EntryTransaction4;
import de.businesslogics.format.iso20022.camt05200104.ExternalPurpose1Code;
import de.businesslogics.format.iso20022.camt05200104.ExternalReturnReason1Code;
import de.businesslogics.format.iso20022.camt05200104.Max105Text;
import de.businesslogics.format.iso20022.camt05200104.Max140Text;
import de.businesslogics.format.iso20022.camt05200104.Max35Text;
import de.businesslogics.format.iso20022.camt05200104.PartyIdentification43;
import de.businesslogics.format.iso20022.camt05200104.ReportEntry4;
import de.businesslogics.format.iso20022.camt05200104.StructuredRemittanceInformation9;
import de.businesslogics.format.iso20022.camt05200104.TransactionAgents3;
import de.businesslogics.format.iso20022.camt05200104.TransactionParties3;
import de.businesslogics.format.iso20022.camt05200104.TransactionReferences3;
import de.businesslogics.format.swift.mt940.CMUtil;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Camt05200104Booking
extends BaseBooking {
    private final ReportEntry4 ntry;
    private final EntryDetails3 details;
    private final EntryTransaction4 transaction;
    private final BigDecimal totalChargesAmount;
    private final String totalChargesCurrencyCode;
    private final BigDecimal calculatedTotalChargesAmount;
    private final String uniqueCurrencyCode;
    private final List<ChargeRecord> chargesRecordsOnTxLevel;
    private final List<ChargeRecord> chargesRecordsOnNtryLevel;

    public Camt05200104Booking(ReportEntry4 ntry, EntryDetails3 details, EntryTransaction4 transaction) {
        BatchInformation2 batch;
        this.ntry = ntry;
        this.details = details;
        this.transaction = transaction;
        if (ntry != null) {
            this.amount = this.internalGetAmount();
            this.setHasNegativeAmount(ntry.getCdtDbtInd().getValue());
            this.currency = Currency.getInstance(ntry.getAmt().getCcy().getValue());
            this.isReversal = ntry.getRvslInd() != null ? ntry.getRvslInd().booleanValue() : false;
            this.status = ntry.getSts().getValue();
            if (ntry.getNtryRef() != null) {
                this.ntryRef = ntry.getNtryRef().getValue();
            }
        }
        if (details != null && (batch = details.getBtch()) != null && batch.getNbOfTxs() != null) {
            try {
                this.nbOfTxs = Integer.valueOf(batch.getNbOfTxs().getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Camt05200104Charges charges = null;
        if (transaction != null && transaction.getChrgs() != null) {
            charges = new Camt05200104Charges(transaction.getChrgs());
            this.chargesRecordsOnTxLevel = charges.getChargeRecords();
            this.chargesRecordsOnNtryLevel = new ArrayList<ChargeRecord>();
        } else if (ntry != null && ntry.getChrgs() != null) {
            charges = new Camt05200104Charges(ntry.getChrgs());
            this.chargesRecordsOnTxLevel = new ArrayList<ChargeRecord>();
            this.chargesRecordsOnNtryLevel = charges.getChargeRecords();
        } else {
            this.chargesRecordsOnTxLevel = new ArrayList<ChargeRecord>();
            this.chargesRecordsOnNtryLevel = new ArrayList<ChargeRecord>();
        }
        if (charges != null) {
            this.totalChargesAmount = charges.getTotalAmount();
            this.totalChargesCurrencyCode = charges.getCurrencyCode();
            this.calculatedTotalChargesAmount = charges.getCalculatedTotalAmount();
            this.uniqueCurrencyCode = charges.getUniqueCurrencyCode();
        } else {
            this.totalChargesAmount = null;
            this.totalChargesCurrencyCode = null;
            this.calculatedTotalChargesAmount = null;
            this.uniqueCurrencyCode = null;
        }
        BankTransactionCodeStructure4 btc = null;
        if (transaction != null && (btc = transaction.getBkTxCd()) != null) {
            this.extractBTC(btc);
        }
        if (btc == null && ntry != null) {
            this.extractBTC(ntry.getBkTxCd());
        }
        if (!this.isReversal) {
            this.isReversal = CMUtil.isReversal(this.getGvc());
        }
        if (transaction != null) {
            TransactionReferences3 references;
            TransactionAgents3 agents;
            TransactionParties3 parties = transaction.getRltdPties();
            if (parties != null) {
                PartyIdentification43 creditor = parties.getCdtr();
                PartyIdentification43 debtor = parties.getDbtr();
                if (this.isCounterPartyCreditor()) {
                    this.counterParty = Camt05200104Util.getPartyName(creditor);
                    this.counterPartyAccount = Camt05200104Util.getAccount(parties.getCdtrAcct());
                    this.counterPartyCreditorId = Camt05200104Util.getCreditorId(creditor);
                    this.ultimateCounterParty = Camt05200104Util.getPartyName(parties.getUltmtCdtr());
                    this.localParty = Camt05200104Util.getPartyName(debtor);
                    this.localPartyAccount = Camt05200104Util.getAccount(parties.getDbtrAcct());
                    this.localPartyCreditorId = Camt05200104Util.getCreditorId(debtor);
                    this.ultimateLocalParty = Camt05200104Util.getPartyName(parties.getUltmtDbtr());
                } else {
                    this.counterParty = Camt05200104Util.getPartyName(debtor);
                    this.counterPartyAccount = Camt05200104Util.getAccount(parties.getDbtrAcct());
                    this.counterPartyCreditorId = Camt05200104Util.getCreditorId(debtor);
                    this.ultimateCounterParty = Camt05200104Util.getPartyName(parties.getUltmtDbtr());
                    this.localParty = Camt05200104Util.getPartyName(creditor);
                    this.localPartyAccount = Camt05200104Util.getAccount(parties.getCdtrAcct());
                    this.localPartyCreditorId = Camt05200104Util.getCreditorId(creditor);
                    this.ultimateLocalParty = Camt05200104Util.getPartyName(parties.getUltmtCdtr());
                }
            }
            if ((agents = transaction.getRltdAgts()) != null) {
                if (this.isCounterPartyCreditor()) {
                    this.counterPartyBankCode = Camt05200104Util.getBic(agents.getCdtrAgt());
                    this.localPartyBankCode = Camt05200104Util.getBic(agents.getDbtrAgt());
                } else {
                    this.counterPartyBankCode = Camt05200104Util.getBic(agents.getDbtrAgt());
                    this.localPartyBankCode = Camt05200104Util.getBic(agents.getCdtrAgt());
                }
            }
            if ((references = transaction.getRefs()) != null && references.getMndtId() != null) {
                this.mandateId = transaction.getRefs().getMndtId().getValue();
            }
        }
        this.determineDirectDebitFlag();
    }

    private void extractBTC(BankTransactionCodeStructure4 btc) {
        if (btc != null) {
            BankTransactionCodeStructure5 domain = btc.getDomn();
            if (domain != null) {
                this.domainCode = domain.getCd().getValue();
                this.familyCode = domain.getFmly().getCd().getValue();
                this.subFamilyCode = domain.getFmly().getSubFmlyCd().getValue();
            }
            if (btc.getPrtry() != null) {
                this.evaluateTransactionCode(btc.getPrtry().getCd().getValue());
            }
            this.determineGvcFromISOBtc();
        }
    }

    private BigDecimal internalGetAmount() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getTxAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getTxAmt().getAmt();
            return Camt05200104Util.getAmount(amt, this.ntry.getCdtDbtInd());
        }
        return Camt05200104Util.getAmount(this.ntry.getAmt(), this.ntry.getCdtDbtInd());
    }

    @Override
    public Date getBookingDate() {
        return Camt05200104Util.getDateFromChoice(this.ntry.getBookgDt());
    }

    @Override
    public Date getValueDate() {
        return Camt05200104Util.getDateFromChoice(this.ntry.getValDt());
    }

    @Override
    public String getDtiReference() {
        if (this.ntry.getAddtlInfInd() != null && this.ntry.getAddtlInfInd().getMsgId() != null) {
            return this.ntry.getAddtlInfInd().getMsgId().getValue();
        }
        if (this.transaction != null && this.transaction.getRefs() != null) {
            String intrId = Camt05200104Util.getValue(this.transaction.getRefs().getInstrId());
            if (intrId != null && !"NOTPROVIDED".equals(intrId)) {
                return intrId;
            }
            String clrSysRef = Camt05200104Util.getValue(this.transaction.getRefs().getClrSysRef());
            if (clrSysRef != null && !"NOTPROVIDED".equals(clrSysRef)) {
                return clrSysRef;
            }
        }
        return null;
    }

    @Override
    public String getMsgId() {
        if (this.ntry.getAddtlInfInd() != null && this.ntry.getAddtlInfInd().getMsgId() != null) {
            return this.ntry.getAddtlInfInd().getMsgId().getValue();
        }
        if (this.details != null && this.details.getBtch() != null && this.details.getBtch().getMsgId() != null) {
            return this.details.getBtch().getMsgId().getValue();
        }
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getMsgId() != null) {
            return this.transaction.getRefs().getMsgId().getValue();
        }
        return null;
    }

    @Override
    public String getPmtInfId() {
        if (this.details != null && this.details.getBtch() != null && this.details.getBtch().getPmtInfId() != null) {
            return this.details.getBtch().getPmtInfId().getValue();
        }
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getPmtInfId() != null) {
            return this.transaction.getRefs().getPmtInfId().getValue();
        }
        return null;
    }

    @Override
    public String getEndToEndId() {
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getEndToEndId() != null) {
            return this.transaction.getRefs().getEndToEndId().getValue();
        }
        return null;
    }

    @Override
    public String getTransactionId() {
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getTxId() != null) {
            return this.transaction.getRefs().getTxId().getValue();
        }
        return null;
    }

    @Override
    public String getInstructionId() {
        if (this.transaction != null && this.transaction.getRefs() != null && this.transaction.getRefs().getInstrId() != null) {
            return this.transaction.getRefs().getInstrId().getValue();
        }
        return null;
    }

    @Override
    public String getBankReference() {
        if (this.ntry.getAcctSvcrRef() != null) {
            return this.ntry.getAcctSvcrRef().getValue();
        }
        return null;
    }

    @Override
    public String getAdditionalInformation() {
        List<Max105Text> list;
        String firstText = null;
        if (this.ntry.getAddtlNtryInf() != null) {
            firstText = this.ntry.getAddtlNtryInf().getValue();
        }
        if (this.transaction != null && this.transaction.getRtrInf() != null && this.transaction.getRtrInf().getAddtlInfs() != null && (list = this.transaction.getRtrInf().getAddtlInfs()) != null) {
            StringBuilder b = firstText == null ? new StringBuilder() : new StringBuilder(firstText);
            for (Max105Text t : list) {
                if (b.length() > 0) {
                    b.append('\n');
                }
                b.append(t.getValue());
            }
            return b.toString();
        }
        return firstText;
    }

    @Override
    public BigDecimal getOriginalAmount() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getInstdAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getInstdAmt().getAmt();
            return Camt05200104Util.getAmount(amt, this.ntry.getCdtDbtInd());
        }
        return null;
    }

    @Override
    public Currency getOriginalCurrency() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getInstdAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getInstdAmt().getAmt();
            return Currency.getInstance(amt.getCcy().getValue());
        }
        return null;
    }

    @Override
    public BigDecimal getConvertedAmount() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getCntrValAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getCntrValAmt().getAmt();
            return Camt05200104Util.getAmount(amt, this.ntry.getCdtDbtInd());
        }
        return null;
    }

    @Override
    public Currency getConvertedCurrency() {
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getCntrValAmt() != null) {
            ActiveOrHistoricCurrencyAndAmount amt = amtDtls.getCntrValAmt().getAmt();
            return Currency.getInstance(amt.getCcy().getValue());
        }
        return null;
    }

    @Override
    public BigDecimal getExchangeRate() {
        CurrencyExchange5 exchange;
        AmountAndCurrencyExchange3 amtDtls;
        if (this.transaction != null && (amtDtls = this.transaction.getAmtDtls()) != null && amtDtls.getCntrValAmt() != null && amtDtls.getCntrValAmt().getCcyXchg() != null && (exchange = amtDtls.getCntrValAmt().getCcyXchg()).getXchgRate() != null) {
            return exchange.getXchgRate().getValue();
        }
        return null;
    }

    @Override
    public BigDecimal getTotalChargesAmount() {
        return this.totalChargesAmount;
    }

    @Override
    public String getTotalChargesCurrencyCode() {
        return this.totalChargesCurrencyCode;
    }

    @Override
    public BigDecimal getCalculatedTotalChargesAmount() {
        return this.calculatedTotalChargesAmount;
    }

    @Override
    public String getCalculatedTotalChargesCurrencyCode() {
        return this.uniqueCurrencyCode;
    }

    @Override
    public List<ChargeRecord> getChargesRecordsOnTxLevel() {
        return this.chargesRecordsOnTxLevel;
    }

    @Override
    public List<ChargeRecord> getChargesRecordsOnNtryLevel() {
        return this.chargesRecordsOnNtryLevel;
    }

    @Override
    public String[] getPurpose() {
        if (this.transaction != null && this.transaction.getRmtInf() != null) {
            List<StructuredRemittanceInformation9> strds;
            ArrayList<String> purposeList = new ArrayList<String>();
            if (this.transaction.getRmtInf().getUstrds() != null) {
                List<Max140Text> texts = this.transaction.getRmtInf().getUstrds();
                for (Max140Text text : texts) {
                    purposeList.add(Camt05200104Util.getValue(text));
                }
            }
            if ((strds = this.transaction.getRmtInf().getStrds()) != null) {
                StructuredRemittanceInformation9 strd;
                if (strds.size() == 1 && (strd = strds.get(0)).getCdtrRefInf() != null && strd.getCdtrRefInf().getRef() != null) {
                    return new String[]{strd.getCdtrRefInf().getRef().getValue()};
                }
                for (StructuredRemittanceInformation9 s : strds) {
                    StrdPurposeContentHandler handler = new StrdPurposeContentHandler();
                    EbicsPrintStream print = new EbicsPrintStream(handler);
                    print.setPretty(false);
                    s.printOut("", print);
                    purposeList.add(handler.toString());
                }
            }
            if (!purposeList.isEmpty()) {
                return purposeList.toArray(new String[purposeList.size()]);
            }
        }
        return null;
    }

    @Override
    public String getPurposeCode() {
        if (this.transaction != null && this.transaction.getPurp() != null) {
            ExternalPurpose1Code purposeCode = this.transaction.getPurp().getChoice1().getCd();
            if (purposeCode != null) {
                return purposeCode.getValue();
            }
            Max35Text prtry = this.transaction.getPurp().getChoice1().getPrtry();
            if (prtry != null) {
                return prtry.getValue();
            }
        }
        return null;
    }

    @Override
    public String getRejectionCode() {
        ExternalReturnReason1Code code;
        if (this.transaction != null && this.transaction.getRtrInf() != null && this.transaction.getRtrInf().getRsn() != null && (code = this.transaction.getRtrInf().getRsn().getChoice1().getCd()) != null) {
            return code.getValue();
        }
        return null;
    }
}

