/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt029;

import de.businesslogics.format.camt029.Camt029LogicalFile;
import de.businesslogics.format.camt029.Camt029Notification;
import de.businesslogics.format.camt029.Camt029Transaction;
import de.businesslogics.format.dk31.camt02900106.AccountIdentification4Choice;
import de.businesslogics.format.dk31.camt02900106.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.dk31.camt02900106.AmountType4Choice;
import de.businesslogics.format.dk31.camt02900106.BICFIIdentifier;
import de.businesslogics.format.dk31.camt02900106.BranchAndFinancialInstitutionIdentification5;
import de.businesslogics.format.dk31.camt02900106.CancellationStatusReason2;
import de.businesslogics.format.dk31.camt02900106.CancellationStatusReason2Choice;
import de.businesslogics.format.dk31.camt02900106.CaseAssignment3;
import de.businesslogics.format.dk31.camt02900106.CashAccount24;
import de.businesslogics.format.dk31.camt02900106.Document;
import de.businesslogics.format.dk31.camt02900106.FinancialInstitutionIdentification8;
import de.businesslogics.format.dk31.camt02900106.InvestigationStatus3Choice;
import de.businesslogics.format.dk31.camt02900106.MandateRelatedInformation10;
import de.businesslogics.format.dk31.camt02900106.Max105Text;
import de.businesslogics.format.dk31.camt02900106.Max140Text;
import de.businesslogics.format.dk31.camt02900106.Max35Text;
import de.businesslogics.format.dk31.camt02900106.OriginalPaymentInstruction17;
import de.businesslogics.format.dk31.camt02900106.OriginalTransactionReference22;
import de.businesslogics.format.dk31.camt02900106.Party12Choice;
import de.businesslogics.format.dk31.camt02900106.PartyIdentification43;
import de.businesslogics.format.dk31.camt02900106.PaymentCancellationRejection2Code;
import de.businesslogics.format.dk31.camt02900106.PaymentTransaction67;
import de.businesslogics.format.dk31.camt02900106.PaymentTypeInformation25;
import de.businesslogics.format.dk31.camt02900106.ResolutionOfInvestigationV06;
import de.businesslogics.format.dk31.camt02900106.UnderlyingTransaction14;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.util.Currency;
import java.util.Date;
import java.util.List;

public class Camt029ExtractorV00106 {
    public static Date getCreationDate(Document document) {
        return document.getRsltnOfInvstgtn().getAssgnmt().getCreDtTm().getDate();
    }

    public static Camt029Notification getNotification(Document document) {
        ResolutionOfInvestigationV06 camt029 = document.getRsltnOfInvstgtn();
        CaseAssignment3 assignment = camt029.getAssgnmt();
        String assignmentId = assignment.getId().getValue();
        String assigner = Camt029ExtractorV00106.getPartyIdentification(assignment.getAssgnr().getChoice1());
        String assignee = Camt029ExtractorV00106.getPartyIdentification(assignment.getAssgne().getChoice1());
        Date creationDate = assignment.getCreDtTm().getDate();
        String status = Camt029ExtractorV00106.getStatus(camt029.getSts().getChoice1());
        Camt029Notification camt029Notification = new Camt029Notification(assignmentId, assigner, assignee, creationDate, status);
        for (UnderlyingTransaction14 cancellationDetail : camt029.getCxlDtlss()) {
            for (OriginalPaymentInstruction17 pmtInfDetails : cancellationDetail.getOrgnlPmtInfAndStss()) {
                Camt029LogicalFile logicalFile = new Camt029LogicalFile(pmtInfDetails.getOrgnlPmtInfId().getValue());
                logicalFile.setStatusReasonInfo(Camt029ExtractorV00106.getStatusReasonInfo(pmtInfDetails.getCxlStsRsnInfs()));
                camt029Notification.getLogicalFiles().add(logicalFile);
            }
            for (PaymentTransaction67 trxDetails : cancellationDetail.getTxInfAndStss()) {
                OriginalTransactionReference22 txRef = trxDetails.getOrgnlTxRef();
                Camt029Transaction transaction = new Camt029Transaction();
                if (trxDetails.getOrgnlEndToEndId() != null) {
                    transaction.setEndToEndId(trxDetails.getOrgnlEndToEndId().getValue());
                }
                if (trxDetails.getOrgnlInstrId() != null) {
                    transaction.setEndToEndId(trxDetails.getOrgnlInstrId().getValue());
                }
                if (trxDetails.getOrgnlTxId() != null) {
                    transaction.setEndToEndId(trxDetails.getOrgnlTxId().getValue());
                }
                transaction.setStatusReasonInfo(Camt029ExtractorV00106.getStatusReasonInfo(trxDetails.getCxlStsRsnInfs()));
                if (txRef == null) continue;
                transaction.setPaymentData(Camt029ExtractorV00106.getPaymentData(txRef));
                camt029Notification.getTransactions().add(transaction);
            }
        }
        return camt029Notification;
    }

    private static String getPartyIdentification(Party12Choice.Party12Choice_C1 choice) {
        if (choice.getAgt() != null) {
            FinancialInstitutionIdentification8 finInstId = choice.getAgt().getFinInstnId();
            if (finInstId.getBICFI() != null) {
                return finInstId.getBICFI().getValue();
            }
        } else if (choice.getPty() != null && choice.getPty().getNm() != null) {
            return choice.getPty().getNm().getValue();
        }
        return null;
    }

    private static String getStatus(InvestigationStatus3Choice.InvestigationStatus3Choice_C1 choice) {
        if (choice.getConf() != null) {
            return choice.getConf().getValue();
        }
        return null;
    }

    private static StatusReason getStatusReasonInfo(List<CancellationStatusReason2> reasonInfs) {
        if (reasonInfs != null && reasonInfs.size() > 0) {
            StatusReason statusReasonInfo = new StatusReason();
            CancellationStatusReason2 reasonInf = reasonInfs.get(0);
            CancellationStatusReason2Choice choice = reasonInf.getRsn();
            if (choice != null) {
                Max35Text prtry;
                PaymentCancellationRejection2Code code = choice.getChoice1().getCd();
                if (code != null) {
                    statusReasonInfo.setStatusReasonCode(code.getValue());
                }
                if ((prtry = choice.getChoice1().getPrtry()) != null) {
                    statusReasonInfo.setStatusReasonCode(prtry.getValue());
                }
            }
            for (Max105Text addtlInf : reasonInf.getAddtlInfs()) {
                statusReasonInfo.addAdditionalInfo(addtlInf.getValue());
            }
            return statusReasonInfo;
        }
        return null;
    }

    private static SEPAPaymentData getPaymentData(OriginalTransactionReference22 tx) {
        SEPAPaymentData paymentData = new SEPAPaymentData();
        boolean isCredit = true;
        if (tx.getReqdColltnDt() != null) {
            paymentData.setExecutionDate(tx.getReqdColltnDt().getDate());
            isCredit = false;
        } else if (tx.getReqdExctnDt() != null) {
            paymentData.setExecutionDate(tx.getReqdExctnDt().getDate());
        }
        if (isCredit) {
            paymentData.setOriginator(Camt029ExtractorV00106.getName(tx.getDbtr()));
            paymentData.setUltimateOriginator(Camt029ExtractorV00106.getName(tx.getUltmtDbtr()));
            paymentData.setOriginatorIban(Camt029ExtractorV00106.getAccountNumber(tx.getDbtrAcct()));
            paymentData.setOriginatorBic(Camt029ExtractorV00106.getBankCode(tx.getDbtrAgt()));
            paymentData.setRecipient(Camt029ExtractorV00106.getName(tx.getCdtr()));
            paymentData.setUltimateRecipient(Camt029ExtractorV00106.getName(tx.getUltmtCdtr()));
            paymentData.setRecipientIban(Camt029ExtractorV00106.getAccountNumber(tx.getCdtrAcct()));
            paymentData.setRecipientBic(Camt029ExtractorV00106.getBankCode(tx.getCdtrAgt()));
        } else {
            paymentData.setOriginator(Camt029ExtractorV00106.getName(tx.getCdtr()));
            paymentData.setUltimateOriginator(Camt029ExtractorV00106.getName(tx.getUltmtCdtr()));
            paymentData.setOriginatorIban(Camt029ExtractorV00106.getAccountNumber(tx.getCdtrAcct()));
            paymentData.setOriginatorBic(Camt029ExtractorV00106.getBankCode(tx.getCdtrAgt()));
            paymentData.setRecipient(Camt029ExtractorV00106.getName(tx.getDbtr()));
            paymentData.setUltimateRecipient(Camt029ExtractorV00106.getName(tx.getUltmtDbtr()));
            paymentData.setRecipientIban(Camt029ExtractorV00106.getAccountNumber(tx.getDbtrAcct()));
            paymentData.setRecipientBic(Camt029ExtractorV00106.getBankCode(tx.getDbtrAgt()));
            Camt029ExtractorV00106.extractDirectDebitFields(paymentData, tx);
        }
        Camt029ExtractorV00106.extractAmountAndCurrency(paymentData, tx.getAmt());
        Camt029ExtractorV00106.extractPurpose(paymentData, tx);
        paymentData.setPaymentCategory(Camt029ExtractorV00106.getPaymentCategory(tx.getPmtTpInf()));
        return paymentData;
    }

    private static String getName(PartyIdentification43 party) {
        if (party != null && party.getNm() != null) {
            return party.getNm().getValue();
        }
        return null;
    }

    private static String getAccountNumber(CashAccount24 account) {
        if (account != null) {
            AccountIdentification4Choice.AccountIdentification4Choice_C1 choice = account.getId().getChoice1();
            if (choice.getIBAN() != null) {
                return choice.getIBAN().getValue();
            }
            if (choice.getOthr() != null) {
                return choice.getOthr().getId().getValue();
            }
        }
        return null;
    }

    private static String getBankCode(BranchAndFinancialInstitutionIdentification5 agent) {
        BICFIIdentifier bic;
        if (agent != null && (bic = agent.getFinInstnId().getBICFI()) != null) {
            return bic.getValue();
        }
        return null;
    }

    private static void extractAmountAndCurrency(SEPAPaymentData paymentData, AmountType4Choice choice) {
        ActiveOrHistoricCurrencyAndAmount instdAmt;
        if (choice != null && (instdAmt = choice.getChoice1().getInstdAmt()) != null) {
            paymentData.setAmount(instdAmt.getValue());
            if (instdAmt.getCcy() != null) {
                paymentData.setCurrency(Currency.getInstance(instdAmt.getCcy().getValue()));
            }
        }
    }

    private static void extractPurpose(SEPAPaymentData paymentData, OriginalTransactionReference22 tx) {
        StringBuffer purpose = new StringBuffer();
        if (tx.getRmtInf() != null) {
            List<Max140Text> ustrds = tx.getRmtInf().getUstrds();
            if (ustrds != null && ustrds.size() > 0) {
                for (Max140Text s : ustrds) {
                    if (s == null) continue;
                    purpose.append(s.getValue());
                }
            }
            paymentData.setPurpose(purpose.toString());
            paymentData.setHasStructuredPurpose(false);
        }
    }

    private static String getPaymentCategory(PaymentTypeInformation25 pmtTpInf) {
        if (pmtTpInf != null && pmtTpInf.getCtgyPurp() != null && pmtTpInf.getCtgyPurp().getChoice1().getCd() != null) {
            return pmtTpInf.getCtgyPurp().getChoice1().getCd().getValue();
        }
        return null;
    }

    private static void extractDirectDebitFields(SEPAPaymentData paymentData, OriginalTransactionReference22 tx) {
        MandateRelatedInformation10 mndtRltdInf;
        PaymentTypeInformation25 pmtTpInf = tx.getPmtTpInf();
        if (pmtTpInf != null) {
            if (pmtTpInf.getLclInstrm() != null && pmtTpInf.getLclInstrm().getChoice1().getCd() != null) {
                paymentData.setDebitType(pmtTpInf.getLclInstrm().getChoice1().getCd().getValue());
            }
            if (pmtTpInf.getSeqTp() != null) {
                paymentData.setSequenceType(pmtTpInf.getSeqTp().getValue());
            }
        }
        if ((mndtRltdInf = tx.getMndtRltdInf()) != null) {
            if (mndtRltdInf.getMndtId() != null) {
                paymentData.setMandateId(mndtRltdInf.getMndtId().getValue());
            }
            if (mndtRltdInf.getDtOfSgntr() != null) {
                paymentData.setMandateSignDate(mndtRltdInf.getDtOfSgntr().getDate());
            }
        }
    }
}

