/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.camt029;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.camt029.Camt029ExtractorV00106;
import de.businesslogics.format.camt029.Camt029Notification;
import de.businesslogics.format.dk31.camt02900106.Document;
import de.businesslogics.format.sepa.MultipleInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt029Extractor {
    public static List<EbicsElement> getDocuments(InputStream is) throws IOException, SAXException {
        ArrayList<EbicsElement> documents = new ArrayList<EbicsElement>();
        MultipleInputStream mis = new MultipleInputStream(is);
        do {
            RootChoiceParser p = new RootChoiceParser();
            p.addPossibleRoot(Document.class);
            EbicsHandler h = new EbicsHandler(p);
            h.setValidate(false);
            documents.add(h.parse(mis));
        } while (mis.reopen());
        mis.realClose();
        return documents;
    }

    public static void addNameSpaceDecl(EbicsPrintStream eps, EbicsElement d) {
        eps.addNamespaceDecl("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private static EbicsElement getDocument(InputStream is) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(Document.class);
        return EbicsHandler.parse(is, p);
    }

    public static Date getCreationDate(EbicsElement d) {
        if (d instanceof Document) {
            return Camt029ExtractorV00106.getCreationDate((Document)d);
        }
        return null;
    }

    public static Camt029Notification getNotification(InputStream is) throws IOException, SAXException {
        EbicsElement d = Camt029Extractor.getDocument(is);
        if (d instanceof Document) {
            return Camt029ExtractorV00106.getNotification((Document)d);
        }
        throw new IOException("Unsupported Camt029 version");
    }
}

